/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.edt.ide.ui.internal.outline;

import java.util.List;
import org.eclipse.core.resources.IFile;
import org.eclipse.edt.ide.core.model.document.IEGLDocument;
import org.eclipse.edt.ide.core.model.document.IEGLModelChangeListener;
import org.eclipse.edt.ide.ui.EDTUIPlugin;
import org.eclipse.edt.ide.ui.internal.editor.EGLEditor;
import org.eclipse.edt.ide.ui.internal.outline.IOutlineAdapter;
import org.eclipse.edt.ide.ui.internal.outline.OutlineAdapterFactory;
import org.eclipse.edt.ide.ui.internal.outline.OutlineContentProvider;
import org.eclipse.edt.ide.ui.internal.outline.OutlineLabelProvider;
import org.eclipse.edt.ide.ui.internal.outline.TogglePresentationAction;
import org.eclipse.edt.ide.ui.internal.util.FileProvidingView;
import org.eclipse.jface.action.IMenuListener;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.text.IRegion;
import org.eclipse.jface.util.IPropertyChangeListener;
import org.eclipse.jface.util.ListenerList;
import org.eclipse.jface.util.PropertyChangeEvent;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.IElementComparer;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IFileEditorInput;
import org.eclipse.ui.operations.RedoActionHandler;
import org.eclipse.ui.operations.UndoActionHandler;
import org.eclipse.ui.texteditor.ITextEditor;
import org.eclipse.ui.views.contentoutline.ContentOutlinePage;

public class OutlinePage
extends ContentOutlinePage
implements IEGLModelChangeListener,
IMenuListener,
FileProvidingView {
    public static final String TOGGLE_PRESENTATION = "togglePresentation";
    private static final String[] EGLUIWEBTRANSACTION = new String[]{"egl", "ui", "webTransaction"};
    private IEGLDocument document;
    private OutlineAdapterFactory factory;
    private String fOutlinerContextMenuID;
    private IMenuManager submenu;
    private TreeViewer viewer;
    private ListenerList fSelectionChangedListeners = new ListenerList();
    private IPropertyChangeListener fPropertyChangeListener;
    private UndoActionHandler fUndo;
    private RedoActionHandler fRedo;
    private TogglePresentationAction fTogglePresentation;
    private EGLEditor editor;
    private Reconciler reconciler = new Reconciler();
    private boolean reconcilerScheduled;
    private static final int DELAY = 2000;

    public OutlinePage(IEGLDocument document, String fOutlinerContextMenuID, EGLEditor editor) {
        this.document = document;
        this.fOutlinerContextMenuID = fOutlinerContextMenuID;
        this.factory = new OutlineAdapterFactory(document, editor);
        this.editor = editor;
        document.addModelChangeListener((IEGLModelChangeListener)this);
        this.fTogglePresentation = new TogglePresentationAction();
        this.fTogglePresentation.setEditor((ITextEditor)editor);
        this.fPropertyChangeListener = new IPropertyChangeListener(){

            public void propertyChange(PropertyChangeEvent event) {
                OutlinePage.this.doPropertyChange(event);
            }
        };
        EDTUIPlugin.getDefault().getPreferenceStore().addPropertyChangeListener(this.fPropertyChangeListener);
    }

    private void doPropertyChange(PropertyChangeEvent event) {
        if (this.viewer != null && "outlinesortoption".equals(event.getProperty())) {
            this.viewer.refresh((Object)this.document.getNewModelEGLFile(), false);
        }
    }

    public void addSelectionChangedListener(ISelectionChangedListener listener) {
        this.fSelectionChangedListeners.add((Object)listener);
        if (this.viewer != null) {
            this.viewer.addPostSelectionChangedListener(listener);
        }
    }

    public void removeSelectionChangedListener(ISelectionChangedListener listener) {
        this.fSelectionChangedListeners.remove((Object)listener);
        if (this.viewer != null) {
            this.viewer.removePostSelectionChangedListener(listener);
        }
    }

    public void createControl(Composite parent) {
        super.createControl(parent);
        this.viewer = this.getTreeViewer();
        this.viewer.setContentProvider((IContentProvider)new OutlineContentProvider(this.factory));
        this.viewer.setLabelProvider((IBaseLabelProvider)new OutlineLabelProvider(this.factory));
        this.viewer.setComparer(new IElementComparer(){

            public boolean equals(Object a, Object b) {
                IOutlineAdapter aAdapter = OutlinePage.this.factory.adapt(a);
                IOutlineAdapter bAdapter = OutlinePage.this.factory.adapt(b);
                IRegion aRegion = aAdapter.getHighlightRange(a);
                IRegion bRegion = bAdapter.getHighlightRange(b);
                return aAdapter == bAdapter && aAdapter.getText(a).equalsIgnoreCase(bAdapter.getText(b)) && aRegion.equals(bRegion);
            }

            public int hashCode(Object element) {
                return OutlinePage.this.factory.adapt(element).getText(element).hashCode();
            }
        });
        Object[] listeners = this.fSelectionChangedListeners.getListeners();
        int i = 0;
        while (i < listeners.length) {
            this.fSelectionChangedListeners.remove(listeners[i]);
            this.viewer.addPostSelectionChangedListener((ISelectionChangedListener)listeners[i]);
            ++i;
        }
        this.getSite().setSelectionProvider((ISelectionProvider)this.viewer);
        this.viewer.setInput((Object)this.document.getNewModelEGLFile());
    }

    public void dispose() {
        if (this.editor == null) {
            return;
        }
        if (this.document != null) {
            this.document.removeModelChangeListener((IEGLModelChangeListener)this);
        }
        this.editor.outlinePageClosed();
        this.editor = null;
        this.fSelectionChangedListeners.clear();
        this.fSelectionChangedListeners = null;
        if (this.fPropertyChangeListener != null) {
            EDTUIPlugin.getDefault().getPreferenceStore().removePropertyChangeListener(this.fPropertyChangeListener);
            this.fPropertyChangeListener = null;
        }
        if (this.submenu != null) {
            this.submenu.dispose();
            this.submenu = null;
        }
        this.fTogglePresentation.setEditor(null);
        this.viewer = null;
        super.dispose();
    }

    public IEGLDocument getDocument() {
        return this.document;
    }

    public EGLEditor getEditor() {
        return this.editor;
    }

    public TreeViewer getTreeViewer() {
        return super.getTreeViewer();
    }

    public void menuAboutToShow(IMenuManager menuManager) {
        if (this.submenu != null) {
            this.submenu.updateAll(true);
        }
    }

    public void select(Object reference) {
        IStructuredSelection ss;
        List elements;
        ISelection s;
        if (this.viewer != null && (s = this.viewer.getSelection()) instanceof IStructuredSelection && !(elements = (ss = (IStructuredSelection)s).toList()).contains(reference)) {
            s = reference == null ? StructuredSelection.EMPTY : new StructuredSelection(reference);
            this.viewer.setSelection(s, true);
        }
    }

    public void modelChanged() {
        if (!this.reconcilerScheduled && this.getTreeViewer() != null && !this.getTreeViewer().getControl().isDisposed()) {
            this.getTreeViewer().getControl().getDisplay().timerExec(2000, (Runnable)this.reconciler);
        }
    }

    public IEditorInput getEditorInput() {
        return this.editor.getEditorInput();
    }

    public void setInput(IEGLDocument newDocument) {
        if (this.document != null) {
            this.document.removeModelChangeListener((IEGLModelChangeListener)this);
        }
        this.document = newDocument;
        if (this.document != null) {
            this.document.addModelChangeListener((IEGLModelChangeListener)this);
        }
        if (this.viewer != null) {
            this.viewer.setInput((Object)newDocument.getNewModelEGLFile());
        }
    }

    public void refresh() {
        if (this.getTreeViewer() != null) {
            this.document.reconcile();
            this.getTreeViewer().refresh((Object)this.document.getNewModelEGLFile(), true);
        }
    }

    @Override
    public IFile getFile() {
        return ((IFileEditorInput)this.getEditorInput()).getFile();
    }

    private class Reconciler
    implements Runnable {
        private Reconciler() {
        }

        @Override
        public void run() {
            long currentTime = System.currentTimeMillis();
            if (currentTime - OutlinePage.this.document.getLastUpdateTime() < 2000L) {
                if (!OutlinePage.this.getTreeViewer().getControl().isDisposed()) {
                    OutlinePage.this.getTreeViewer().getControl().getDisplay().timerExec(2000, (Runnable)OutlinePage.this.reconciler);
                }
                return;
            }
            if (!OutlinePage.this.getTreeViewer().getControl().isDisposed()) {
                OutlinePage.this.getTreeViewer().getControl().setRedraw(false);
                OutlinePage.this.document.reconcile();
                OutlinePage.this.getTreeViewer().refresh((Object)OutlinePage.this.document.getNewModelEGLFile(), true);
                OutlinePage.this.getTreeViewer().getControl().setRedraw(true);
            }
            OutlinePage.this.reconcilerScheduled = false;
        }
    }
}

