/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.edt.ide.ui.internal.packageexplorer;

import org.eclipse.core.resources.IFile;
import org.eclipse.edt.ide.core.model.EGLCore;
import org.eclipse.edt.ide.core.model.IClassFile;
import org.eclipse.edt.ide.core.model.IEGLElement;
import org.eclipse.edt.ide.ui.internal.editor.BinaryEditorInput;
import org.eclipse.edt.ide.ui.internal.util.EditorUtility;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IFileEditorInput;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.navigator.ILinkHelper;

public class EGLEditorLinkHelper
implements ILinkHelper {
    public IStructuredSelection findSelection(IEditorInput input) {
        IFile inputElement = null;
        IEGLElement eglElement = null;
        if (input instanceof IFileEditorInput) {
            inputElement = ((IFileEditorInput)input).getFile();
            return inputElement != null && (eglElement = EGLCore.create((IFile)inputElement)) != null ? new StructuredSelection((Object)eglElement) : StructuredSelection.EMPTY;
        }
        if (input instanceof BinaryEditorInput) {
            inputElement = ((BinaryEditorInput)input).getClassFile();
            return inputElement != null && (eglElement = (IClassFile)inputElement) != null ? new StructuredSelection((Object)eglElement) : StructuredSelection.EMPTY;
        }
        return StructuredSelection.EMPTY;
    }

    public void activateEditor(IWorkbenchPage aPage, IStructuredSelection aSelection) {
        if (aSelection == null || aSelection.isEmpty()) {
            return;
        }
        Object element = aSelection.getFirstElement();
        IEditorPart part = EditorUtility.isOpenInEditor(element);
        if (part != null) {
            aPage.bringToTop((IWorkbenchPart)part);
            if (element instanceof IEGLElement) {
                EditorUtility.revealInEditor(part, (IEGLElement)element);
            }
        }
    }
}

