/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.edt.ide.deployment.services.operation;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.StringWriter;
import java.io.UnsupportedEncodingException;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.datatools.connectivity.IConnectionProfile;
import org.eclipse.datatools.connectivity.ProfileManager;
import org.eclipse.edt.ide.deployment.core.model.DeploymentDesc;
import org.eclipse.edt.ide.deployment.internal.web.WebXML;
import org.eclipse.edt.ide.deployment.internal.web.WebXMLManager;
import org.eclipse.edt.ide.deployment.operation.AbstractDeploymentOperation;
import org.eclipse.edt.ide.deployment.results.DeploymentResultMessageRequestor;
import org.eclipse.edt.ide.deployment.results.IDeploymentResultsCollector;
import org.eclipse.edt.ide.deployment.services.generators.ServiceUtilities;
import org.eclipse.edt.ide.deployment.solution.DeploymentContext;
import org.eclipse.edt.ide.deployment.utilities.DeploymentUtilities;
import org.eclipse.edt.ide.internal.sql.util.EGLSQLUtility;
import org.eclipse.edt.ide.ui.internal.util.CoreUtility;
import org.eclipse.edt.javart.resources.egldd.Binding;
import org.eclipse.edt.javart.resources.egldd.SQLDatabaseBinding;
import org.eclipse.jst.j2ee.common.CommonFactory;
import org.eclipse.jst.j2ee.common.ResAuthTypeBase;
import org.eclipse.jst.j2ee.common.ResSharingScopeType;
import org.eclipse.jst.j2ee.common.ResourceRef;
import org.eclipse.wst.common.componentcore.ComponentCore;
import org.eclipse.wst.common.componentcore.resources.IVirtualComponent;
import org.w3c.dom.Attr;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class ConfigureDataSourcesOperation
extends AbstractDeploymentOperation {
    DeploymentResultMessageRequestor messageRequestor;
    private WebXML webXML;
    private boolean contextDotXMLUpdated;
    private boolean resourceRefAdded;
    private IProject targetProject;
    private Document contextDoc;
    private IFile contextFile;

    public void execute(DeploymentContext context, IDeploymentResultsCollector resultsCollector, IProgressMonitor monitor) throws CoreException {
        this.messageRequestor = new DeploymentResultMessageRequestor(resultsCollector);
        this.targetProject = context.getTargetProject();
        this.webXML = WebXMLManager.instance.getWebXMLUtil(this.targetProject);
        this.addResourceRefs(context.getDeploymentDesc());
        for (DeploymentDesc nextDD : context.getDependentModels()) {
            this.addResourceRefs(nextDD);
        }
        if (ServiceUtilities.isTomcatProject(this.targetProject)) {
            this.updateContextDotXML(context.getDeploymentDesc());
            for (DeploymentDesc nextDD : context.getDependentModels()) {
                this.updateContextDotXML(nextDD);
            }
            if (this.contextDotXMLUpdated) {
                try {
                    this.saveContextDoc();
                    this.messageRequestor.addMessage(DeploymentUtilities.createEGLDeploymentInformationalMessage((String)"8332", null, (String[])new String[]{this.contextFile.getName()}));
                }
                catch (Exception e) {
                    this.messageRequestor.addMessage(DeploymentUtilities.createEGLDeploymentErrorMessage((String)"8331", null, (String[])new String[]{this.contextFile.getName(), DeploymentUtilities.createExceptionMessage((Throwable)e)}));
                }
            }
        } else {
            this.messageRequestor.addMessage(DeploymentUtilities.createEGLDeploymentInformationalMessage((String)"8333", null, null));
        }
        if (this.resourceRefAdded) {
            WebXMLManager.instance.updateModel(this.targetProject);
            this.messageRequestor.addMessage(DeploymentUtilities.createEGLDeploymentInformationalMessage((String)"8329", null, null));
        }
    }

    private void addResourceRefs(DeploymentDesc ddModel) {
        for (Binding binding : ddModel.getBindings()) {
            SQLDatabaseBinding sqlBinding;
            if (!(binding instanceof SQLDatabaseBinding) || !(sqlBinding = (SQLDatabaseBinding)binding).isDeployAsJndi()) continue;
            this.addResourceRef(sqlBinding.getJndiName(), sqlBinding.isApplicationAuthentication());
        }
    }

    private void addResourceRef(String name, boolean applicationAuth) {
        if (name != null && (name = name.trim()).length() > 0) {
            ResourceRef ref = CommonFactory.eINSTANCE.createResourceRef();
            ref.setName(name);
            ref.setAuth(applicationAuth ? ResAuthTypeBase.APPLICATION_LITERAL : ResAuthTypeBase.CONTAINER_LITERAL);
            ref.setType("javax.sql.DataSource");
            ref.setResSharingScope(ResSharingScopeType.SHAREABLE_LITERAL);
            this.webXML.addResourceRef(ref);
            this.resourceRefAdded = true;
        }
    }

    private void updateContextDotXML(DeploymentDesc ddModel) {
        for (Binding binding : ddModel.getBindings()) {
            SQLDatabaseBinding sqlBinding;
            if (!(binding instanceof SQLDatabaseBinding) || !(sqlBinding = (SQLDatabaseBinding)binding).isDeployAsJndi()) continue;
            String jndiName = sqlBinding.getJndiName();
            if (jndiName == null || (jndiName = jndiName.trim()).length() == 0) {
                jndiName = "jdbc/" + binding.getName();
            }
            try {
                if (binding.isUseURI()) {
                    IConnectionProfile profile;
                    String uri = binding.getUri();
                    if (uri == null || !uri.startsWith("workspace://") || (profile = ProfileManager.getInstance().getProfileByName(uri.substring(12))) == null) continue;
                    this.configureDataSource(EGLSQLUtility.getSQLUserId((IConnectionProfile)profile), EGLSQLUtility.getSQLPassword((IConnectionProfile)profile), EGLSQLUtility.getSQLJDBCDriverClassPreference((IConnectionProfile)profile), EGLSQLUtility.getSQLConnectionURLPreference((IConnectionProfile)profile), jndiName, sqlBinding.isApplicationAuthentication());
                    continue;
                }
                this.configureDataSource(sqlBinding.getSqlID(), sqlBinding.getSqlPassword(), sqlBinding.getSqlJDBCDriverClass(), sqlBinding.getSqlDB(), jndiName, sqlBinding.isApplicationAuthentication());
            }
            catch (Exception e) {
                this.messageRequestor.addMessage(DeploymentUtilities.createEGLDeploymentErrorMessage((String)"8330", null, (String[])new String[]{DeploymentUtilities.createExceptionMessage((Throwable)e)}));
            }
        }
    }

    private void configureDataSource(String user, String pass, String driverClass, String url, String jndiName, boolean applicationAuth) throws Exception {
        if (this.notEmpty(jndiName) && this.notEmpty(url) && this.notEmpty(driverClass)) {
            if (user == null) {
                user = "";
            }
            if (pass == null) {
                pass = "";
            }
            this.initContextDoc();
            NodeList rootKids = this.contextDoc.getChildNodes();
            Node contextNode = null;
            int rootSize = rootKids.getLength();
            int i = 0;
            while (contextNode == null && i < rootSize) {
                Node next = rootKids.item(i);
                String name = next.getNodeName();
                if ("Context".equalsIgnoreCase(name)) {
                    contextNode = next;
                }
                ++i;
            }
            if (contextNode == null) {
                contextNode = this.contextDoc.createElement("Context");
                this.contextDoc.appendChild(contextNode);
            }
            boolean found = false;
            NodeList contextKids = contextNode.getChildNodes();
            int kidSize = contextKids.getLength();
            int i2 = 0;
            while (!found && i2 < kidSize) {
                NamedNodeMap attrs;
                Node nameAttr;
                Node nextKid = contextKids.item(i2);
                String name = nextKid.getNodeName();
                if ("Resource".equalsIgnoreCase(name) && (nameAttr = (attrs = nextKid.getAttributes()).getNamedItem("name")) != null && jndiName.equals(nameAttr.getNodeValue())) {
                    found = true;
                    this.updateAttr("username", user, attrs);
                    this.updateAttr("password", pass, attrs);
                    this.updateAttr("driverClassName", driverClass, attrs);
                    this.updateAttr("url", url, attrs);
                    this.updateAttr("auth", applicationAuth ? "Application" : "Container", attrs);
                }
                ++i2;
            }
            if (!found) {
                Element newChild = this.contextDoc.createElement("Resource");
                NamedNodeMap attrs = newChild.getAttributes();
                this.createAttr("name", jndiName, attrs);
                this.createAttr("username", user, attrs);
                this.createAttr("password", pass, attrs);
                this.createAttr("driverClassName", driverClass, attrs);
                this.createAttr("url", url, attrs);
                this.createAttr("maxActive", "4", attrs);
                this.createAttr("maxIdle", "2", attrs);
                this.createAttr("maxWait", "5000", attrs);
                this.createAttr("auth", applicationAuth ? "Application" : "Container", attrs);
                this.createAttr("type", "javax.sql.DataSource", attrs);
                contextNode.appendChild(newChild);
                this.contextDotXMLUpdated = true;
            }
        }
    }

    private void updateAttr(String name, String value, NamedNodeMap attrs) {
        Node attr = attrs.getNamedItem(name);
        if (attr == null) {
            attr = this.contextDoc.createAttribute(name);
            attrs.setNamedItem(attr);
            attr.setNodeValue(value);
            this.contextDotXMLUpdated = true;
        } else if (!value.equals(attr.getNodeValue())) {
            attr.setNodeValue(value);
            this.contextDotXMLUpdated = true;
        }
    }

    private void createAttr(String name, String value, NamedNodeMap attrs) {
        Attr attr = this.contextDoc.createAttribute(name);
        attr.setValue(value);
        attrs.setNamedItem(attr);
    }

    private boolean notEmpty(String value) {
        return value != null && value.trim().length() != 0;
    }

    private IFile getContextDotXMLFile(IProject project) throws CoreException {
        IVirtualComponent component = ComponentCore.createComponent((IProject)project);
        IFolder metaInfFolder = project.getFolder(component.getRootFolder().getFolder("META-INF").getProjectRelativePath());
        if (!metaInfFolder.exists()) {
            CoreUtility.createFolder((IFolder)metaInfFolder, (boolean)true, (boolean)true, null);
        }
        return metaInfFolder.getFile("context.xml");
    }

    private void initContextDoc() throws Exception {
        if (this.contextDoc == null) {
            DocumentBuilderFactory docFactory = DocumentBuilderFactory.newInstance();
            DocumentBuilder docBuilder = docFactory.newDocumentBuilder();
            this.contextFile = this.getContextDotXMLFile(this.targetProject);
            this.contextDoc = !this.contextFile.exists() ? docBuilder.newDocument() : docBuilder.parse(this.contextFile.getContents(true));
        }
    }

    private void saveContextDoc() throws Exception {
        ByteArrayInputStream inputStream;
        Transformer transformer = TransformerFactory.newInstance().newTransformer();
        transformer.setOutputProperty("indent", "yes");
        StreamResult result = new StreamResult(new StringWriter());
        transformer.transform(new DOMSource(this.contextDoc), result);
        String contents = result.getWriter().toString();
        try {
            String encoding = this.contextDoc.getXmlEncoding();
            if (encoding == null || encoding.length() == 0) {
                encoding = "UTF-8";
            }
            inputStream = new ByteArrayInputStream(contents.getBytes(encoding));
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            inputStream = new ByteArrayInputStream(contents.getBytes());
        }
        try {
            if (!this.contextFile.exists()) {
                this.contextFile.create((InputStream)inputStream, true, null);
            } else {
                this.contextFile.setContents((InputStream)inputStream, true, true, null);
            }
        }
        catch (Throwable throwable) {
            try {
                inputStream.close();
            }
            catch (IOException iOException) {}
            throw throwable;
        }
        try {
            inputStream.close();
        }
        catch (IOException iOException) {}
    }
}

