/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.edt.debug.internal.core.java;

import org.eclipse.edt.debug.core.java.SMAPLineInfo;

public class SMAPLineParser {
    public static SMAPLineInfo parse(String smap) {
        String line;
        int lineBreak;
        if (smap.length() == 0) {
            return null;
        }
        int index = smap.indexOf("*L");
        if (index == -1) {
            return null;
        }
        if ((index = smap.indexOf(10, index)) == -1) {
            return null;
        }
        ++index;
        SMAPLineInfo lineInfo = new SMAPLineInfo();
        while ((lineBreak = smap.indexOf(10, index)) != -1 && ((line = smap.substring(index, lineBreak)).length() <= 0 || line.charAt(0) != '*')) {
            SMAPLineParser.parseLine(line, lineInfo);
            index = lineBreak + 1;
        }
        return lineInfo;
    }

    private static void parseLine(String line, SMAPLineInfo lineInfo) {
        int colon = line.indexOf(58);
        if (colon == -1) {
            return;
        }
        int repeatCount = 1;
        int javaLineIncrement = 1;
        try {
            int javaStartLine;
            int eglStartLine;
            int pound = line.indexOf(35);
            int comma = line.indexOf(44);
            if (pound == -1) {
                if (comma != -1 && comma < colon) {
                    eglStartLine = Integer.parseInt(line.substring(0, comma));
                    repeatCount = Integer.parseInt(line.substring(comma + 1, colon));
                } else {
                    eglStartLine = Integer.parseInt(line.substring(0, colon));
                }
            } else {
                eglStartLine = Integer.parseInt(line.substring(0, pound));
                if (comma != -1 && comma < colon) {
                    repeatCount = Integer.parseInt(line.substring(comma + 1, colon));
                }
            }
            if (comma != -1 && comma < colon) {
                comma = line.indexOf(44, comma + 1);
            }
            if (comma == -1) {
                javaStartLine = Integer.parseInt(line.substring(colon + 1));
            } else {
                javaStartLine = Integer.parseInt(line.substring(colon + 1, comma));
                javaLineIncrement = Integer.parseInt(line.substring(comma + 1));
            }
            lineInfo.addMappings(repeatCount, eglStartLine, javaStartLine, javaLineIncrement);
        }
        catch (NumberFormatException numberFormatException) {}
    }
}

