/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.edt.ide.rui.document.utils;

import org.eclipse.core.resources.IFile;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.edt.compiler.core.ast.DefaultASTVisitor;
import org.eclipse.edt.compiler.core.ast.Handler;
import org.eclipse.edt.compiler.core.ast.IASTVisitor;
import org.eclipse.edt.compiler.core.ast.NewExpression;
import org.eclipse.edt.compiler.core.ast.Node;
import org.eclipse.edt.compiler.core.ast.QualifiedName;
import org.eclipse.edt.compiler.core.ast.SimpleName;
import org.eclipse.edt.ide.core.model.EGLCore;
import org.eclipse.edt.ide.core.model.EGLModelException;
import org.eclipse.edt.ide.core.model.IEGLFile;
import org.eclipse.edt.ide.core.model.document.IEGLDocument;
import org.eclipse.edt.ide.rui.document.utils.DeleteWidgetReferenceOperation;
import org.eclipse.edt.ide.rui.document.utils.DocumentUtil;
import org.eclipse.edt.ide.rui.document.utils.EGLContainerLocatorStrategy;
import org.eclipse.edt.ide.rui.document.utils.EGLRUIHandlerLocatorStrategy;
import org.eclipse.edt.ide.rui.document.utils.InsertWidgetReferenceOperation;
import org.eclipse.edt.ide.rui.internal.Activator;
import org.eclipse.edt.ide.ui.internal.EGLUI;
import org.eclipse.jface.text.BadLocationException;

public class MoveWidgetReferenceOperation {
    private IEGLDocument currentDocument;
    private IFile currentFile;
    private int[] charactersChanged = new int[2];

    public MoveWidgetReferenceOperation(IEGLDocument currentDocument, IFile currentFile) {
        this.currentDocument = currentDocument;
        this.currentFile = currentFile;
    }

    public int[] moveWidget(final int oldContainerOffset, final int oldContainerLength, final int oldContainerIndex, final int newContainerOffset, int newContainerLength, final int newContainerIndex) {
        try {
            IEGLFile modelFile = (IEGLFile)EGLCore.create((IFile)this.currentFile);
            IEGLFile sharedWorkingCopy = (IEGLFile)modelFile.getSharedWorkingCopy(null, EGLUI.getBufferFactory(), null);
            sharedWorkingCopy.open(null);
            sharedWorkingCopy.reconcile(false, null);
            try {
                try {
                    final Node oldContainer = DocumentUtil.getWidgetNode(this.currentDocument, oldContainerOffset, oldContainerLength);
                    Node newContainer = DocumentUtil.getWidgetNode(this.currentDocument, newContainerOffset, newContainerLength);
                    final int newIndex = this.calculateNewIndex(oldContainer, newContainer, oldContainerIndex, newContainerIndex);
                    oldContainer.accept((IASTVisitor)new DefaultASTVisitor(){

                        public boolean visit(Handler handler) {
                            EGLRUIHandlerLocatorStrategy strategy = new EGLRUIHandlerLocatorStrategy(handler);
                            Node nodeToMove = strategy.locateIndex(oldContainerIndex);
                            MoveNodeOperation moveOp = new MoveNodeOperation(oldContainerOffset, oldContainerLength, oldContainerIndex, newContainerOffset, newContainerIndex, newIndex);
                            nodeToMove.accept((IASTVisitor)moveOp);
                            return false;
                        }

                        public boolean visit(NewExpression newExpression) {
                            EGLContainerLocatorStrategy strategy = new EGLContainerLocatorStrategy(oldContainer);
                            Node nodeToMove = strategy.locateIndex(oldContainerIndex);
                            MoveNodeOperation moveOp = new MoveNodeOperation(oldContainerOffset, oldContainerLength, oldContainerIndex, newContainerOffset, newContainerIndex, newIndex);
                            nodeToMove.accept((IASTVisitor)moveOp);
                            return false;
                        }

                        public boolean visit(SimpleName simpleName) {
                            EGLContainerLocatorStrategy strategy = new EGLContainerLocatorStrategy(oldContainer);
                            Node nodeToMove = strategy.locateIndex(oldContainerIndex);
                            MoveNodeOperation moveOp = new MoveNodeOperation(oldContainerOffset, oldContainerLength, oldContainerIndex, newContainerOffset, newContainerIndex, newIndex);
                            nodeToMove.accept((IASTVisitor)moveOp);
                            return false;
                        }
                    });
                }
                catch (Exception e) {
                    Activator.getDefault().getLog().log((IStatus)new Status(4, "org.eclipse.edt.ide.rui", "Move Widget Reference: Error moving reference", (Throwable)e));
                    sharedWorkingCopy.destroy();
                }
            }
            finally {
                sharedWorkingCopy.destroy();
            }
        }
        catch (EGLModelException e) {
            Activator.getDefault().getLog().log((IStatus)new Status(4, "org.eclipse.edt.ide.rui", "Move Widget Reference: Error creating working copy", (Throwable)e));
        }
        return this.charactersChanged;
    }

    private int calculateNewIndex(Node oldContainer, Node newContainer, int oldIndex, int newIndex) {
        int result = newIndex;
        if (oldContainer == newContainer && newIndex > oldIndex) {
            result = newIndex - 1;
        }
        return result;
    }

    private class MoveNodeOperation
    extends DefaultASTVisitor {
        private int newContainerOffset;
        private int newContainerLength;
        private int newContainerIndex;
        private int oldContainerOffset;
        private int oldContainerLength;
        private int oldContainerIndex;

        public MoveNodeOperation(int oldContainerOffset, int oldContainerLength, int oldContainerIndex, int newContainerOffset, int newContainerLength, int newContainerIndex) {
            this.oldContainerOffset = oldContainerOffset;
            this.oldContainerLength = oldContainerLength;
            this.oldContainerIndex = oldContainerIndex;
            this.newContainerOffset = newContainerOffset;
            this.newContainerLength = newContainerLength;
            this.newContainerIndex = newContainerIndex;
        }

        public boolean visit(NewExpression newExpression) {
            try {
                String widgetText = MoveWidgetReferenceOperation.this.currentDocument.get(newExpression.getOffset(), newExpression.getLength());
                DeleteWidgetReferenceOperation deleteOp = new DeleteWidgetReferenceOperation(MoveWidgetReferenceOperation.this.currentDocument, MoveWidgetReferenceOperation.this.currentFile);
                ((MoveWidgetReferenceOperation)MoveWidgetReferenceOperation.this).charactersChanged[0] = deleteOp.deleteWidgetReference(this.oldContainerOffset, this.oldContainerLength, this.oldContainerIndex);
                int theOffset = this.newContainerOffset;
                if (this.newContainerOffset > newExpression.getOffset()) {
                    theOffset = this.newContainerOffset - MoveWidgetReferenceOperation.this.charactersChanged[0];
                }
                ((MoveWidgetReferenceOperation)MoveWidgetReferenceOperation.this).charactersChanged[1] = new InsertWidgetReferenceOperation(MoveWidgetReferenceOperation.this.currentDocument, MoveWidgetReferenceOperation.this.currentFile).insertWidgetReference(widgetText, theOffset, this.newContainerLength, this.newContainerIndex);
            }
            catch (BadLocationException e) {
                Activator.getDefault().getLog().log((IStatus)new Status(4, "org.eclipse.edt.ide.rui", "Move Widget Reference: Error getting text for New Expression", (Throwable)e));
            }
            return false;
        }

        public boolean visit(SimpleName simpleName) {
            String widgetText = simpleName.getIdentifier();
            DeleteWidgetReferenceOperation deleteOp = new DeleteWidgetReferenceOperation(MoveWidgetReferenceOperation.this.currentDocument, MoveWidgetReferenceOperation.this.currentFile);
            ((MoveWidgetReferenceOperation)MoveWidgetReferenceOperation.this).charactersChanged[0] = deleteOp.deleteWidgetReference(this.oldContainerOffset, this.oldContainerLength, this.oldContainerIndex);
            int theOffset = this.newContainerOffset;
            if (this.newContainerOffset > simpleName.getOffset()) {
                theOffset = this.newContainerOffset - MoveWidgetReferenceOperation.this.charactersChanged[0];
            }
            ((MoveWidgetReferenceOperation)MoveWidgetReferenceOperation.this).charactersChanged[1] = new InsertWidgetReferenceOperation(MoveWidgetReferenceOperation.this.currentDocument, MoveWidgetReferenceOperation.this.currentFile).insertWidgetReference(widgetText, theOffset, this.newContainerLength, this.newContainerIndex);
            return false;
        }

        public boolean visit(QualifiedName qualifiedName) {
            String widgetText = qualifiedName.getCanonicalName();
            DeleteWidgetReferenceOperation deleteOp = new DeleteWidgetReferenceOperation(MoveWidgetReferenceOperation.this.currentDocument, MoveWidgetReferenceOperation.this.currentFile);
            ((MoveWidgetReferenceOperation)MoveWidgetReferenceOperation.this).charactersChanged[0] = deleteOp.deleteWidgetReference(this.oldContainerOffset, this.oldContainerLength, this.oldContainerIndex);
            int theOffset = this.newContainerOffset;
            if (this.newContainerOffset > qualifiedName.getOffset()) {
                theOffset = this.newContainerOffset - MoveWidgetReferenceOperation.this.charactersChanged[0];
            }
            ((MoveWidgetReferenceOperation)MoveWidgetReferenceOperation.this).charactersChanged[1] = new InsertWidgetReferenceOperation(MoveWidgetReferenceOperation.this.currentDocument, MoveWidgetReferenceOperation.this.currentFile).insertWidgetReference(widgetText, theOffset, this.newContainerLength, this.newContainerIndex);
            return false;
        }
    }
}

