/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.edt.ide.rui.visualeditor.internal.wizards.insertwidget;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.eclipse.core.resources.IProject;
import org.eclipse.edt.ide.rui.visualeditor.internal.editor.EvHelp;
import org.eclipse.edt.ide.rui.visualeditor.internal.nl.Messages;
import org.eclipse.edt.ide.rui.visualeditor.internal.nl.Tooltips;
import org.eclipse.edt.ide.rui.visualeditor.internal.views.dataview.model.PageDataNode;
import org.eclipse.edt.ide.rui.visualeditor.internal.wizards.insertwidget.InsertDataModel;
import org.eclipse.edt.ide.rui.visualeditor.internal.wizards.insertwidget.InsertDataModelBuilder;
import org.eclipse.edt.ide.rui.visualeditor.internal.wizards.insertwidget.InsertDataNode;
import org.eclipse.edt.ide.rui.visualeditor.internal.wizards.insertwidget.InsertWidgetWizardUtil;
import org.eclipse.edt.ide.rui.visualeditor.internal.wizards.insertwidget.WidgetType;
import org.eclipse.edt.ide.rui.visualeditor.internal.wizards.util.EGLNameValidator;
import org.eclipse.edt.ide.rui.visualeditor.internal.wizards.util.NameFinder;
import org.eclipse.edt.ide.rui.visualeditor.plugin.Activator;
import org.eclipse.jface.viewers.CellEditor;
import org.eclipse.jface.viewers.CellLabelProvider;
import org.eclipse.jface.viewers.CheckStateChangedEvent;
import org.eclipse.jface.viewers.CheckboxTreeViewer;
import org.eclipse.jface.viewers.ColumnLabelProvider;
import org.eclipse.jface.viewers.ColumnLayoutData;
import org.eclipse.jface.viewers.ColumnViewer;
import org.eclipse.jface.viewers.ColumnWeightData;
import org.eclipse.jface.viewers.ComboBoxCellEditor;
import org.eclipse.jface.viewers.EditingSupport;
import org.eclipse.jface.viewers.ICheckStateListener;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.TableLayout;
import org.eclipse.jface.viewers.TextCellEditor;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.jface.viewers.TreeViewerColumn;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.wizard.WizardPage;
import org.eclipse.swt.custom.CCombo;
import org.eclipse.swt.events.KeyEvent;
import org.eclipse.swt.events.KeyListener;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.layout.RowLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Tree;
import org.eclipse.swt.widgets.TreeItem;
import org.eclipse.swt.widgets.Widget;
import org.eclipse.ui.IEditorInput;

public class InsertWidgetWizardPage
extends WizardPage {
    private CheckboxTreeViewer configureWidgetsTableViewer;
    private InsertDataModel insertDataModel;
    private String purpose;
    private ErrorMessageManager errorMessageManager;
    private Object[] checkedElements;
    private boolean isFirstDisplay = true;
    private Button isAddFormattingAndValidationButton;
    private Button isAddErrorMessageButton;
    private Button upButton;
    private Button downButton;
    private Button displayWidgetsButton;
    private Button createWidgetsButton;
    private Button updateWidgetsButton;

    protected InsertWidgetWizardPage(PageDataNode selectedDataItem, IProject project, IEditorInput editorInput) {
        super(Messages.NL_IWWP_Title);
        this.setTitle(Messages.NL_IWWP_Title);
        this.setDescription(Messages.NL_IWWP_Description);
        this.purpose = "FOR_DISPLAY";
        this.errorMessageManager = new ErrorMessageManager();
        NameFinder.getInstance().initralize(editorInput);
        this.insertDataModel = InsertDataModelBuilder.getInstance().create(selectedDataItem, project, editorInput);
        this.insertDataModel.setPurpose(this.purpose);
    }

    public CheckboxTreeViewer getConfigureWidgetsTableViewer() {
        return this.configureWidgetsTableViewer;
    }

    public void createControl(Composite parent) {
        EvHelp.setHelp((Control)parent, EvHelp.INSERT_WIDGET_WIZARD);
        Composite composite = new Composite(parent, 0);
        composite.setLayout((Layout)new GridLayout(1, false));
        Label createWidgetsLabel = new Label(composite, 0);
        createWidgetsLabel.setText(Messages.NL_IWWP_Create_Widgets_Label);
        this.displayWidgetsButton = new Button(composite, 16);
        this.displayWidgetsButton.setText(Messages.NL_IWWP_Display_Widgets_Button);
        SelectionListener listener = new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                if (InsertWidgetWizardPage.this.displayWidgetsButton.getSelection()) {
                    InsertWidgetWizardPage.this.isAddFormattingAndValidationButton.setSelection(true);
                    InsertWidgetWizardPage.this.isAddFormattingAndValidationButton.setEnabled(true);
                    InsertWidgetWizardPage.this.isAddErrorMessageButton.setSelection(false);
                    InsertWidgetWizardPage.this.isAddErrorMessageButton.setEnabled(false);
                    InsertWidgetWizardPage.this.checkedElements = InsertWidgetWizardPage.this.configureWidgetsTableViewer.getCheckedElements();
                    InsertWidgetWizardPage.this.errorMessageManager.clean();
                    InsertWidgetWizardPage.this.purpose = "FOR_DISPLAY";
                    InsertWidgetWizardPage.this.insertDataModel.updatePurpose(InsertWidgetWizardPage.this.purpose);
                    InsertWidgetWizardPage.this.configureWidgetsTableViewer.setInput(InsertWidgetWizardPage.this.insertDataModel.getRootDataNodes());
                    InsertWidgetWizardPage.this.configureWidgetsTableViewer.expandToLevel(10);
                    if (InsertWidgetWizardPage.this.isFirstDisplay) {
                        InsertWidgetWizardPage.this.configureWidgetsTableViewer.setAllChecked(true);
                        InsertWidgetWizardPage.this.isFirstDisplay = false;
                    } else {
                        InsertWidgetWizardPage.this.configureWidgetsTableViewer.setCheckedElements(InsertWidgetWizardPage.this.checkedElements);
                    }
                    InsertWidgetWizardPage.this.checkInsertDataNodeSelection();
                    InsertWidgetWizardPage.this.errorMessageManager.refresh();
                    InsertWidgetWizardPage.this.insertDataModel.setPurpose(InsertWidgetWizardPage.this.purpose);
                }
            }

            public void widgetDefaultSelected(SelectionEvent e) {
            }
        };
        this.displayWidgetsButton.addSelectionListener(listener);
        this.createWidgetsButton = new Button(composite, 16);
        this.createWidgetsButton.setText(Messages.NL_IWWP_Create_Widgets_Button);
        this.createWidgetsButton.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                if (InsertWidgetWizardPage.this.createWidgetsButton.getSelection()) {
                    InsertWidgetWizardPage.this.isAddFormattingAndValidationButton.setSelection(true);
                    InsertWidgetWizardPage.this.isAddFormattingAndValidationButton.setEnabled(true);
                    InsertWidgetWizardPage.this.isAddErrorMessageButton.setEnabled(true);
                    InsertWidgetWizardPage.this.checkedElements = InsertWidgetWizardPage.this.configureWidgetsTableViewer.getCheckedElements();
                    InsertWidgetWizardPage.this.errorMessageManager.clean();
                    InsertWidgetWizardPage.this.purpose = "FOR_CREATE";
                    InsertWidgetWizardPage.this.insertDataModel.updatePurpose(InsertWidgetWizardPage.this.purpose);
                    InsertWidgetWizardPage.this.configureWidgetsTableViewer.setInput(InsertWidgetWizardPage.this.insertDataModel.getRootDataNodes());
                    InsertWidgetWizardPage.this.configureWidgetsTableViewer.expandToLevel(10);
                    InsertWidgetWizardPage.this.configureWidgetsTableViewer.setCheckedElements(InsertWidgetWizardPage.this.checkedElements);
                    InsertWidgetWizardPage.this.checkInsertDataNodeSelection();
                    InsertWidgetWizardPage.this.errorMessageManager.refresh();
                    InsertWidgetWizardPage.this.insertDataModel.setPurpose(InsertWidgetWizardPage.this.purpose);
                }
            }

            public void widgetDefaultSelected(SelectionEvent e) {
            }
        });
        this.updateWidgetsButton = new Button(composite, 16);
        this.updateWidgetsButton.setText(Messages.NL_IWWP_Update_Widgets_Button);
        this.updateWidgetsButton.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                if (InsertWidgetWizardPage.this.updateWidgetsButton.getSelection()) {
                    InsertWidgetWizardPage.this.isAddFormattingAndValidationButton.setSelection(true);
                    InsertWidgetWizardPage.this.isAddFormattingAndValidationButton.setEnabled(true);
                    InsertWidgetWizardPage.this.isAddErrorMessageButton.setEnabled(true);
                    InsertWidgetWizardPage.this.checkedElements = InsertWidgetWizardPage.this.configureWidgetsTableViewer.getCheckedElements();
                    InsertWidgetWizardPage.this.errorMessageManager.clean();
                    InsertWidgetWizardPage.this.purpose = "FOR_UPDATE";
                    InsertWidgetWizardPage.this.insertDataModel.updatePurpose(InsertWidgetWizardPage.this.purpose);
                    InsertWidgetWizardPage.this.configureWidgetsTableViewer.setInput(InsertWidgetWizardPage.this.insertDataModel.getRootDataNodes());
                    InsertWidgetWizardPage.this.configureWidgetsTableViewer.expandToLevel(10);
                    InsertWidgetWizardPage.this.configureWidgetsTableViewer.setCheckedElements(InsertWidgetWizardPage.this.checkedElements);
                    InsertWidgetWizardPage.this.checkInsertDataNodeSelection();
                    InsertWidgetWizardPage.this.errorMessageManager.refresh();
                    InsertWidgetWizardPage.this.insertDataModel.setPurpose(InsertWidgetWizardPage.this.purpose);
                }
            }

            public void widgetDefaultSelected(SelectionEvent e) {
            }
        });
        Label separator1 = new Label(composite, 258);
        separator1.setLayoutData((Object)new GridData(768));
        Label configureWidgetsLabel = new Label(composite, 0);
        configureWidgetsLabel.setText(Messages.NL_IWWP_Configure_Widgets_Label);
        this.createConfigureWidgetsTableViewer(composite);
        Composite buttonComposite = new Composite(composite, 0);
        buttonComposite.setLayout((Layout)new RowLayout());
        Button selectAllButton = new Button(buttonComposite, 0);
        selectAllButton.setText(Messages.NL_IWWP_Select_All_Button);
        selectAllButton.addSelectionListener(new SelectionListener(){

            public void widgetDefaultSelected(SelectionEvent event) {
            }

            public void widgetSelected(SelectionEvent event) {
                InsertWidgetWizardPage.this.configureWidgetsTableViewer.setAllChecked(true);
                InsertWidgetWizardPage.this.errorMessageManager.removeGloabelError("NO_ELEMENT_SELECTED");
                InsertWidgetWizardPage.this.errorMessageManager.refresh();
            }
        });
        Button deselectAllButton = new Button(buttonComposite, 0);
        deselectAllButton.setText(Messages.NL_IWWP_Deselect_All_Button);
        deselectAllButton.addSelectionListener(new SelectionListener(){

            public void widgetDefaultSelected(SelectionEvent event) {
            }

            public void widgetSelected(SelectionEvent event) {
                InsertWidgetWizardPage.this.configureWidgetsTableViewer.setAllChecked(false);
                InsertWidgetWizardPage.this.errorMessageManager.addGloabelError("NO_ELEMENT_SELECTED", Messages.NL_IWWP_Error_Message_No_Element_Selected);
                InsertWidgetWizardPage.this.errorMessageManager.refresh();
            }
        });
        Label separator2 = new Label(composite, 258);
        separator2.setLayoutData((Object)new GridData(768));
        Composite mvcComposite = new Composite(composite, 0);
        GridData mvcCompositeGridData = new GridData(768);
        mvcCompositeGridData.heightHint = 50;
        mvcComposite.setLayoutData((Object)mvcCompositeGridData);
        mvcComposite.setLayout((Layout)new GridLayout(2, false));
        this.isAddFormattingAndValidationButton = new Button(mvcComposite, 32);
        this.isAddFormattingAndValidationButton.setText(Messages.NL_IWWP_Is_Add_Formatting_And_Validation_Button);
        GridData isAddFormattingAndValidationButtonGridData = new GridData();
        isAddFormattingAndValidationButtonGridData.horizontalSpan = 2;
        this.isAddFormattingAndValidationButton.setLayoutData((Object)isAddFormattingAndValidationButtonGridData);
        this.isAddFormattingAndValidationButton.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                if (InsertWidgetWizardPage.this.isAddFormattingAndValidationButton.getSelection()) {
                    InsertWidgetWizardPage.this.insertDataModel.setAddFormattingAndValidation(true);
                    if (!InsertWidgetWizardPage.this.displayWidgetsButton.getSelection()) {
                        InsertWidgetWizardPage.this.isAddErrorMessageButton.setEnabled(true);
                    }
                } else {
                    InsertWidgetWizardPage.this.isAddErrorMessageButton.setSelection(false);
                    InsertWidgetWizardPage.this.isAddErrorMessageButton.setEnabled(false);
                    InsertWidgetWizardPage.this.insertDataModel.setAddFormattingAndValidation(false);
                    InsertWidgetWizardPage.this.insertDataModel.setAddErrorMessage(false);
                }
            }

            public void widgetDefaultSelected(SelectionEvent e) {
            }
        });
        Label separator3 = new Label(mvcComposite, 0);
        separator3.setText("   ");
        this.isAddErrorMessageButton = new Button(mvcComposite, 32);
        this.isAddErrorMessageButton.setText(Messages.NL_IWWP_Is_Add_Error_Message_Button);
        this.isAddErrorMessageButton.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                if (InsertWidgetWizardPage.this.isAddErrorMessageButton.getSelection()) {
                    if (InsertWidgetWizardPage.this.insertDataModel.isAddErrorMessage()) {
                        InsertWidgetWizardPage.this.insertDataModel.setAddErrorMessage(false);
                    } else {
                        InsertWidgetWizardPage.this.insertDataModel.setAddErrorMessage(true);
                    }
                }
            }

            public void widgetDefaultSelected(SelectionEvent e) {
            }
        });
        this.displayWidgetsButton.setSelection(true);
        listener.widgetSelected(null);
        this.setControl((Control)composite);
    }

    private void checkInsertDataNodeSelection() {
        this.checkIfAllInsertDataNodeSelected();
        this.checkIfParentInsertDataNodeSelected();
    }

    private void checkIfAllInsertDataNodeSelected() {
        if (this.configureWidgetsTableViewer.getCheckedElements().length == 0) {
            this.errorMessageManager.addGloabelError("NO_ELEMENT_SELECTED", Messages.NL_IWWP_Error_Message_No_Element_Selected);
        } else {
            this.errorMessageManager.removeGloabelError("NO_ELEMENT_SELECTED");
        }
    }

    private void checkIfParentInsertDataNodeSelected() {
        Object[] objectArray = this.configureWidgetsTableViewer.getCheckedElements();
        int n = objectArray.length;
        int n2 = 0;
        while (n2 < n) {
            Object object = objectArray[n2];
            InsertDataNode insertDataNode = (InsertDataNode)object;
            if (insertDataNode.getParent() != null && !this.isInsertDataNodeChecked(insertDataNode.getParent())) {
                this.errorMessageManager.addGloabelError("PARENT_ELEMENT_IS_NOT_SELECTED", Messages.NL_IWWP_Error_Message_Parent_Element_Is_Not_Selected);
            } else {
                this.errorMessageManager.removeGloabelError("PARENT_ELEMENT_IS_NOT_SELECTED");
            }
            ++n2;
        }
    }

    private boolean isInsertDataNodeChecked(InsertDataNode insertDataNode) {
        Object[] objects;
        Object[] objectArray = objects = this.configureWidgetsTableViewer.getCheckedElements();
        int n = objects.length;
        int n2 = 0;
        while (n2 < n) {
            Object object = objectArray[n2];
            if (object.equals(insertDataNode)) {
                return true;
            }
            ++n2;
        }
        return false;
    }

    private boolean isWidgetNameDuplicate(InsertDataNode insertDataNode, String widgetName) {
        boolean isWidgetNameDuplicate = false;
        List<InsertDataNode> rootInsertDataNodes = this.insertDataModel.getRootDataNodes();
        int i = 0;
        while (i < rootInsertDataNodes.size()) {
            InsertDataNode rootInsertDataNode = rootInsertDataNodes.get(i);
            if (!rootInsertDataNode.equals(insertDataNode)) {
                String rootWidgetName = rootInsertDataNode.getWidgetName();
                if (rootWidgetName == null) {
                    rootWidgetName = rootInsertDataNode.getDefaultWidgetName();
                }
                if (rootWidgetName.equalsIgnoreCase(widgetName)) {
                    isWidgetNameDuplicate = true;
                    break;
                }
                List<InsertDataNode> allChildren = this.getAllChildren(rootInsertDataNode);
                int j = 0;
                while (j < allChildren.size()) {
                    InsertDataNode childInsertDataNode = allChildren.get(i);
                    if (!childInsertDataNode.equals(insertDataNode)) {
                        String childWidgetName = childInsertDataNode.getWidgetName();
                        if (childWidgetName == null) {
                            childWidgetName = childInsertDataNode.getDefaultWidgetName();
                        }
                        if (childWidgetName.equalsIgnoreCase(widgetName)) {
                            isWidgetNameDuplicate = true;
                            break;
                        }
                    }
                    ++j;
                }
            }
            ++i;
        }
        return isWidgetNameDuplicate;
    }

    private List<InsertDataNode> getAllChildren(InsertDataNode insertDataNode) {
        ArrayList<InsertDataNode> allChildren = new ArrayList<InsertDataNode>();
        this.getAllChildren(insertDataNode, allChildren);
        return allChildren;
    }

    private void getAllChildren(InsertDataNode insertDataNode, List<InsertDataNode> allChildren) {
        for (InsertDataNode child : insertDataNode.getChildren()) {
            allChildren.add(child);
            this.getAllChildren(child, allChildren);
        }
    }

    private void createConfigureWidgetsTableViewer(Composite composite) {
        Composite configureComposite = new Composite(composite, 0);
        GridData configureCompositeGridData = new GridData(1808);
        configureComposite.setLayoutData((Object)configureCompositeGridData);
        configureComposite.setLayout((Layout)new GridLayout(2, false));
        Tree configureWidgetsTree = new Tree(configureComposite, 67618);
        this.configureWidgetsTableViewer = new CheckboxTreeViewer(configureWidgetsTree);
        this.configureWidgetsTableViewer.setContentProvider((IContentProvider)new TreeTableViewerContentProvider());
        this.configureWidgetsTableViewer.getTree().setHeaderVisible(true);
        this.configureWidgetsTableViewer.getTree().setLayoutData((Object)new GridData(1808));
        TableLayout tableLayout = new TableLayout();
        this.configureWidgetsTableViewer.getTree().setLayout((Layout)tableLayout);
        this.configureWidgetsTableViewer.addCheckStateListener(new ICheckStateListener(){

            public void checkStateChanged(CheckStateChangedEvent event) {
                InsertDataNode insertDataNode = (InsertDataNode)event.getElement();
                InsertWidgetWizardPage.this.configureWidgetsTableViewer.setGrayed((Object)insertDataNode, false);
                if (InsertWidgetWizardPage.this.isInsertDataNodeChecked(insertDataNode)) {
                    InsertDataNode parent = insertDataNode.getParent();
                    if (parent != null) {
                        if (this.isOneChildUnchecked(parent)) {
                            InsertWidgetWizardPage.this.configureWidgetsTableViewer.setGrayChecked((Object)parent, true);
                        } else {
                            InsertWidgetWizardPage.this.configureWidgetsTableViewer.setGrayChecked((Object)parent, false);
                            InsertWidgetWizardPage.this.configureWidgetsTableViewer.setChecked((Object)parent, true);
                        }
                    }
                    for (InsertDataNode child : InsertWidgetWizardPage.this.getAllChildren(insertDataNode)) {
                        InsertWidgetWizardPage.this.configureWidgetsTableViewer.setChecked((Object)child, true);
                    }
                } else {
                    InsertDataNode parent = insertDataNode.getParent();
                    if (parent != null) {
                        if (this.isOneChildUnchecked(parent)) {
                            InsertWidgetWizardPage.this.configureWidgetsTableViewer.setGrayChecked((Object)parent, true);
                        }
                        if (this.isAllChildrenUnchecked(parent)) {
                            InsertWidgetWizardPage.this.configureWidgetsTableViewer.setGrayChecked((Object)parent, false);
                            InsertWidgetWizardPage.this.configureWidgetsTableViewer.setChecked((Object)parent, false);
                        }
                    }
                    for (InsertDataNode child : InsertWidgetWizardPage.this.getAllChildren(insertDataNode)) {
                        InsertWidgetWizardPage.this.configureWidgetsTableViewer.setGrayChecked((Object)child, false);
                    }
                }
                InsertWidgetWizardPage.this.checkInsertDataNodeSelection();
                InsertWidgetWizardPage.this.errorMessageManager.refresh();
            }

            private boolean isOneChildUnchecked(InsertDataNode parent) {
                List<InsertDataNode> children = parent.getChildren();
                for (InsertDataNode child : children) {
                    if (InsertWidgetWizardPage.this.configureWidgetsTableViewer.getChecked((Object)child)) continue;
                    return true;
                }
                return false;
            }

            private boolean isAllChildrenUnchecked(InsertDataNode parent) {
                List<InsertDataNode> children = parent.getChildren();
                for (InsertDataNode child : children) {
                    if (!InsertWidgetWizardPage.this.configureWidgetsTableViewer.getChecked((Object)child)) continue;
                    return false;
                }
                return true;
            }
        });
        this.configureWidgetsTableViewer.getTree().addKeyListener(new KeyListener(){

            public void keyPressed(KeyEvent event) {
                if (event.keyCode == 16777259 && InsertWidgetWizardPage.this.upButton.isEnabled()) {
                    InsertWidgetWizardPage.this.reorderSelectedInsertDataNodes(Order.UP);
                }
                if (event.keyCode == 16777261 && InsertWidgetWizardPage.this.downButton.isEnabled()) {
                    InsertWidgetWizardPage.this.reorderSelectedInsertDataNodes(Order.DOWN);
                }
            }

            public void keyReleased(KeyEvent event) {
            }
        });
        this.configureWidgetsTableViewer.getTree().addListener(18, new Listener(){

            public void handleEvent(Event event) {
                TreeItem treeItem;
                InsertDataNode insertDataNode;
                Widget widget = event.item;
                if (widget instanceof TreeItem && !InsertWidgetWizardPage.this.isSelected(insertDataNode = (InsertDataNode)(treeItem = (TreeItem)widget).getData(), (IStructuredSelection)InsertWidgetWizardPage.this.configureWidgetsTableViewer.getSelection())) {
                    InsertWidgetWizardPage.this.configureWidgetsTableViewer.setSelection(null);
                    InsertWidgetWizardPage.this.setUpAndDownButtonsStatus(null);
                }
            }
        });
        this.configureWidgetsTableViewer.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                if (event.getSelection().isEmpty()) {
                    return;
                }
                InsertWidgetWizardPage.this.setUpAndDownButtonsStatus(event.getSelection());
            }
        });
        TreeViewerColumn fieldNameColumn = new TreeViewerColumn((TreeViewer)this.configureWidgetsTableViewer, 0);
        fieldNameColumn.getColumn().setText(Messages.NL_IWWP_CWT_Field_Name_Column);
        tableLayout.addColumnData((ColumnLayoutData)new ColumnWeightData(150));
        fieldNameColumn.setLabelProvider((CellLabelProvider)new ColumnLabelProvider(){

            public String getText(Object element) {
                InsertDataNode insertDataNode = (InsertDataNode)element;
                return insertDataNode.getFieldName();
            }
        });
        TreeViewerColumn fieldTypeColumn = new TreeViewerColumn((TreeViewer)this.configureWidgetsTableViewer, 0);
        fieldTypeColumn.getColumn().setText(Messages.NL_IWWP_CWT_Field_Type_Column);
        tableLayout.addColumnData((ColumnLayoutData)new ColumnWeightData(100));
        fieldTypeColumn.setLabelProvider((CellLabelProvider)new ColumnLabelProvider(){

            public String getText(Object element) {
                InsertDataNode insertDataNode = (InsertDataNode)element;
                return insertDataNode.getFieldType();
            }
        });
        TreeViewerColumn labelTextColumn = new TreeViewerColumn((TreeViewer)this.configureWidgetsTableViewer, 0);
        labelTextColumn.getColumn().setText(Messages.NL_IWWP_CWT_Label_Text_Column);
        tableLayout.addColumnData((ColumnLayoutData)new ColumnWeightData(100));
        labelTextColumn.setLabelProvider((CellLabelProvider)new ColumnLabelProvider(){

            public String getText(Object element) {
                InsertDataNode insertDataNode = (InsertDataNode)element;
                return insertDataNode.getLabelText();
            }
        });
        labelTextColumn.setEditingSupport((EditingSupport)new LabelTextColumnEditingSupport((TreeViewer)this.configureWidgetsTableViewer));
        TreeViewerColumn widgetTypeColumn = new TreeViewerColumn((TreeViewer)this.configureWidgetsTableViewer, 0);
        widgetTypeColumn.getColumn().setText(Messages.NL_IWWP_CWT_Widget_Type_Column);
        tableLayout.addColumnData((ColumnLayoutData)new ColumnWeightData(180));
        widgetTypeColumn.setLabelProvider((CellLabelProvider)new ColumnLabelProvider(){

            public String getText(Object element) {
                InsertDataNode insertDataNode = (InsertDataNode)element;
                String widgetType = insertDataNode.getWidgetType().getName();
                if (!InsertWidgetWizardPage.this.isParentGenChildrenWidget(insertDataNode)) {
                    return "";
                }
                if (widgetType.equals("None")) {
                    if (InsertWidgetWizardUtil.isAPrimitiveArrayInRecord(insertDataNode)) {
                        InsertWidgetWizardPage.this.configureWidgetsTableViewer.setGrayed((Object)insertDataNode, true);
                    } else {
                        String errorMessage = String.valueOf(Messages.NL_IWWP_Error_Message_Can_Not_Find_Widget) + " " + insertDataNode.getBindingName();
                        InsertWidgetWizardPage.this.errorMessageManager.addError(insertDataNode, 0, errorMessage);
                    }
                } else {
                    InsertWidgetWizardPage.this.errorMessageManager.reomveError(insertDataNode, 0);
                }
                return widgetType;
            }
        });
        widgetTypeColumn.setEditingSupport((EditingSupport)new WidgetTypeColumnEditingSupport((TreeViewer)this.configureWidgetsTableViewer));
        TreeViewerColumn widgetNameColumn = new TreeViewerColumn((TreeViewer)this.configureWidgetsTableViewer, 0);
        widgetNameColumn.getColumn().setText(Messages.NL_IWWP_CWT_Widget_Name_Column);
        tableLayout.addColumnData((ColumnLayoutData)new ColumnWeightData(150));
        widgetNameColumn.setLabelProvider((CellLabelProvider)new ColumnLabelProvider(){

            public String getText(Object element) {
                InsertDataNode insertDataNode = (InsertDataNode)element;
                if (!InsertWidgetWizardPage.this.isParentGenChildrenWidget(insertDataNode)) {
                    return "";
                }
                String widgetName = insertDataNode.getWidgetName();
                if (widgetName == null || widgetName.equals("")) {
                    widgetName = insertDataNode.getDefaultWidgetName();
                }
                if (!this.isWidgetNameValid(widgetName)) {
                    String errorMessage = String.valueOf(widgetName) + " " + Messages.NL_IWWP_Error_Message__Widget_Name_Is_Not_Valid;
                    InsertWidgetWizardPage.this.errorMessageManager.addError(insertDataNode, 2, errorMessage);
                } else if (NameFinder.getInstance().isFieldNameExist(widgetName) || InsertWidgetWizardPage.this.isWidgetNameDuplicate(insertDataNode, widgetName)) {
                    String errorMessage = String.valueOf(widgetName) + " " + Messages.NL_IWWP_Error_Message_Duplicate_Widget_Name_Found;
                    InsertWidgetWizardPage.this.errorMessageManager.addError(insertDataNode, 1, errorMessage);
                } else {
                    InsertWidgetWizardPage.this.errorMessageManager.reomveError(insertDataNode, 2);
                    InsertWidgetWizardPage.this.errorMessageManager.reomveError(insertDataNode, 1);
                }
                InsertWidgetWizardPage.this.errorMessageManager.refresh();
                return widgetName;
            }

            private boolean isWidgetNameValid(String widgetName) {
                ArrayList messages = EGLNameValidator.validateEGLName(widgetName, "Part", null);
                return messages.isEmpty();
            }
        });
        widgetNameColumn.setEditingSupport((EditingSupport)new WidgetNameColumnEditingSupport((TreeViewer)this.configureWidgetsTableViewer));
        Composite orderComposite = new Composite(configureComposite, 0);
        orderComposite.setLayout((Layout)new GridLayout(1, false));
        this.upButton = new Button(orderComposite, 0);
        this.upButton.setImage(Activator.getImage("obj16/up.gif"));
        this.upButton.setToolTipText(Tooltips.NL_IWWP_Order_Up);
        this.upButton.setEnabled(false);
        this.upButton.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent event) {
                InsertWidgetWizardPage.this.reorderSelectedInsertDataNodes(Order.UP);
            }

            public void widgetDefaultSelected(SelectionEvent event) {
            }
        });
        this.downButton = new Button(orderComposite, 0);
        this.downButton.setImage(Activator.getImage("obj16/down.gif"));
        this.downButton.setToolTipText(Tooltips.NL_IWWP_Order_Down);
        this.downButton.setEnabled(false);
        this.downButton.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent event) {
                InsertWidgetWizardPage.this.reorderSelectedInsertDataNodes(Order.DOWN);
            }

            public void widgetDefaultSelected(SelectionEvent event) {
            }
        });
    }

    private void reorderSelectedInsertDataNodes(Order order) {
        ISelection treeSelection = this.configureWidgetsTableViewer.getSelection();
        if (treeSelection instanceof IStructuredSelection) {
            InsertDataNode insertDataNode;
            this.checkedElements = this.configureWidgetsTableViewer.getCheckedElements();
            IStructuredSelection selection = (IStructuredSelection)treeSelection;
            InsertDataNode parent = ((InsertDataNode)selection.getFirstElement()).getParent();
            List<InsertDataNode> children = parent.getChildren();
            ArrayList<InsertDataNode> newChildren = new ArrayList<InsertDataNode>();
            int i = 0;
            while (i < children.size()) {
                newChildren.add(null);
                ++i;
            }
            i = 0;
            while (i < children.size()) {
                insertDataNode = children.get(i);
                if (this.isSelected(insertDataNode, selection)) {
                    int change = i;
                    if (Order.UP.equals((Object)order)) {
                        change = i - 1;
                    }
                    if (Order.DOWN.equals((Object)order)) {
                        change = i + 1;
                    }
                    newChildren.set(change, insertDataNode);
                    children.set(i, null);
                }
                ++i;
            }
            i = 0;
            while (i < children.size()) {
                insertDataNode = children.get(i);
                if (insertDataNode != null) {
                    int j = 0;
                    while (j < newChildren.size()) {
                        if (newChildren.get(j) == null) {
                            newChildren.set(j, insertDataNode);
                            break;
                        }
                        ++j;
                    }
                }
                ++i;
            }
            parent.setChildren(newChildren);
            this.configureWidgetsTableViewer.setInput(this.insertDataModel.getRootDataNodes());
            this.configureWidgetsTableViewer.expandToLevel(10);
            this.configureWidgetsTableViewer.setSelection(treeSelection);
            this.configureWidgetsTableViewer.setCheckedElements(this.checkedElements);
        }
    }

    private boolean isSelected(InsertDataNode insertDataNode, IStructuredSelection selection) {
        Iterator iterator = selection.iterator();
        while (iterator.hasNext()) {
            if (!insertDataNode.equals(iterator.next())) continue;
            return true;
        }
        return false;
    }

    private void setUpAndDownButtonsStatus(ISelection treeSelection) {
        this.upButton.setEnabled(false);
        this.downButton.setEnabled(false);
        if (treeSelection == null) {
            return;
        }
        boolean disableUp = false;
        boolean disableDown = false;
        InsertDataNode parent = null;
        if (treeSelection instanceof IStructuredSelection) {
            IStructuredSelection selection = (IStructuredSelection)treeSelection;
            for (Object object : selection) {
                if (!(object instanceof InsertDataNode)) continue;
                InsertDataNode insertDataNode = (InsertDataNode)object;
                if (insertDataNode.getParent() == null) {
                    return;
                }
                if (parent == null) {
                    parent = insertDataNode.getParent();
                } else if (!parent.equals(insertDataNode.getParent())) {
                    return;
                }
                if (parent.getChildren().get(0).equals(insertDataNode)) {
                    disableUp = true;
                }
                if (!parent.getChildren().get(parent.getChildren().size() - 1).equals(insertDataNode)) continue;
                disableDown = true;
            }
        }
        if (!disableUp) {
            this.upButton.setEnabled(true);
        }
        if (!disableDown) {
            this.downButton.setEnabled(true);
        }
    }

    private boolean isParentGenChildrenWidget(InsertDataNode insertDataNode) {
        InsertDataNode parent = insertDataNode.getParent();
        return parent == null || parent.getDataTemplate() == null || parent.getDataTemplate().getDataMapping().isGenChildWidget();
    }

    class ErrorMessageManager {
        public static final int ERROR_TYPE_CANNOT_FIND_WIDGET = 0;
        public static final int ERROR_TYPE_DUPLICATE_WIDGET_NAME = 1;
        public static final int ERROR_TYPE_INVALID_WIDGET_NAME = 2;
        public static final String GLOBAL_ERROR_TYPE_NO_ELEMENT_SELECTED = "NO_ELEMENT_SELECTED";
        public static final String GLOBAL_ERROR_TYPE_PARENT_ELEMENT_IS_NOT_SELECTED = "PARENT_ELEMENT_IS_NOT_SELECTED";
        private Map<String, String> errorMessages = new HashMap<String, String>();

        public void addError(InsertDataNode insertDataNode, int errorType, String message) {
            String key = String.valueOf(this.getKey(insertDataNode)) + errorType;
            this.errorMessages.put(key, message);
        }

        public void addGloabelError(String errorType, String message) {
            this.errorMessages.put(errorType, message);
        }

        public void removeGloabelError(String errorType) {
            this.errorMessages.keySet().remove(errorType);
        }

        public void reomveError(InsertDataNode insertDataNode, int errorType) {
            String key = String.valueOf(this.getKey(insertDataNode)) + errorType;
            this.errorMessages.keySet().remove(key);
        }

        private String getKey(InsertDataNode insertDataNode) {
            return String.valueOf(insertDataNode.getBindingName()) + insertDataNode.getNodeType() + insertDataNode.isContainer();
        }

        public boolean hasError() {
            return !this.errorMessages.isEmpty();
        }

        public String getErrors() {
            StringBuffer sbError = new StringBuffer();
            Collection<String> errors = this.errorMessages.values();
            for (String error : errors) {
                sbError.append(error).append("\n");
            }
            return sbError.toString().trim();
        }

        public void clean() {
            this.errorMessages.clear();
        }

        public void refresh() {
            if (InsertWidgetWizardPage.this.errorMessageManager.hasError()) {
                InsertWidgetWizardPage.this.setErrorMessage(InsertWidgetWizardPage.this.errorMessageManager.getErrors());
                InsertWidgetWizardPage.this.setPageComplete(false);
            } else {
                InsertWidgetWizardPage.this.setErrorMessage(null);
                InsertWidgetWizardPage.this.setPageComplete(true);
            }
        }
    }

    class LabelTextColumnEditingSupport
    extends EditingSupport {
        private TextCellEditor textCellEditor;

        public LabelTextColumnEditingSupport(TreeViewer viewer) {
            super((ColumnViewer)viewer);
            this.textCellEditor = new TextCellEditor((Composite)viewer.getTree());
        }

        protected CellEditor getCellEditor(Object element) {
            return this.textCellEditor;
        }

        protected boolean canEdit(Object element) {
            InsertDataNode insertDataNode = (InsertDataNode)element;
            return insertDataNode.getLabelText() != null;
        }

        protected Object getValue(Object element) {
            InsertDataNode insertDataNode = (InsertDataNode)element;
            return insertDataNode.getLabelText();
        }

        protected void setValue(Object element, Object value) {
            InsertDataNode insertDataNode = (InsertDataNode)element;
            insertDataNode.setLabelText((String)value);
            this.getViewer().update(element, null);
        }
    }

    static enum Order {
        UP,
        DOWN;

    }

    public class TreeTableViewerContentProvider
    implements ITreeContentProvider {
        public Object[] getElements(Object inputElement) {
            if (inputElement instanceof List) {
                return ((List)inputElement).toArray();
            }
            return new Object[0];
        }

        public void dispose() {
        }

        public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
        }

        public Object[] getChildren(Object parentElement) {
            InsertDataNode insertDataNode = (InsertDataNode)parentElement;
            return insertDataNode.getChildren().toArray();
        }

        public Object getParent(Object element) {
            InsertDataNode insertDataNode = (InsertDataNode)element;
            return insertDataNode.getParent();
        }

        public boolean hasChildren(Object element) {
            InsertDataNode insertDataNode = (InsertDataNode)element;
            return insertDataNode.hasChildren();
        }
    }

    class WidgetNameColumnEditingSupport
    extends EditingSupport {
        private TextCellEditor textCellEditor;

        public WidgetNameColumnEditingSupport(TreeViewer viewer) {
            super((ColumnViewer)viewer);
            this.textCellEditor = new TextCellEditor((Composite)viewer.getTree());
        }

        protected CellEditor getCellEditor(Object element) {
            return this.textCellEditor;
        }

        protected boolean canEdit(Object element) {
            InsertDataNode insertDataNode = (InsertDataNode)element;
            return InsertWidgetWizardPage.this.isParentGenChildrenWidget(insertDataNode);
        }

        protected Object getValue(Object element) {
            InsertDataNode insertDataNode = (InsertDataNode)element;
            String widgetName = insertDataNode.getWidgetName();
            if (widgetName == null) {
                widgetName = insertDataNode.getDefaultWidgetName();
            }
            return widgetName;
        }

        protected void setValue(Object element, Object value) {
            InsertDataNode insertDataNode = (InsertDataNode)element;
            String widgetName = (String)value;
            insertDataNode.setWidgetName(widgetName);
            this.getViewer().update(element, null);
        }
    }

    class WidgetTypeColumnEditingSupport
    extends EditingSupport {
        private TreeViewer viewer;
        private ComboBoxCellEditor comboBoxCellEditor;

        public WidgetTypeColumnEditingSupport(TreeViewer viewer) {
            super((ColumnViewer)viewer);
            this.viewer = viewer;
        }

        protected CellEditor getCellEditor(Object element) {
            return this.comboBoxCellEditor;
        }

        protected boolean canEdit(Object element) {
            InsertDataNode insertDataNode = (InsertDataNode)element;
            WidgetType[] widgetTypes = insertDataNode.getWidgetTypes();
            String[] widgetTypeNames = new String[widgetTypes.length];
            int i = 0;
            while (i < widgetTypes.length) {
                widgetTypeNames[i] = widgetTypes[i].getName();
                ++i;
            }
            this.comboBoxCellEditor = new ComboBoxCellEditor((Composite)this.viewer.getTree(), widgetTypeNames, 8);
            ((CCombo)this.comboBoxCellEditor.getControl()).setVisibleItemCount(10);
            return InsertWidgetWizardPage.this.isParentGenChildrenWidget(insertDataNode) && widgetTypes.length > 1;
        }

        protected Object getValue(Object element) {
            return 0;
        }

        protected void setValue(Object element, Object value) {
            InsertDataNode insertDataNode = (InsertDataNode)element;
            int selected = Integer.parseInt(value.toString());
            if (selected >= 0) {
                WidgetType[] widgetTypes = insertDataNode.getWidgetTypes();
                insertDataNode.setWidgetType(widgetTypes[selected]);
                this.getViewer().update((Object)insertDataNode, null);
                for (InsertDataNode child : insertDataNode.getChildren()) {
                    this.getViewer().update((Object)child, null);
                }
            }
        }
    }
}

