/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jetty.plus.annotation;

import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import org.eclipse.jetty.plus.annotation.Injection;
import org.eclipse.jetty.util.log.Log;
import org.eclipse.jetty.util.log.Logger;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class InjectionCollection {
    private static final Logger LOG = Log.getLogger(InjectionCollection.class);
    public static final String INJECTION_COLLECTION = "org.eclipse.jetty.injectionCollection";
    private HashMap<String, List<Injection>> _injectionMap = new HashMap();

    public void add(Injection injection) {
        List<Injection> injections;
        if (injection == null || injection.getTargetClass() == null) {
            return;
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug("Adding injection for class=" + injection.getTargetClass() + " on a " + injection.getTarget().getName(), new Object[0]);
        }
        if ((injections = this._injectionMap.get(injection.getTargetClass().getCanonicalName())) == null) {
            injections = new ArrayList<Injection>();
            this._injectionMap.put(injection.getTargetClass().getCanonicalName(), injections);
        }
        injections.add(injection);
    }

    public List<Injection> getInjections(String className) {
        if (className == null) {
            return null;
        }
        return this._injectionMap.get(className);
    }

    public Injection getInjection(String jndiName, Class<?> clazz, Field field) {
        if (field == null || clazz == null) {
            return null;
        }
        List<Injection> injections = this.getInjections(clazz.getCanonicalName());
        if (injections == null) {
            return null;
        }
        Iterator<Injection> itor = injections.iterator();
        Injection injection = null;
        while (itor.hasNext() && injection == null) {
            Injection i = itor.next();
            if (!i.isField() || !field.getName().equals(i.getTarget().getName())) continue;
            injection = i;
        }
        return injection;
    }

    public Injection getInjection(String jndiName, Class<?> clazz, Method method, Class<?> paramClass) {
        if (clazz == null || method == null || paramClass == null) {
            return null;
        }
        List<Injection> injections = this.getInjections(clazz.getCanonicalName());
        if (injections == null) {
            return null;
        }
        Iterator<Injection> itor = injections.iterator();
        Injection injection = null;
        while (itor.hasNext() && injection == null) {
            Injection i = itor.next();
            if (!i.isMethod() || !i.getTarget().getName().equals(method.getName()) || !paramClass.equals(i.getParamClass())) continue;
            injection = i;
        }
        return injection;
    }

    public void inject(Object injectable) {
        if (injectable == null) {
            return;
        }
        for (Class<?> clazz = injectable.getClass(); clazz != null; clazz = clazz.getSuperclass()) {
            List<Injection> injections = this._injectionMap.get(clazz.getCanonicalName());
            if (injections == null) continue;
            for (Injection i : injections) {
                i.inject(injectable);
            }
        }
    }
}

