/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.edt.ide.core.internal.model;

import org.eclipse.edt.ide.core.internal.model.Assert;
import org.eclipse.edt.ide.core.internal.model.EGLElement;
import org.eclipse.edt.ide.core.internal.model.EGLElementInfo;
import org.eclipse.edt.ide.core.internal.model.EGLModelManager;
import org.eclipse.edt.ide.core.internal.model.ImportDeclaration;
import org.eclipse.edt.ide.core.internal.model.SourceRange;
import org.eclipse.edt.ide.core.internal.model.SourceRefElement;
import org.eclipse.edt.ide.core.model.EGLModelException;
import org.eclipse.edt.ide.core.model.IEGLElement;
import org.eclipse.edt.ide.core.model.IEGLFile;
import org.eclipse.edt.ide.core.model.IImportContainer;
import org.eclipse.edt.ide.core.model.IImportDeclaration;
import org.eclipse.edt.ide.core.model.ISourceRange;
import org.eclipse.edt.ide.core.model.ISourceReference;

public class ImportContainer
extends SourceRefElement
implements IImportContainer {
    protected ImportContainer(IEGLFile parent) {
        super(13, parent, "");
    }

    @Override
    public String getHandleMemento() {
        return ((EGLElement)this.getParent()).getHandleMemento();
    }

    @Override
    protected char getHandleMementoDelimiter() {
        Assert.isTrue(false, "Should not be called");
        return '\u0000';
    }

    @Override
    public IImportDeclaration getImport(String name) {
        return new ImportDeclaration(this, name);
    }

    @Override
    public ISourceRange getSourceRange() throws EGLModelException {
        IEGLElement[] imports = this.getChildren();
        ISourceRange firstRange = ((ISourceReference)((Object)imports[0])).getSourceRange();
        ISourceRange lastRange = ((ISourceReference)((Object)imports[imports.length - 1])).getSourceRange();
        SourceRange range = new SourceRange(firstRange.getOffset(), lastRange.getOffset() + lastRange.getLength() - firstRange.getOffset());
        return range;
    }

    @Override
    public boolean hasChildren() throws EGLModelException {
        return true;
    }

    @Override
    public String readableName() {
        return null;
    }

    @Override
    protected void toString(int tab, StringBuffer buffer) {
        Object info = EGLModelManager.getEGLModelManager().peekAtInfo(this);
        if (info == null || !(info instanceof EGLElementInfo)) {
            return;
        }
        IEGLElement[] children = ((EGLElementInfo)info).getChildren();
        int i = 0;
        while (i < children.length) {
            if (i > 0) {
                buffer.append("\n");
            }
            ((EGLElement)children[i]).toString(tab, buffer);
            ++i;
        }
    }

    @Override
    protected void toStringInfo(int tab, StringBuffer buffer, Object info) {
        buffer.append(this.tabString(tab));
        buffer.append("[import container]");
        if (info == null) {
            buffer.append(" (not open)");
        }
    }
}

