/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.edt.ide.core.internal.model.indexing;

import java.io.File;
import java.io.IOException;
import java.net.URI;
import java.util.Enumeration;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.Path;
import org.eclipse.edt.compiler.tools.IRUtils;
import org.eclipse.edt.ide.core.internal.model.Util;
import org.eclipse.edt.ide.core.internal.model.index.IIndex;
import org.eclipse.edt.ide.core.internal.model.index.IQueryResult;
import org.eclipse.edt.ide.core.internal.model.indexing.BinaryIndexer;
import org.eclipse.edt.ide.core.internal.model.indexing.EGLReadWriteMonitor;
import org.eclipse.edt.ide.core.internal.model.indexing.IndexManager;
import org.eclipse.edt.ide.core.internal.model.indexing.IndexRequest;
import org.eclipse.edt.ide.core.internal.model.search.EGLSearchDocument;
import org.eclipse.edt.ide.core.internal.model.search.EGLSearchParticipant;
import org.eclipse.edt.ide.core.internal.model.search.processing.JobManager;
import org.eclipse.edt.ide.core.internal.model.util.SimpleLookupTable;

public class AddEglarFileToIndex
extends IndexRequest {
    private IFile resource;
    private IProject project;

    public AddEglarFileToIndex(IFile resource, IndexManager manager) {
        super(resource.getFullPath(), manager);
        this.resource = resource;
        this.project = resource.getProject();
    }

    public AddEglarFileToIndex(IPath jarPath, IndexManager manager, IProject requestingProject) {
        super(jarPath, manager);
        this.project = requestingProject;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public boolean execute(IProgressMonitor progressMonitor) {
        if (this.isCancelled) return true;
        if (progressMonitor != null && progressMonitor.isCanceled()) {
            return true;
        }
        try {
            IIndex index = this.manager.getIndex(this.indexPath, false, false);
            if (index != null) {
                if (!JobManager.VERBOSE) return true;
                JobManager.verbose("-> no indexing required (index already exists) for " + this.indexPath);
                return true;
            }
            index = this.manager.getIndex(this.indexPath, true, true);
            if (index == null) {
                if (!JobManager.VERBOSE) return true;
                JobManager.verbose("-> index could not be created for " + this.indexPath);
                return true;
            }
            EGLReadWriteMonitor monitor = this.manager.getMonitorFor(index);
            if (monitor == null) {
                if (!JobManager.VERBOSE) return true;
                JobManager.verbose("-> index for " + this.indexPath + " just got deleted");
                return true;
            }
            ZipFile zip = null;
            try {
                Path zipFilePath = null;
                monitor.enterWrite();
                if (this.resource != null) {
                    File file;
                    URI location;
                    block34: {
                        location = this.resource.getLocationURI();
                        if (location == null) {
                            return false;
                        }
                        file = null;
                        try {
                            file = Util.toLocalFile(location, progressMonitor);
                        }
                        catch (CoreException e) {
                            if (!JobManager.VERBOSE) break block34;
                            JobManager.verbose("-> failed to index " + location.getPath() + " because of the following exception:");
                            e.printStackTrace();
                        }
                    }
                    if (file == null) {
                        if (!JobManager.VERBOSE) return false;
                        JobManager.verbose("-> failed to index " + location.getPath() + " because the file could not be fetched");
                        return false;
                    }
                    zip = new ZipFile(file);
                    zipFilePath = (Path)this.resource.getFullPath().makeRelative();
                } else {
                    zip = new ZipFile(this.indexPath.toFile());
                    zipFilePath = (Path)this.indexPath;
                }
                if (this.isCancelled) {
                    if (!JobManager.VERBOSE) return false;
                    JobManager.verbose("-> indexing of " + zip.getName() + " has been cancelled");
                    return false;
                }
                if (JobManager.VERBOSE) {
                    JobManager.verbose("-> indexing " + zip.getName());
                }
                long initialTime = System.currentTimeMillis();
                IQueryResult[] paths = null;
                paths = index.queryInDocumentNames("");
                if (paths != null) {
                    boolean needToReindex;
                    int max = paths.length;
                    String EXISTS = "OK";
                    String DELETED = "DELETED";
                    SimpleLookupTable indexedFileNames = new SimpleLookupTable(max == 0 ? 33 : max + 11);
                    int i = 0;
                    while (i < max) {
                        indexedFileNames.put(paths[i], DELETED);
                        ++i;
                    }
                    Enumeration<? extends ZipEntry> e = zip.entries();
                    while (e.hasMoreElements()) {
                        ZipEntry ze = e.nextElement();
                        String zipEntryName = ze.getName();
                        if (!IRUtils.isEGLIRFileName((String)zipEntryName) || !this.isValidPackageNameForIR(zipEntryName)) continue;
                        indexedFileNames.put(zipEntryName, EXISTS);
                    }
                    boolean bl = needToReindex = indexedFileNames.elementSize != max;
                    if (!needToReindex) {
                        Object[] valueTable = indexedFileNames.valueTable;
                        int i2 = 0;
                        int l = valueTable.length;
                        while (i2 < l) {
                            if (valueTable[i2] == DELETED) {
                                needToReindex = true;
                                break;
                            }
                            ++i2;
                        }
                        if (!needToReindex) {
                            if (JobManager.VERBOSE) {
                                JobManager.verbose("-> no indexing required (index is consistent with library) for " + zip.getName() + " (" + (System.currentTimeMillis() - initialTime) + "ms)");
                            }
                            this.manager.saveIndex(index);
                            return true;
                        }
                    }
                }
                BinaryIndexer binaryIndexer = new BinaryIndexer(this.project);
                EGLSearchParticipant participant = new EGLSearchParticipant();
                Enumeration<? extends ZipEntry> e = zip.entries();
                while (e.hasMoreElements()) {
                    if (this.isCancelled) {
                        if (!JobManager.VERBOSE) return false;
                        JobManager.verbose("-> indexing of " + zip.getName() + " has been cancelled");
                        return false;
                    }
                    ZipEntry ze = e.nextElement();
                    String zipEntryName = ze.getName();
                    if (!IRUtils.isEGLIRFileName((String)zipEntryName) || !this.isValidPackageNameForIR(zipEntryName)) continue;
                    byte[] classFileBytes = org.eclipse.edt.ide.core.internal.model.util.Util.getZipEntryByteContent(ze, zip);
                    EGLSearchDocument entryDocument = new EGLSearchDocument(ze, (IPath)zipFilePath, classFileBytes, participant);
                    index.add(entryDocument, binaryIndexer);
                }
                this.manager.saveIndex(index);
                if (!JobManager.VERBOSE) return true;
                JobManager.verbose("-> done indexing of " + zip.getName() + " (" + (System.currentTimeMillis() - initialTime) + "ms)");
                return true;
            }
            finally {
                if (zip != null) {
                    zip.close();
                }
                monitor.exitWrite();
            }
        }
        catch (IOException e) {
            if (JobManager.VERBOSE) {
                JobManager.verbose("-> failed to index " + this.indexPath + " because of the following exception:");
                e.printStackTrace();
            }
            this.manager.removeIndex(this.indexPath);
            return false;
        }
    }

    public String getJobFamily() {
        return this.indexPath.toOSString();
    }

    private boolean isValidPackageNameForIR(String className) {
        return !Util.isValidMofPackage(className);
    }

    @Override
    protected Integer updatedIndexState() {
        return IndexManager.REBUILDING_STATE;
    }

    public boolean equals(Object o) {
        if (o instanceof AddEglarFileToIndex) {
            if (this.resource != null) {
                return this.resource.equals((Object)((AddEglarFileToIndex)o).resource);
            }
            if (this.indexPath != null) {
                return this.indexPath.equals((Object)((AddEglarFileToIndex)o).indexPath);
            }
        }
        return false;
    }

    public int hashCode() {
        if (this.resource != null) {
            return this.resource.hashCode();
        }
        if (this.indexPath != null) {
            return this.indexPath.hashCode();
        }
        return -1;
    }

    public String toString() {
        return "indexing " + this.indexPath.toString();
    }
}

