/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.jpa.internal.jpql.parser;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.ListIterator;
import org.eclipse.persistence.jpa.internal.jpql.WordParser;
import org.eclipse.persistence.jpa.internal.jpql.parser.AbstractExpression;
import org.eclipse.persistence.jpa.internal.jpql.parser.Expression;
import org.eclipse.persistence.jpa.internal.jpql.parser.ExpressionVisitor;
import org.eclipse.persistence.jpa.internal.jpql.parser.IdentificationVariable;
import org.eclipse.persistence.jpa.internal.jpql.parser.StringExpression;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractPathExpression
extends AbstractExpression {
    private Boolean endsWithDot;
    private AbstractExpression identificationVariable;
    private List<String> paths;
    private boolean startsWithDot;
    private boolean virtualIdentificationVariable;

    AbstractPathExpression(AbstractExpression parent, AbstractExpression expression) {
        super(parent);
        this.identificationVariable = expression;
        this.identificationVariable.setParent(this);
    }

    AbstractPathExpression(AbstractExpression parent, String paths) {
        super(parent, paths);
    }

    @Override
    public void acceptChildren(ExpressionVisitor visitor) {
        this.getIdentificationVariable().accept(visitor);
    }

    @Override
    void addChildrenTo(Collection<Expression> children) {
        this.checkPaths();
        children.add(this.identificationVariable);
    }

    @Override
    final void addOrderedChildrenTo(List<StringExpression> children) {
        this.checkPaths();
        children.add(this.identificationVariable);
        children.add(this.buildStringExpression(this.getText()));
    }

    private void checkPaths() {
        if (this.paths == null) {
            boolean hasDot;
            this.paths = new ArrayList<String>();
            String text = this.getText();
            StringBuilder word = new StringBuilder();
            boolean bl = hasDot = text.indexOf(46) > -1;
            if (this.identificationVariable != null && !this.virtualIdentificationVariable) {
                this.paths.add(this.identificationVariable.toParsedText());
            }
            int count = text.length();
            for (int index = 0; index < count; ++index) {
                char character = text.charAt(index);
                if (index == 0 && character == '.' && this.identificationVariable != null) continue;
                if (character != '.') {
                    word.append(character);
                    continue;
                }
                if (hasDot && this.identificationVariable == null) {
                    this.identificationVariable = word.length() == 0 ? this.buildNullExpression() : new IdentificationVariable(this, word.toString());
                }
                this.paths.add(word.toString());
                word.delete(0, word.length());
            }
            if (this.identificationVariable == null) {
                this.identificationVariable = hasDot ? new IdentificationVariable(this, word.toString()) : this.buildNullExpression();
            }
            if (word.length() > 0) {
                this.paths.add(word.toString());
            }
        }
    }

    public final boolean endsWithDot() {
        if (this.endsWithDot == null) {
            String text = this.getText();
            this.endsWithDot = text.charAt(text.length() - 1) == '.';
        }
        return this.endsWithDot;
    }

    public final Expression getIdentificationVariable() {
        this.checkPaths();
        return this.identificationVariable;
    }

    public final String getPath(int index) {
        this.checkPaths();
        return this.paths.get(index);
    }

    public final boolean hasIdentificationVariable() {
        this.checkPaths();
        return !this.identificationVariable.isNull() && !this.identificationVariable.isVirtual();
    }

    public final boolean hasVirtualIdentificationVariable() {
        return this.virtualIdentificationVariable;
    }

    @Override
    final void parse(WordParser wordParser, boolean tolerant) {
        String word;
        if (this.identificationVariable != null) {
            word = wordParser.word();
            this.setText(word);
        } else {
            word = this.getText();
        }
        this.startsWithDot = word.startsWith(".");
        if (wordParser != null) {
            wordParser.moveForward(word);
        }
    }

    public final ListIterator<String> paths() {
        this.checkPaths();
        return Collections.unmodifiableList(this.paths).listIterator();
    }

    public final int pathSize() {
        this.checkPaths();
        return this.paths.size();
    }

    final void setVirtualIdentificationVariable(String variableName) {
        this.paths = null;
        this.virtualIdentificationVariable = true;
        this.identificationVariable = new IdentificationVariable(this, variableName, true);
        this.rebuildActualText();
        this.rebuildParsedText();
    }

    public final boolean startsWithDot() {
        return this.startsWithDot;
    }

    @Override
    final void toParsedText(StringBuilder writer, boolean includeVirtual) {
        this.checkPaths();
        int count = this.paths.size();
        for (int index = 0; index < count; ++index) {
            writer.append(this.paths.get(index));
            if (index >= count - 1) continue;
            writer.append('.');
        }
        if (this.endsWithDot()) {
            writer.append('.');
        }
    }
}

