/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jst.pagedesigner.css2.layout.table;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.draw2d.IFigure;
import org.eclipse.jst.pagedesigner.css2.ICSSStyle;
import org.eclipse.jst.pagedesigner.css2.layout.CSSFigure;
import org.eclipse.jst.pagedesigner.css2.layout.ICSSFigure;
import org.eclipse.jst.pagedesigner.css2.layout.table.TableInfoContext;
import org.eclipse.jst.pagedesigner.css2.layout.table.TableItemInfo;
import org.eclipse.jst.pagedesigner.css2.layout.table.TableRowInfo;

class TableRowGroupInfo
extends TableItemInfo {
    List _rowList = new ArrayList();
    private int _rowIndex;
    private int _rowCount;

    public TableRowGroupInfo(ICSSFigure figure) {
        super(figure);
    }

    List getRowList() {
        return this._rowList;
    }

    int getRowIndex() {
        return this._rowIndex;
    }

    int getRowCount() {
        return this._rowCount;
    }

    public void calculateRowGroup(TableInfoContext context) {
        this._rowIndex = context.getCurrentRow();
        List children = this.getFigure().getChildren();
        int i = 0;
        int size = children.size();
        while (i < size) {
            ICSSStyle childstyle;
            IFigure childfigure = (IFigure)children.get(i);
            if (childfigure instanceof ICSSFigure && (childstyle = ((ICSSFigure)childfigure).getCSSStyle()) != null && "table-row".equalsIgnoreCase(childstyle.getDisplay())) {
                TableRowInfo rowInfo = new TableRowInfo((ICSSFigure)childfigure);
                this._rowList.add(rowInfo);
                rowInfo.calculateRow(context);
            }
            ++i;
        }
        context.finishRowGroup();
        this._rowCount = context.getCurrentRow() - this._rowIndex;
    }

    public void getCells(List _cells) {
        int i = 0;
        int size = this._rowList.size();
        while (i < size) {
            TableRowInfo rowInfo = (TableRowInfo)this._rowList.get(i);
            rowInfo.getCells(_cells);
            ++i;
        }
    }

    public TableRowInfo findRowInfo(CSSFigure figure) {
        int i = 0;
        int size = this._rowList.size();
        while (i < size) {
            TableRowInfo rowInfo = (TableRowInfo)this._rowList.get(i);
            if (figure == rowInfo.getFigure()) {
                return rowInfo;
            }
            ++i;
        }
        return null;
    }
}

