/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jpt.jaxb.core.internal.context.java;

import java.beans.Introspector;
import java.util.List;
import org.eclipse.jdt.core.dom.CompilationUnit;
import org.eclipse.jpt.common.core.utility.TextRange;
import org.eclipse.jpt.common.utility.Filter;
import org.eclipse.jpt.common.utility.internal.CollectionTools;
import org.eclipse.jpt.common.utility.internal.StringTools;
import org.eclipse.jpt.common.utility.internal.iterables.EmptyIterable;
import org.eclipse.jpt.common.utility.internal.iterables.FilteringIterable;
import org.eclipse.jpt.common.utility.internal.iterables.TransformationIterable;
import org.eclipse.jpt.jaxb.core.context.JaxbPersistentType;
import org.eclipse.jpt.jaxb.core.context.XmlRootElement;
import org.eclipse.jpt.jaxb.core.internal.context.java.AbstractJavaContextNode;
import org.eclipse.jpt.jaxb.core.internal.validation.DefaultValidationMessages;
import org.eclipse.jpt.jaxb.core.resource.java.XmlRootElementAnnotation;
import org.eclipse.jpt.jaxb.core.xsd.XsdElementDeclaration;
import org.eclipse.jpt.jaxb.core.xsd.XsdSchema;
import org.eclipse.jpt.jaxb.core.xsd.XsdTypeDefinition;
import org.eclipse.wst.validation.internal.provisional.core.IMessage;
import org.eclipse.wst.validation.internal.provisional.core.IReporter;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class GenericJavaXmlRootElement
extends AbstractJavaContextNode
implements XmlRootElement {
    protected final XmlRootElementAnnotation resourceXmlRootElementAnnotation;
    protected String specifiedName;
    protected String specifiedNamespace;

    public GenericJavaXmlRootElement(JaxbPersistentType parent, XmlRootElementAnnotation resourceXmlRootElementAnnotation) {
        super(parent);
        this.resourceXmlRootElementAnnotation = resourceXmlRootElementAnnotation;
        this.specifiedName = this.getResourceName();
        this.specifiedNamespace = this.getResourceNamespace();
    }

    @Override
    public void synchronizeWithResourceModel() {
        super.synchronizeWithResourceModel();
        this.setSpecifiedName_(this.getResourceName());
        this.setSpecifiedNamespace_(this.getResourceNamespace());
    }

    @Override
    public JaxbPersistentType getParent() {
        return (JaxbPersistentType)super.getParent();
    }

    @Override
    public String getName() {
        return this.specifiedName != null ? this.specifiedName : this.getDefaultName();
    }

    @Override
    public String getSpecifiedName() {
        return this.specifiedName;
    }

    @Override
    public void setSpecifiedName(String name) {
        this.resourceXmlRootElementAnnotation.setName(name);
        this.setSpecifiedName_(name);
    }

    protected void setSpecifiedName_(String name) {
        String old = this.specifiedName;
        this.specifiedName = name;
        this.firePropertyChanged("specifiedName", old, name);
    }

    @Override
    public String getDefaultName() {
        return Introspector.decapitalize(this.getParent().getSimpleName());
    }

    protected String getResourceName() {
        return this.resourceXmlRootElementAnnotation.getName();
    }

    @Override
    public String getNamespace() {
        return this.specifiedNamespace != null ? this.specifiedNamespace : this.getDefaultNamespace();
    }

    @Override
    public String getSpecifiedNamespace() {
        return this.specifiedNamespace;
    }

    @Override
    public void setSpecifiedNamespace(String namespace) {
        this.resourceXmlRootElementAnnotation.setNamespace(namespace);
        this.setSpecifiedNamespace_(namespace);
    }

    protected void setSpecifiedNamespace_(String namespace) {
        String old = this.specifiedNamespace;
        this.specifiedNamespace = namespace;
        this.firePropertyChanged("specifiedNamespace", old, namespace);
    }

    @Override
    public String getDefaultNamespace() {
        return this.getParent().getJaxbPackage().getNamespace();
    }

    protected String getResourceNamespace() {
        return this.resourceXmlRootElementAnnotation.getNamespace();
    }

    @Override
    public Iterable<String> getJavaCompletionProposals(int pos, Filter<String> filter, CompilationUnit astRoot) {
        Iterable<String> result = super.getJavaCompletionProposals(pos, filter, astRoot);
        if (!CollectionTools.isEmpty(result)) {
            return result;
        }
        if (this.namespaceTouches(pos, astRoot)) {
            return this.getNamespaceProposals(filter);
        }
        if (this.nameTouches(pos, astRoot)) {
            return this.getNameProposals(filter);
        }
        return EmptyIterable.instance();
    }

    protected boolean namespaceTouches(int pos, CompilationUnit astRoot) {
        return this.resourceXmlRootElementAnnotation.namespaceTouches(pos, astRoot);
    }

    protected Iterable<String> getNamespaceProposals(Filter<String> filter) {
        XsdSchema schema = this.getParent().getJaxbPackage().getXsdSchema();
        if (schema == null) {
            return EmptyIterable.instance();
        }
        return schema.getNamespaceProposals(filter);
    }

    protected boolean nameTouches(int pos, CompilationUnit astRoot) {
        return this.resourceXmlRootElementAnnotation.nameTouches(pos, astRoot);
    }

    protected Iterable<String> getNameProposals(Filter<String> filter) {
        String namespace = this.getNamespace();
        XsdSchema schema = this.getParent().getJaxbPackage().getXsdSchema();
        if (schema == null) {
            return EmptyIterable.instance();
        }
        return StringTools.convertToJavaStringLiterals((Iterable)new FilteringIterable((Iterable)new TransformationIterable<XsdElementDeclaration, String>(schema.getElementDeclarations(namespace)){

            protected String transform(XsdElementDeclaration o) {
                return o.getName();
            }
        }, filter));
    }

    @Override
    public TextRange getValidationTextRange(CompilationUnit astRoot) {
        return this.resourceXmlRootElementAnnotation.getTextRange(astRoot);
    }

    @Override
    public void validate(List<IMessage> messages, IReporter reporter, CompilationUnit astRoot) {
        super.validate(messages, reporter, astRoot);
        String name = this.getName();
        String namespace = this.getNamespace();
        XsdSchema schema = this.getParent().getJaxbPackage().getXsdSchema();
        if (schema != null) {
            XsdElementDeclaration schemaElement = schema.getElementDeclaration(namespace, name);
            if (schemaElement == null) {
                messages.add(DefaultValidationMessages.buildMessage(1, "XML_ROOT_ELEMENT_UNRESOLVED_SCHEMA_ELEMENT", new String[]{name, namespace}, this, this.resourceXmlRootElementAnnotation.getTextRange(astRoot)));
            } else {
                XsdTypeDefinition schemaType = this.getParent().getXsdTypeDefinition();
                if (schemaType != null && !((Object)((Object)schemaType)).equals((Object)schemaElement.getType())) {
                    messages.add(DefaultValidationMessages.buildMessage(1, "XML_ROOT_ELEMENT_TYPE_CONFLICTS_WITH_XML_TYPE", new String[]{name, namespace}, this, this.resourceXmlRootElementAnnotation.getTextRange(astRoot)));
                }
            }
        }
    }

    public void toString(StringBuilder sb) {
        super.toString(sb);
        sb.append("namespace = \"" + this.specifiedNamespace + "\"");
        sb.append("; name = \"" + this.specifiedName + "\"");
    }
}

