/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jst.ws.internal.jaxws.ui.annotations.correction;

import java.util.List;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.jdt.core.dom.AST;
import org.eclipse.jdt.core.dom.ASTNode;
import org.eclipse.jdt.core.dom.CompilationUnit;
import org.eclipse.jdt.core.dom.IBinding;
import org.eclipse.jdt.core.dom.IExtendedModifier;
import org.eclipse.jdt.core.dom.MethodDeclaration;
import org.eclipse.jdt.core.dom.Modifier;
import org.eclipse.jdt.core.dom.TypeDeclaration;
import org.eclipse.jdt.core.dom.rewrite.ASTRewrite;
import org.eclipse.jdt.core.dom.rewrite.ListRewrite;
import org.eclipse.jdt.ui.text.java.IInvocationContext;
import org.eclipse.jst.ws.internal.jaxws.ui.annotations.correction.AbstractJavaCorrectionPropsoal;
import org.eclipse.ltk.core.refactoring.TextFileChange;
import org.eclipse.swt.graphics.Image;

public class ChangeModifierCorrectionProposal
extends AbstractJavaCorrectionPropsoal {
    private IBinding binding;
    private int includedModifiers;
    private int excludedModifiers;

    public ChangeModifierCorrectionProposal(IInvocationContext invocationContext, IBinding binding, int includedModifiers, int excludedModifiers, String displayString, int relevance, Image image) {
        super(invocationContext, displayString, relevance, image);
        this.binding = binding;
        this.includedModifiers = includedModifiers;
        this.excludedModifiers = excludedModifiers;
    }

    public void addEdits(TextFileChange textChange) throws CoreException {
        CompilationUnit astRoot = this.invocationContext.getASTRoot();
        AST ast = astRoot.getAST();
        ASTRewrite rewriter = ASTRewrite.create((AST)ast);
        ASTNode declaringNode = astRoot.findDeclaringNode(this.binding);
        int consideredModifierFlags = this.includedModifiers | this.excludedModifiers;
        int newModifierFlags = this.includedModifiers & consideredModifierFlags;
        ListRewrite listRewrite = this.getListRewrite(declaringNode, rewriter);
        if (listRewrite != null) {
            List originalList = listRewrite.getOriginalList();
            for (ASTNode astNode : originalList) {
                Modifier modifier;
                int modifierFlag;
                if (!(astNode instanceof Modifier) || (consideredModifierFlags & (modifierFlag = (modifier = (Modifier)astNode).getKeyword().toFlagValue())) == 0) continue;
                if ((newModifierFlags & modifierFlag) == 0) {
                    listRewrite.remove((ASTNode)modifier, null);
                }
                newModifierFlags &= ~modifierFlag;
            }
            List modifers = ast.newModifiers(newModifierFlags);
            ASTNode lastAnnotation = this.getLastAnnotation(listRewrite);
            for (Modifier modifier : modifers) {
                int modifierFlag = modifier.getKeyword().toFlagValue();
                if ((modifierFlag & 7) == 0) continue;
                if (lastAnnotation != null) {
                    listRewrite.insertAfter((ASTNode)modifier, lastAnnotation, null);
                    continue;
                }
                listRewrite.insertFirst((ASTNode)modifier, null);
            }
            textChange.addEdit(rewriter.rewriteAST());
        }
    }

    private ASTNode getLastAnnotation(ListRewrite listRewrite) {
        ASTNode lastAnnotation = null;
        List rewrittenList = listRewrite.getRewrittenList();
        for (ASTNode astNode : rewrittenList) {
            IExtendedModifier extendedModifier;
            if (!(astNode instanceof IExtendedModifier) || !(extendedModifier = (IExtendedModifier)astNode).isAnnotation()) continue;
            lastAnnotation = astNode;
        }
        return lastAnnotation;
    }

    private ListRewrite getListRewrite(ASTNode astNode, ASTRewrite astRewrite) {
        if (astNode instanceof MethodDeclaration) {
            MethodDeclaration methodDeclaration = (MethodDeclaration)astNode;
            return astRewrite.getListRewrite((ASTNode)methodDeclaration, MethodDeclaration.MODIFIERS2_PROPERTY);
        }
        if (astNode instanceof TypeDeclaration) {
            TypeDeclaration typeDeclaration = (TypeDeclaration)astNode;
            return astRewrite.getListRewrite((ASTNode)typeDeclaration, TypeDeclaration.MODIFIERS2_PROPERTY);
        }
        return null;
    }
}

