/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.swt.dnd;

import org.eclipse.swt.dnd.ByteArrayTransfer;
import org.eclipse.swt.dnd.DND;
import org.eclipse.swt.dnd.TransferData;
import org.eclipse.swt.internal.gtk.OS;

public class FileTransfer
extends ByteArrayTransfer {
    private static FileTransfer _instance = new FileTransfer();
    private static final String URI_LIST = "text/uri-list";
    private static final int URI_LIST_ID = FileTransfer.registerType("text/uri-list");
    private static final String GNOME_LIST = "x-special/gnome-copied-files";
    private static final int GNOME_LIST_ID = FileTransfer.registerType("x-special/gnome-copied-files");

    private FileTransfer() {
    }

    public static FileTransfer getInstance() {
        return _instance;
    }

    public void javaToNative(Object object, TransferData transferData) {
        byte[] separator;
        byte[] buffer;
        boolean gnomeList;
        transferData.result = 0;
        if (!this.checkFile(object) || !this.isSupportedType(transferData)) {
            DND.error(2003);
        }
        boolean bl = gnomeList = transferData.type == GNOME_LIST_ID;
        if (gnomeList) {
            buffer = new byte[]{99, 111, 112, 121};
            separator = new byte[]{10};
        } else {
            buffer = new byte[]{};
            separator = new byte[]{13, 10};
        }
        String[] files = (String[])object;
        int i = 0;
        while (i < files.length) {
            int length;
            String string = files[i];
            if (string != null && (length = string.length()) != 0) {
                char[] chars = new char[length];
                string.getChars(0, length, chars, 0);
                int[] error = new int[1];
                int utf8Ptr = OS.g_utf16_to_utf8(chars, chars.length, null, null, error);
                if (error[0] == 0 && utf8Ptr != 0) {
                    int localePtr = OS.g_filename_from_utf8(utf8Ptr, -1, null, null, error);
                    OS.g_free(utf8Ptr);
                    if (error[0] == 0 && localePtr != 0) {
                        int uriPtr = OS.g_filename_to_uri(localePtr, 0, error);
                        OS.g_free(localePtr);
                        if (error[0] == 0 && uriPtr != 0) {
                            length = OS.strlen(uriPtr);
                            byte[] temp = new byte[length];
                            OS.memmove(temp, uriPtr, length);
                            OS.g_free(uriPtr);
                            int newLength = buffer.length > 0 ? buffer.length + separator.length + temp.length : temp.length;
                            byte[] newBuffer = new byte[newLength];
                            int offset = 0;
                            if (buffer.length > 0) {
                                System.arraycopy(buffer, 0, newBuffer, 0, buffer.length);
                                System.arraycopy(separator, 0, newBuffer, offset += buffer.length, separator.length);
                                offset += separator.length;
                            }
                            System.arraycopy(temp, 0, newBuffer, offset, temp.length);
                            buffer = newBuffer;
                        }
                    }
                }
            }
            ++i;
        }
        if (buffer.length == 0) {
            return;
        }
        int ptr = OS.g_malloc(buffer.length + 1);
        OS.memset(ptr, 0, buffer.length + 1);
        OS.memmove(ptr, buffer, buffer.length);
        transferData.pValue = ptr;
        transferData.length = buffer.length;
        transferData.format = 8;
        transferData.result = 1;
    }

    public Object nativeToJava(TransferData transferData) {
        if (!this.isSupportedType(transferData) || transferData.pValue == 0 || transferData.length <= 0) {
            return null;
        }
        int length = transferData.length;
        byte[] temp = new byte[length];
        OS.memmove(temp, transferData.pValue, length);
        boolean gnomeList = transferData.type == GNOME_LIST_ID;
        int sepLength = gnomeList ? 1 : 2;
        int[] files = new int[]{};
        int offset = 0;
        int i = 0;
        while (i < temp.length - 1) {
            boolean terminator;
            boolean bl = gnomeList ? temp[i] == 10 : (terminator = temp[i] == 13 && temp[i + 1] == 10);
            if (terminator) {
                if (!gnomeList || offset != 0) {
                    int size = i - offset;
                    int file = OS.g_malloc(size + 1);
                    byte[] fileBuffer = new byte[size + 1];
                    System.arraycopy(temp, offset, fileBuffer, 0, size);
                    OS.memmove(file, fileBuffer, size + 1);
                    int[] newFiles = new int[files.length + 1];
                    System.arraycopy(files, 0, newFiles, 0, files.length);
                    newFiles[files.length] = file;
                    files = newFiles;
                }
                offset = i + sepLength;
            }
            ++i;
        }
        if (offset < temp.length - sepLength) {
            int size = temp.length - offset;
            int file = OS.g_malloc(size + 1);
            byte[] fileBuffer = new byte[size + 1];
            System.arraycopy(temp, offset, fileBuffer, 0, size);
            OS.memmove(file, fileBuffer, size + 1);
            int[] newFiles = new int[files.length + 1];
            System.arraycopy(files, 0, newFiles, 0, files.length);
            newFiles[files.length] = file;
            files = newFiles;
        }
        String[] fileNames = new String[]{};
        int i2 = 0;
        while (i2 < files.length) {
            int[] error = new int[1];
            int localePtr = OS.g_filename_from_uri(files[i2], null, error);
            OS.g_free(files[i2]);
            if (error[0] == 0 && localePtr != 0) {
                int utf8Ptr = OS.g_filename_to_utf8(localePtr, -1, null, null, error);
                OS.g_free(localePtr);
                if (error[0] == 0 && utf8Ptr != 0) {
                    int[] items_written = new int[1];
                    int utf16Ptr = OS.g_utf8_to_utf16(utf8Ptr, -1, null, items_written, null);
                    OS.g_free(utf8Ptr);
                    length = items_written[0];
                    char[] buffer = new char[length];
                    OS.memmove(buffer, utf16Ptr, length * 2);
                    OS.g_free(utf16Ptr);
                    String name = new String(buffer);
                    String[] newFileNames = new String[fileNames.length + 1];
                    System.arraycopy(fileNames, 0, newFileNames, 0, fileNames.length);
                    newFileNames[fileNames.length] = name;
                    fileNames = newFileNames;
                }
            }
            ++i2;
        }
        if (fileNames.length == 0) {
            return null;
        }
        return fileNames;
    }

    protected int[] getTypeIds() {
        return new int[]{URI_LIST_ID, GNOME_LIST_ID};
    }

    protected String[] getTypeNames() {
        return new String[]{URI_LIST, GNOME_LIST};
    }

    boolean checkFile(Object object) {
        if (object == null || !(object instanceof String[]) || ((String[])object).length == 0) {
            return false;
        }
        String[] strings = (String[])object;
        int i = 0;
        while (i < strings.length) {
            if (strings[i] == null || strings[i].length() == 0) {
                return false;
            }
            ++i;
        }
        return true;
    }

    protected boolean validate(Object object) {
        return this.checkFile(object);
    }
}

