/*
 * Decompiled with CFR 0.152.
 */
package resources.edt.binding;

import eglx.persistence.sql.SQLDataSource;
import eglx.persistence.sql.SQLJNDIDataSource;
import org.eclipse.edt.javart.resources.egldd.Binding;
import org.eclipse.edt.javart.resources.egldd.SQLDatabaseBinding;
import org.eclipse.edt.runtime.java.eglx.lang.EDictionary;
import resources.edt.binding.BindingFactory;

public class SqlFactory
extends BindingFactory {
    @Override
    public Object createResource(Binding binding) {
        SQLDataSource resource = null;
        if (binding instanceof SQLDatabaseBinding) {
            SQLDatabaseBinding sqlBinding = (SQLDatabaseBinding)binding;
            if (sqlBinding.isUseURI()) {
                String uri = sqlBinding.getUri();
                if (uri != null && uri.startsWith("jndi://")) {
                    String jndiName = uri.substring(7);
                    String user = sqlBinding.getSqlID();
                    String password = sqlBinding.getSqlPassword();
                    if (user.length() > 0 || password.length() > 0) {
                        EDictionary props = new EDictionary();
                        if (user.length() > 0) {
                            props.put((Object)"user", (Object)user);
                        }
                        if (password.length() > 0) {
                            props.put((Object)"password", (Object)password);
                        }
                        resource = new SQLJNDIDataSource(jndiName, (eglx.lang.EDictionary)props);
                    } else {
                        resource = new SQLJNDIDataSource(jndiName);
                    }
                }
            } else {
                EDictionary props = new EDictionary();
                String user = sqlBinding.getSqlID();
                String password = sqlBinding.getSqlPassword();
                String schema = sqlBinding.getSqlSchema();
                if (user != null) {
                    props.put((Object)"user", (Object)user);
                }
                if (password != null) {
                    props.put((Object)"password", (Object)password);
                }
                resource = new SQLDataSource(sqlBinding.getSqlDB(), (eglx.lang.EDictionary)props);
                String className = sqlBinding.getSqlJDBCDriverClass();
                if (className != null && className.length() > 0) {
                    try {
                        Class.forName(className);
                    }
                    catch (Throwable throwable) {}
                }
                if (schema != null && (schema = schema.trim()).length() > 0) {
                    resource.setCurrentSchema(schema);
                }
            }
        }
        return resource;
    }
}

