/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.edt.ide.rui.visualeditor.internal.util;

import org.eclipse.edt.ide.rui.visualeditor.internal.editor.EvConstants;

public class BidiFormat {
    private String widgetOrientation;
    private String textLayout;
    private String reverseTextDirection;
    private String symmetricSwapping;
    private String numericSwapping;

    public BidiFormat(String widgetOrientation, String textLayout, String reverseTextDirection, String symmetricSwapping, String numericSwapping) {
        this.widgetOrientation = widgetOrientation;
        this.textLayout = textLayout;
        this.reverseTextDirection = reverseTextDirection;
        this.symmetricSwapping = symmetricSwapping;
        this.numericSwapping = numericSwapping;
    }

    public String getWidgetOrientation() {
        return this.widgetOrientation;
    }

    public String getTextLayout() {
        return this.textLayout;
    }

    public String getReverseTextDirection() {
        return this.reverseTextDirection;
    }

    public String getSymmetricSwapping() {
        return this.symmetricSwapping;
    }

    public String getNumericSwapping() {
        return this.numericSwapping;
    }

    public boolean isDefaultBidiFormat() {
        return this.isDefaultWidgetOrientation() && this.isDefaultTextLayout() && this.isDefaultReverseTextDirection() && this.isDefaultSymmetricSwapping() && this.isDefaultNumericSwapping();
    }

    public boolean isDefaultNumericSwapping() {
        return EvConstants.PREFERENCE_DEFAULT_BIDI_NUM_SWAPPING.equals(this.numericSwapping);
    }

    public boolean isDefaultSymmetricSwapping() {
        return EvConstants.PREFERENCE_DEFAULT_BIDI_SYM_SWAPPING.equals(this.symmetricSwapping);
    }

    public boolean isDefaultReverseTextDirection() {
        return EvConstants.PREFERENCE_DEFAULT_BIDI_REVERSE_TEXT_DIRECTION.equals(this.reverseTextDirection);
    }

    public boolean isDefaultTextLayout() {
        return EvConstants.PREFERENCE_DEFAULT_BIDI_TEXT_LAYOUT.equals(this.textLayout);
    }

    public boolean isDefaultWidgetOrientation() {
        return EvConstants.PREFERENCE_DEFAULT_BIDI_WIDGET_ORIENTATION.equals(this.widgetOrientation);
    }
}

