/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.edt.ide.ui.internal.packageexplorer;

import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.edt.ide.core.model.IClassFile;
import org.eclipse.edt.ide.core.model.IEGLElement;
import org.eclipse.edt.ide.core.model.IEGLFile;
import org.eclipse.edt.ide.ui.internal.UINlsStrings;
import org.eclipse.edt.ide.ui.internal.actions.OpenIRFileAction;
import org.eclipse.jface.action.GroupMarker;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.ui.IActionBars;
import org.eclipse.ui.actions.OpenFileAction;
import org.eclipse.ui.actions.OpenWithMenu;
import org.eclipse.ui.navigator.CommonActionProvider;
import org.eclipse.ui.navigator.ICommonActionExtensionSite;
import org.eclipse.ui.navigator.ICommonViewerWorkbenchSite;

public class OpenActionProvider
extends CommonActionProvider {
    private OpenFileAction openFileAction;
    private OpenIRFileAction openIRFileAction;
    private ICommonViewerWorkbenchSite viewSite = null;
    private boolean contribute = false;

    public void init(ICommonActionExtensionSite aConfig) {
        if (aConfig.getViewSite() instanceof ICommonViewerWorkbenchSite) {
            this.viewSite = (ICommonViewerWorkbenchSite)aConfig.getViewSite();
            this.openFileAction = new OpenFileAction(this.viewSite.getPage());
            this.openIRFileAction = new OpenIRFileAction(this.viewSite.getPage());
            this.openFileAction.setActionDefinitionId("org.eclipse.jdt.ui.edit.text.java.open.editor");
            this.contribute = true;
        }
    }

    public void fillContextMenu(IMenuManager menu) {
        if (!this.contribute || this.getContext().getSelection().isEmpty()) {
            return;
        }
        IStructuredSelection selection = (IStructuredSelection)this.getContext().getSelection();
        if (selection.size() == 1) {
            Object selObj = selection.getFirstElement();
            if (selObj instanceof IClassFile) {
                this.openIRFileAction.setClassFile((IClassFile)selObj);
                menu.insertAfter("group.open", (IAction)this.openIRFileAction);
            }
        } else {
            this.openFileAction.selectionChanged(selection);
            if (this.openFileAction.isEnabled()) {
                menu.insertAfter("group.open", (IAction)this.openFileAction);
            }
        }
        this.addOpenWithMenu(selection, menu);
    }

    private void addOpenWithMenu(IStructuredSelection ss, IMenuManager menu) {
        if (ss.isEmpty()) {
            return;
        }
        if (ss.size() != 1) {
            return;
        }
        Object o = ss.getFirstElement();
        if (!(o instanceof IEGLFile)) {
            return;
        }
        IEGLFile element = (IEGLFile)o;
        IResource resource = element.getResource();
        if (!(resource instanceof IFile)) {
            return;
        }
        MenuManager submenu = new MenuManager(UINlsStrings.EGLOpenActionProvider_OpenWith, "group.openWith");
        submenu.add((IContributionItem)new GroupMarker("group.top"));
        submenu.add((IContributionItem)new OpenWithMenu(this.viewSite.getPage(), (IAdaptable)((IFile)resource)));
        submenu.add((IContributionItem)new GroupMarker("additions"));
        menu.appendToGroup("group.openWith", (IContributionItem)submenu);
    }

    public void fillActionBars(IActionBars theActionBars) {
        if (!this.contribute) {
            return;
        }
        IStructuredSelection selection = (IStructuredSelection)this.getContext().getSelection();
        if (this.selectionChangedToEGL(selection)) {
            if (selection.getFirstElement() instanceof IClassFile) {
                theActionBars.setGlobalActionHandler("org.eclipse.ui.navigator.Open", (IAction)this.openIRFileAction);
            } else {
                theActionBars.setGlobalActionHandler("org.eclipse.ui.navigator.Open", (IAction)this.openFileAction);
            }
        }
    }

    private boolean selectionChangedToEGL(IStructuredSelection selection) {
        if (selection.size() == 1) {
            if (selection.getFirstElement() instanceof IEGLFile) {
                IEGLElement eglElem = (IEGLElement)selection.getFirstElement();
                IResource resource = eglElem.getResource();
                if (resource != null) {
                    this.openFileAction.selectionChanged((IStructuredSelection)new StructuredSelection((Object)resource));
                    return true;
                }
            } else if (selection.getFirstElement() instanceof IClassFile) {
                IEGLElement eglElem = (IEGLElement)selection.getFirstElement();
                this.openIRFileAction.setClassFile((IClassFile)eglElem);
                return true;
            }
        }
        return false;
    }
}

