/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.edt.ide.ui.internal.project.wizards;

import java.io.File;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.StringTokenizer;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.Status;
import org.eclipse.jface.dialogs.ErrorDialog;
import org.eclipse.jface.dialogs.MessageDialogWithToggle;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IPerspectiveDescriptor;
import org.eclipse.ui.IPerspectiveRegistry;
import org.eclipse.ui.IPluginContribution;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.WorkbenchException;
import org.eclipse.ui.activities.IActivityManager;
import org.eclipse.ui.activities.IIdentifier;
import org.eclipse.ui.activities.IWorkbenchActivitySupport;
import org.eclipse.ui.activities.WorkbenchActivityHelper;
import org.eclipse.ui.internal.WorkbenchPlugin;
import org.eclipse.ui.internal.ide.IDEWorkbenchPlugin;
import org.eclipse.ui.internal.registry.PerspectiveDescriptor;
import org.eclipse.ui.internal.util.PrefUtil;
import org.eclipse.ui.internal.wizards.newresource.ResourceMessages;

public class ProjectWizardUtils {
    private static final String FINAL_PERSPECTIVE = "finalPerspective";
    private static final String PREFERRED_PERSPECTIVES = "preferredPerspectives";
    private static String WINDOW_PROBLEMS_TITLE = ResourceMessages.NewProject_errorOpeningWindow;

    public static boolean isPlatformCaseSensitive() {
        return "macosx".equals(Platform.getOS()) ? false : new File("a").compareTo(new File("A")) != 0;
    }

    public static IStatus createErrorStatus(String message) {
        return ProjectWizardUtils.createErrorStatus(message, null);
    }

    public static IStatus createErrorStatus(String message, Throwable exception) {
        return new Status(4, "org.eclipse.edt.ide.ui", -1, message, exception);
    }

    public static final Display getDisplay() {
        Display display = Display.getCurrent();
        if (display == null) {
            display = Display.getDefault();
        }
        return display;
    }

    public static void updatePerspective(IConfigurationElement configElement) {
        int workbenchPerspectiveSetting;
        IWorkbenchWindow window;
        if (configElement == null) {
            return;
        }
        String perspSetting = PrefUtil.getAPIPreferenceStore().getString("PROJECT_OPEN_NEW_PERSPECTIVE");
        String promptSetting = IDEWorkbenchPlugin.getDefault().getPreferenceStore().getString("SWITCH_PERSPECTIVE_ON_PROJECT_CREATION");
        if (!promptSetting.equals("prompt") && perspSetting.equals("NO_NEW_PERSPECTIVE")) {
            return;
        }
        String finalPerspId = configElement.getAttribute(FINAL_PERSPECTIVE);
        if (finalPerspId == null) {
            return;
        }
        IPerspectiveRegistry reg = PlatformUI.getWorkbench().getPerspectiveRegistry();
        IPerspectiveDescriptor finalPersp = reg.findPerspectiveWithId(finalPerspId);
        if (finalPersp != null && finalPersp instanceof IPluginContribution) {
            HashSet enabledIds;
            IWorkbenchActivitySupport workbenchActivitySupport;
            IActivityManager activityManager;
            IIdentifier identifier;
            Set idActivities;
            IPluginContribution contribution = (IPluginContribution)finalPersp;
            if (contribution.getPluginId() != null && !(idActivities = (identifier = (activityManager = (workbenchActivitySupport = PlatformUI.getWorkbench().getActivitySupport()).getActivityManager()).getIdentifier(WorkbenchActivityHelper.createUnifiedId((IPluginContribution)contribution))).getActivityIds()).isEmpty() && (enabledIds = new HashSet(activityManager.getEnabledActivityIds())).addAll(idActivities)) {
                workbenchActivitySupport.setEnabledActivityIds(enabledIds);
            }
        } else {
            IDEWorkbenchPlugin.log((String)("Unable to find persective " + finalPerspId + " in BasicNewProjectResourceWizard.updatePerspective"));
            return;
        }
        ArrayList preferredPerspIds = new ArrayList();
        ProjectWizardUtils.addPerspectiveAndDescendants(preferredPerspIds, finalPerspId);
        String preferred = configElement.getAttribute(PREFERRED_PERSPECTIVES);
        if (preferred != null) {
            StringTokenizer tok = new StringTokenizer(preferred, " \t\n\r\f,");
            while (tok.hasMoreTokens()) {
                ProjectWizardUtils.addPerspectiveAndDescendants(preferredPerspIds, tok.nextToken());
            }
        }
        if ((window = PlatformUI.getWorkbench().getActiveWorkbenchWindow()) != null) {
            IPerspectiveDescriptor currentPersp;
            IWorkbenchPage page = window.getActivePage();
            if (page != null && (currentPersp = page.getPerspective()) != null && preferredPerspIds.contains(currentPersp.getId())) {
                return;
            }
            if (!ProjectWizardUtils.confirmPerspectiveSwitch(window, finalPersp)) {
                return;
            }
        }
        if ((workbenchPerspectiveSetting = WorkbenchPlugin.getDefault().getPreferenceStore().getInt("OPEN_PERSPECTIVE_MODE")) == 2) {
            ProjectWizardUtils.openInNewWindow(finalPersp);
            return;
        }
        ProjectWizardUtils.replaceCurrentPerspective(finalPersp);
    }

    private static void addPerspectiveAndDescendants(List perspectiveIds, String id) {
        IPerspectiveRegistry registry = PlatformUI.getWorkbench().getPerspectiveRegistry();
        IPerspectiveDescriptor[] perspectives = registry.getPerspectives();
        int i = 0;
        while (i < perspectives.length) {
            PerspectiveDescriptor descriptor = (PerspectiveDescriptor)perspectives[i];
            if (descriptor.getOriginalId().equals(id)) {
                perspectiveIds.add(descriptor.getId());
            }
            ++i;
        }
    }

    private static boolean confirmPerspectiveSwitch(IWorkbenchWindow window, IPerspectiveDescriptor finalPersp) {
        IPreferenceStore store = IDEWorkbenchPlugin.getDefault().getPreferenceStore();
        String pspm = store.getString("SWITCH_PERSPECTIVE_ON_PROJECT_CREATION");
        if (!"prompt".equals(pspm)) {
            return "always".equals(pspm);
        }
        String desc = finalPersp.getDescription();
        String message = desc == null || desc.length() == 0 ? NLS.bind((String)ResourceMessages.NewProject_perspSwitchMessage, (Object)finalPersp.getLabel()) : NLS.bind((String)ResourceMessages.NewProject_perspSwitchMessageWithDesc, (Object[])new String[]{finalPersp.getLabel(), desc});
        MessageDialogWithToggle dialog = MessageDialogWithToggle.openYesNoQuestion((Shell)window.getShell(), (String)ResourceMessages.NewProject_perspSwitchTitle, (String)message, null, (boolean)false, (IPreferenceStore)store, (String)"SWITCH_PERSPECTIVE_ON_PROJECT_CREATION");
        int result = dialog.getReturnCode();
        if (dialog.getToggleState()) {
            String preferenceValue = result == 2 ? "OPEN_PERSPECTIVE_REPLACE" : "NO_NEW_PERSPECTIVE";
            PrefUtil.getAPIPreferenceStore().setValue("PROJECT_OPEN_NEW_PERSPECTIVE", preferenceValue);
        }
        return result == 2;
    }

    private static void openInNewWindow(IPerspectiveDescriptor desc) {
        block2: {
            try {
                PlatformUI.getWorkbench().openWorkbenchWindow(desc.getId(), (IAdaptable)ResourcesPlugin.getWorkspace().getRoot());
            }
            catch (WorkbenchException e) {
                IWorkbenchWindow window = PlatformUI.getWorkbench().getActiveWorkbenchWindow();
                if (window == null) break block2;
                ErrorDialog.openError((Shell)window.getShell(), (String)WINDOW_PROBLEMS_TITLE, (String)e.getMessage(), (IStatus)e.getStatus());
            }
        }
    }

    private static void replaceCurrentPerspective(IPerspectiveDescriptor persp) {
        IWorkbenchWindow window = PlatformUI.getWorkbench().getActiveWorkbenchWindow();
        if (window == null) {
            return;
        }
        IWorkbenchPage page = window.getActivePage();
        if (page == null) {
            return;
        }
        page.setPerspective(persp);
    }
}

