/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.edt.ide.ui.internal.property.pages;

import java.io.File;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.IPath;
import org.eclipse.edt.ide.ui.internal.util.StringUtility;
import org.eclipse.jdt.core.ITypeRoot;
import org.eclipse.ui.IWorkingSet;

public class BasicElementLabels {
    public static String getPathLabel(IPath path, boolean isOSPath) {
        String label = isOSPath ? path.toOSString() : path.makeRelative().toString();
        return StringUtility.markLTR(label);
    }

    public static String getPathLabel(File file) {
        return StringUtility.markLTR(file.getAbsolutePath(), "");
    }

    public static String getFilePattern(String name) {
        return StringUtility.markLTR(name, "*.?");
    }

    public static String getURLPart(String name) {
        return StringUtility.markLTR(name, ":@?-");
    }

    public static String getResourceName(IResource resource) {
        return StringUtility.markLTR(resource.getName());
    }

    public static String getResourceName(String resourceName) {
        return StringUtility.markLTR(resourceName);
    }

    public static String getFileName(ITypeRoot typeRoot) {
        return StringUtility.markLTR(typeRoot.getElementName());
    }

    public static String getJavaElementName(String name) {
        return StringUtility.markLTR(name, "<>()?,{}");
    }

    public static String getJavaCodeString(String string) {
        return StringUtility.markLTR(string, "<>()?,{}+-*!%=");
    }

    public static String getVersionName(String name) {
        return StringUtility.markLTR(name);
    }

    public static String getWorkingSetLabel(IWorkingSet set) {
        return StringUtility.markLTR(set.getLabel(), "");
    }
}

