/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.edt.ide.rui.visualeditor.internal.widget.gen.handlers;

import org.eclipse.edt.ide.rui.visualeditor.internal.widget.gen.handlers.ArrayTypeBindingHandler;
import org.eclipse.edt.ide.rui.visualeditor.internal.widget.gen.handlers.DataTypeBindingHandler;
import org.eclipse.edt.ide.rui.visualeditor.internal.widget.gen.handlers.FlexibleRecordBindingHandler;
import org.eclipse.edt.ide.rui.visualeditor.internal.widget.gen.handlers.PrimitiveTypeBindingHandler;
import org.eclipse.edt.ide.rui.visualeditor.internal.wizards.insertwidget.InsertDataModel;
import org.eclipse.edt.mof.egl.ArrayType;
import org.eclipse.edt.mof.egl.Member;
import org.eclipse.edt.mof.egl.Record;
import org.eclipse.edt.mof.egl.Type;
import org.eclipse.edt.mof.egl.utils.TypeUtils;

public class BindingHandlerManager {
    private static BindingHandlerManager instance;
    private final FlexibleRecordBindingHandler recordHandler = new FlexibleRecordBindingHandler();
    private final PrimitiveTypeBindingHandler primitiveHandler = new PrimitiveTypeBindingHandler();
    private final ArrayTypeBindingHandler arrayHandler = new ArrayTypeBindingHandler();

    private BindingHandlerManager() {
    }

    public static BindingHandlerManager getInstance() {
        if (instance == null) {
            instance = new BindingHandlerManager();
        }
        return instance;
    }

    public void handle(Member dataBinding, Type typeBinding, InsertDataModel insertDataModel) {
        DataTypeBindingHandler handler = null;
        if (typeBinding instanceof ArrayType) {
            handler = this.arrayHandler;
        } else if (typeBinding instanceof Record) {
            handler = this.recordHandler;
        } else if (TypeUtils.isPrimitive((Type)typeBinding)) {
            handler = this.primitiveHandler;
        }
        if (handler != null) {
            handler.handle(dataBinding, typeBinding, insertDataModel);
        }
    }
}

