/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.edt.ide.core.internal.model;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import org.eclipse.edt.ide.core.model.EGLCore;
import org.eclipse.edt.ide.core.model.IEGLElement;
import org.eclipse.swt.dnd.ByteArrayTransfer;
import org.eclipse.swt.dnd.TransferData;

public class EGLElementTransfer
extends ByteArrayTransfer {
    private static final EGLElementTransfer fInstance = new EGLElementTransfer();
    private static final String TYPE_NAME = "egl-element-transfer-format:" + System.currentTimeMillis() + ":" + ((Object)((Object)fInstance)).hashCode();
    private static final int TYPEID = EGLElementTransfer.registerType((String)TYPE_NAME);

    protected int[] getTypeIds() {
        return new int[]{TYPEID};
    }

    protected String[] getTypeNames() {
        return new String[]{TYPE_NAME};
    }

    public static EGLElementTransfer getInstance() {
        return fInstance;
    }

    protected void javaToNative(Object data, TransferData transferData) {
        if (!(data instanceof IEGLElement[])) {
            return;
        }
        IEGLElement[] eglElements = (IEGLElement[])data;
        try {
            ByteArrayOutputStream out = new ByteArrayOutputStream();
            DataOutputStream dataOut = new DataOutputStream(out);
            dataOut.writeInt(eglElements.length);
            int i = 0;
            while (i < eglElements.length) {
                EGLElementTransfer.writeEGLElement(dataOut, eglElements[i]);
                ++i;
            }
            dataOut.close();
            out.close();
            byte[] bytes = out.toByteArray();
            super.javaToNative((Object)bytes, transferData);
        }
        catch (IOException iOException) {}
    }

    protected Object nativeToJava(TransferData transferData) {
        byte[] bytes = (byte[])super.nativeToJava(transferData);
        if (bytes == null) {
            return null;
        }
        DataInputStream in = new DataInputStream(new ByteArrayInputStream(bytes));
        try {
            int count = in.readInt();
            IEGLElement[] results = new IEGLElement[count];
            int i = 0;
            while (i < count) {
                results[i] = this.readEGLElement(in);
                ++i;
            }
            return results;
        }
        catch (IOException iOException) {
            return null;
        }
    }

    private IEGLElement readEGLElement(DataInputStream dataIn) throws IOException {
        String handleIdentifier = dataIn.readUTF();
        return EGLCore.create(handleIdentifier);
    }

    private static void writeEGLElement(DataOutputStream dataOut, IEGLElement element) throws IOException {
        dataOut.writeUTF(element.getHandleIdentifier());
    }
}

