/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.edt.ide.core.internal.search.matching;

import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.edt.compiler.internal.core.utils.CharOperation;
import org.eclipse.edt.ide.core.internal.model.ClassFile;
import org.eclipse.edt.ide.core.internal.model.EGLElement;
import org.eclipse.edt.ide.core.internal.model.SourcePartElementInfo;
import org.eclipse.edt.ide.core.internal.search.PartInfo;
import org.eclipse.edt.ide.core.internal.search.matching.MatchLocator2;
import org.eclipse.edt.ide.core.internal.utils.Util;
import org.eclipse.edt.ide.core.model.EGLCore;
import org.eclipse.edt.ide.core.model.EGLModelException;
import org.eclipse.edt.ide.core.model.IEGLElement;
import org.eclipse.edt.ide.core.model.IField;
import org.eclipse.edt.ide.core.model.IFunction;
import org.eclipse.edt.ide.core.model.IPart;
import org.eclipse.edt.ide.core.model.Signature;

public class ClassFileMatchLocator {
    private MatchLocator2 locator;
    private int matchContainer;
    private boolean locateDeclaration;
    private boolean locateReference;

    public ClassFileMatchLocator(MatchLocator2 locator2) {
        this.locator = locator2;
        this.matchContainer = this.locator.matchContainer();
        this.locateDeclaration = this.locator.getPattern().getPatternType() == 1 || this.locator.getPattern().getPatternType() == 3;
        this.locateReference = this.locator.getPattern().getPatternType() == 2 || this.locator.getPattern().getPatternType() == 3;
    }

    public void locateMatches(ClassFile classFile) {
        this.matchBinary(classFile);
    }

    boolean matchBinary(ClassFile classFile) {
        IPart part = classFile.getPart();
        ClassFileMatchLocator.convertClassFileFormat(classFile.getPart().getFullyQualifiedName().toCharArray());
        try {
            classFile.getPackageDeclarations();
        }
        catch (EGLModelException e) {
            e.printStackTrace();
        }
        return this.matchPartDeclaration(part);
    }

    boolean matchFunctionDeclaration(IFunction function) {
        if (this.locateReference) {
            try {
                IPart fieldPart;
                PartInfo fieldPartInfo;
                IProject project = function.getEGLProject().getProject();
                String[] parameterTypes = function.getParameterTypes();
                String[] parameterPackages = function.getParameterPackages();
                int i = 0;
                while (i < function.getNumberOfParameters()) {
                    if (parameterPackages[i] != null) {
                        String type = Signature.toString(parameterTypes[i]);
                        type = this.getElementType(type);
                        fieldPartInfo = Util.getDataDeclarationPart(EGLCore.create(project), parameterPackages[i], type);
                        if (fieldPartInfo != null) {
                            fieldPart = fieldPartInfo.resolvePart(Util.createSearchScope((IResource)project));
                            this.matchFieldReference(fieldPart, function.getDeclaringPart());
                        }
                    }
                    ++i;
                }
                String returnType = function.getReturnTypeName();
                returnType = this.getElementType(returnType);
                String returnPackage = function.getReturnTypePackage();
                if (returnPackage != null && (fieldPartInfo = Util.getDataDeclarationPart(EGLCore.create(project), returnPackage, returnType)) != null) {
                    fieldPart = fieldPartInfo.resolvePart(Util.createSearchScope((IResource)project));
                    this.matchFieldReference(fieldPart, function.getDeclaringPart());
                }
            }
            catch (EGLModelException e) {
                e.printStackTrace();
            }
        }
        try {
            if (function.getParent() instanceof IPart && ((SourcePartElementInfo)((EGLElement)function.getParent()).getElementInfo()).isDelegate()) {
                return true;
            }
        }
        catch (EGLModelException e) {
            e.printStackTrace();
        }
        if (this.locateDeclaration && ((this.matchContainer & 0xA) != 0 || (this.matchContainer & 2) != 0)) {
            int level = this.getMatchingLevel(function);
            if (level == 1 || level == 2) {
                level = this.locator.getPattern().matchesFunctionPartType(function);
            }
            if (level == 2 || level == 3) {
                try {
                    this.locator.reportFunctionDeclaration(function, (IEGLElement)function.getDeclaringPart(), level == 2 ? 0 : 1);
                }
                catch (CoreException e) {
                    e.printStackTrace();
                }
            }
        }
        return true;
    }

    boolean matchPartDeclaration(IPart part) {
        if (this.locateDeclaration && (this.matchContainer & 1) != 0) {
            int level = this.getMatchingLevel(part);
            if (level == 1 || level == 2) {
                level = this.locator.matchesPart(part);
            }
            if (level == 2 || level == 3) {
                try {
                    this.locator.reportPartDeclaration(part, null, level == 2 ? 0 : 1);
                }
                catch (CoreException e) {
                    e.printStackTrace();
                }
            }
        }
        try {
            int n;
            Object object;
            SourcePartElementInfo partInfo = (SourcePartElementInfo)((EGLElement)((Object)part)).getElementInfo();
            IProject project = part.getEGLProject().getProject();
            if (this.locateReference) {
                String[] usagePartTypes = part.getUsePartTypes();
                String[] usagePartPackages = part.getUsePartPackages();
                if (usagePartTypes != null) {
                    int i = 0;
                    while (i < usagePartTypes.length) {
                        if (usagePartPackages[i] != null) {
                            String type = usagePartTypes[i];
                            type = this.getElementType(type);
                            PartInfo fieldPartInfo = Util.getUsePart(EGLCore.create(project), usagePartPackages[i], type);
                            if (fieldPartInfo != null) {
                                IPart fieldPart = fieldPartInfo.resolvePart(Util.createSearchScope((IResource)project));
                                this.matchFieldReference(fieldPart, part);
                            }
                        }
                        ++i;
                    }
                }
            }
            if (this.locateReference && partInfo.getInterfaceNames() != null) {
                char[][] cArray = partInfo.getInterfaceNames();
                object = cArray;
                n = cArray.length;
                int n2 = 0;
                while (n2 < n) {
                    IEGLElement interfaceName = object[n2];
                    String fullqualifiedName = String.valueOf((char[])interfaceName);
                    String pkg = "";
                    String typeName = fullqualifiedName;
                    int index = fullqualifiedName.lastIndexOf(".");
                    if (index != -1) {
                        pkg = fullqualifiedName.substring(0, index);
                        typeName = fullqualifiedName.substring(index + 1);
                    }
                    typeName = this.getElementType(typeName);
                    PartInfo interfacePartInfo = Util.getDataDeclarationPart(EGLCore.create(project), pkg, typeName);
                    if (interfacePartInfo != null) {
                        IPart interfacePart = interfacePartInfo.resolvePart(Util.createSearchScope((IResource)project));
                        this.matchInterfaceReference(interfacePart, part);
                    }
                    ++n2;
                }
            }
            object = partInfo.getChildren();
            n = ((IEGLElement[])object).length;
            int n3 = 0;
            while (n3 < n) {
                String pkg;
                IEGLElement child = object[n3];
                if (child instanceof IFunction) {
                    this.matchFunctionDeclaration((IFunction)child);
                } else if (child instanceof IField && this.locateReference && (pkg = ((IField)child).getTypeDeclaredPackage()) != null) {
                    String type = ((IField)child).getTypeName();
                    type = this.getElementType(type);
                    PartInfo fieldPartInfo = Util.getDataDeclarationPart(EGLCore.create(project), pkg, type);
                    if (fieldPartInfo != null) {
                        IPart fieldPart = fieldPartInfo.resolvePart(Util.createSearchScope((IResource)project));
                        this.matchFieldReference(fieldPart, ((IField)child).getDeclaringPart());
                    }
                }
                ++n3;
            }
        }
        catch (EGLModelException e1) {
            e1.printStackTrace();
        }
        return true;
    }

    boolean matchInterfaceReference(IPart part, IPart declaredPart) {
        if ((this.locator.getPattern().getPatternType() == 2 || this.locator.getPattern().getPatternType() == 3) && (this.matchContainer & 2) != 0) {
            int level = this.getMatchingLevel(part);
            if (level == 1 || level == 2) {
                level = this.locator.matchesPart(part);
            }
            if (level == 2 || level == 3) {
                this.locator.reportReference(part, declaredPart, level == 2 ? 0 : 1);
            }
        }
        return true;
    }

    boolean matchFieldReference(IPart part, IPart declaredPart) {
        if (this.locateReference && (this.matchContainer & 4) != 0) {
            int level = this.getMatchingLevel(part);
            if (level == 1 || level == 2) {
                level = this.locator.matchesPart(part);
            }
            if (level == 2 || level == 3) {
                this.locator.reportReference(part, declaredPart, level == 2 ? 0 : 1);
            }
        }
        return true;
    }

    public static char[] convertClassFileFormat(char[] name) {
        return CharOperation.replaceOnCopy((char[])name, (char)'/', (char)'.');
    }

    public int getMatchingLevel(IPart part) {
        return this.locator.matchCheck(part);
    }

    private String getElementType(String type) {
        while (true) {
            int lp = type.lastIndexOf("[");
            int rp = type.lastIndexOf("]");
            if (lp == -1 || rp == -1 || lp >= rp) {
                return type;
            }
            type = type.substring(0, lp);
        }
    }
}

