/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.edt.ide.core.internal.utils;

import java.io.BufferedReader;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import org.xml.sax.Locator;
import org.xml.sax.SAXException;
import org.xml.sax.XMLReader;
import org.xml.sax.ext.Locator2;
import org.xml.sax.helpers.DefaultHandler;
import org.xml.sax.helpers.XMLReaderFactory;

public class FileContentsUtility {
    public static String getFileContents(String fileName) throws Exception {
        File file = new File(FileContentsUtility.getFullFileName(fileName));
        Reader reader = FileContentsUtility.getFileReader(file);
        int length = (int)file.length();
        char[] fileContents = new char[length];
        int len = 0;
        int readSize = 0;
        while (readSize != -1 && len != length) {
            readSize = reader.read(fileContents, len += readSize, length - len);
        }
        reader.close();
        if (len != length) {
            char[] cArray = fileContents;
            fileContents = new char[len];
            System.arraycopy(cArray, 0, fileContents, 0, len);
        }
        return new String(fileContents);
    }

    public static String getFileContents(String fileName, String encoding) throws Exception {
        InputStream is = new FileInputStream(new File(fileName));
        byte[] bytes = new byte[((InputStream)is).available()];
        ((InputStream)is).read(bytes);
        ((InputStream)is).close();
        is = new ByteArrayInputStream(bytes);
        BufferedReader inputReader = new BufferedReader(new InputStreamReader(is, encoding));
        return FileContentsUtility.buildStringBuffer(inputReader).toString();
    }

    private static StringBuffer buildStringBuffer(BufferedReader inputReader) {
        StringBuffer s = new StringBuffer();
        try {
            char[] cbuf = new char[4096];
            int length = 0;
            while ((length = inputReader.read(cbuf)) >= 0) {
                s.append(cbuf, 0, length);
            }
        }
        catch (IOException iOException) {}
        return s;
    }

    public static String getFileContentsFromXML(String fileName) throws Exception {
        new SAXEncodingDetector();
        String encoding = SAXEncodingDetector.getEncoding(FileContentsUtility.getFullFileName(fileName));
        if (encoding == null) {
            return FileContentsUtility.getFileContents(fileName);
        }
        try {
            return FileContentsUtility.getFileContents(fileName, encoding);
        }
        catch (Exception exception) {
            return FileContentsUtility.getFileContents(fileName);
        }
    }

    public static String getFullFileName(String fileName) {
        if (fileName == null) {
            return null;
        }
        File file = new File(fileName);
        if (!file.exists()) {
            return fileName;
        }
        try {
            return file.getCanonicalPath();
        }
        catch (IOException iOException) {
            return file.getAbsolutePath();
        }
    }

    protected static Reader getFileReader(File file) throws Exception {
        return new FileReader(file);
    }

    private static class SAXEncodingDetector
    extends DefaultHandler {
        private String encoding;
        private Locator2 locator;

        private SAXEncodingDetector() {
        }

        public static String getEncoding(String fileName) throws SAXException, IOException {
            XMLReader parser = XMLReaderFactory.createXMLReader();
            SAXEncodingDetector handler = new SAXEncodingDetector();
            parser.setContentHandler(handler);
            try {
                parser.parse(new File(fileName).toURI().toURL().toExternalForm());
            }
            catch (SAXException sAXException) {
                return handler.encoding;
            }
            catch (Exception exception) {
                return null;
            }
            return null;
        }

        @Override
        public void setDocumentLocator(Locator locator) {
            if (locator instanceof Locator2) {
                this.locator = (Locator2)locator;
            } else {
                this.encoding = null;
            }
        }

        @Override
        public void startDocument() throws SAXException {
            if (this.locator != null) {
                this.encoding = this.locator.getEncoding();
            }
            throw new SAXException("Kill Me Now");
        }
    }
}

