/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.edt.ide.ui.internal.contentassist.proposalhandlers;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.eclipse.edt.compiler.internal.util.BindingUtil;
import org.eclipse.edt.ide.ui.internal.UINlsStrings;
import org.eclipse.edt.ide.ui.internal.contentassist.EGLCompletionProposal;
import org.eclipse.edt.ide.ui.internal.contentassist.proposalhandlers.EGLAbstractProposalHandler;
import org.eclipse.edt.mof.egl.AccessKind;
import org.eclipse.edt.mof.egl.Classifier;
import org.eclipse.edt.mof.egl.Element;
import org.eclipse.edt.mof.egl.Enumeration;
import org.eclipse.edt.mof.egl.Field;
import org.eclipse.edt.mof.egl.Function;
import org.eclipse.edt.mof.egl.FunctionMember;
import org.eclipse.edt.mof.egl.Member;
import org.eclipse.edt.mof.egl.Record;
import org.eclipse.edt.mof.egl.Service;
import org.eclipse.edt.mof.egl.Type;
import org.eclipse.edt.mof.utils.NameUtile;
import org.eclipse.jface.text.ITextViewer;
import org.eclipse.ui.IEditorPart;

public class EGLVariableDotProposalHandler
extends EGLAbstractProposalHandler {
    private Type qualifierType;
    private boolean isVariable;

    public EGLVariableDotProposalHandler(ITextViewer viewer, int documentOffset, String prefix, IEditorPart editor, Type qualifierType, boolean isVariable) {
        super(viewer, documentOffset, prefix, editor);
        this.qualifierType = qualifierType;
        this.isVariable = isVariable;
    }

    public List getProposals(boolean includeFunctions) {
        return this.getProposals(includeFunctions, new ArrayList<Field>());
    }

    public List getProposals(boolean includeFunctions, List<Field> excludeFields) {
        ArrayList result = new ArrayList();
        if (this.qualifierType != null && this.qualifierType.getClassifier() != null) {
            List list;
            if (this.qualifierType.getClassifier() instanceof Enumeration) {
                Enumeration enm = (Enumeration)this.qualifierType.getClassifier();
                list = enm.getAllMembers();
            } else {
                list = BindingUtil.getAllFields((Type)this.qualifierType.getClassifier());
            }
            list = this.filterDuplicateNamedFields(list);
            list = this.filterPrivateMembers(this.qualifierType.getClassifier(), list);
            list = this.filterExcludedFields(excludeFields, list);
            if (!this.isVariable) {
                list = this.filterStaticMembers(list);
            }
            result.addAll(this.getFieldProposals(list));
            if (includeFunctions) {
                list = BindingUtil.getAllFunctions((Type)this.qualifierType.getClassifier());
                list = this.filterDuplicateNamedFunctions(list);
                list = this.filterPrivateMembers(this.qualifierType.getClassifier(), list);
                if (!this.isVariable && !(this.qualifierType.getClassifier() instanceof Service)) {
                    list = this.filterStaticMembers(list);
                }
                result.addAll(this.getFunctionProposals(list, UINlsStrings.bind((String)UINlsStrings.CAProposal_PartFunction, (Object)EGLVariableDotProposalHandler.getTypeString(this.qualifierType)), 75, true));
            }
            return result;
        }
        return Collections.EMPTY_LIST;
    }

    private List filterExcludedFields(List<Field> exclude, List list) {
        ArrayList newList = new ArrayList();
        for (Object obj : list) {
            if (exclude.contains(obj)) continue;
            newList.add(obj);
        }
        return newList;
    }

    private List filterDuplicateNamedFields(List list) {
        ArrayList<Member> newList = new ArrayList<Member>();
        ArrayList<String> names = new ArrayList<String>();
        for (Object obj : list) {
            Member mbr = (Member)obj;
            String name = NameUtile.getAsName((String)mbr.getCaseSensitiveName());
            if (names.contains(name)) continue;
            names.add(name);
            newList.add(mbr);
        }
        return newList;
    }

    private List filterDuplicateNamedFunctions(List list) {
        ArrayList<Function> newList = new ArrayList<Function>();
        ArrayList<String> sigs = new ArrayList<String>();
        for (Object obj : list) {
            Function function = (Function)obj;
            String sig = this.getFunctionSignature(function);
            if (sigs.contains(sig)) continue;
            sigs.add(sig);
            newList.add(function);
        }
        return newList;
    }

    private List filterPrivateMembers(Classifier classifier, List list) {
        ArrayList<Member> newList = new ArrayList<Member>();
        for (Object obj : list) {
            Member mbr = (Member)obj;
            if (mbr.getAccessKind() == AccessKind.ACC_PRIVATE && mbr.getContainer() != classifier) continue;
            newList.add(mbr);
        }
        return newList;
    }

    private List filterStaticMembers(List members) {
        ArrayList<Member> filteredList = new ArrayList<Member>();
        for (Member next : members) {
            if (!next.isStatic().booleanValue()) continue;
            filteredList.add(next);
        }
        return filteredList;
    }

    private List getFieldProposals(List<Member> fields, String ImgKeyStr) {
        ArrayList<EGLCompletionProposal> result = new ArrayList<EGLCompletionProposal>();
        String fieldImgKeyStr = ImgKeyStr == "" ? "org.eclipse.edt.ide.ui.envvar_obj.gif" : ImgKeyStr;
        String recfieldImgKeyStr = ImgKeyStr == "" ? "org.eclipse.edt.ide.ui.stritm_obj.gif" : ImgKeyStr;
        for (Member field : fields) {
            String proposalString = field.getCaseSensitiveName();
            if (!proposalString.toUpperCase().startsWith(this.getPrefix().toUpperCase())) continue;
            String displayString = String.valueOf(proposalString) + " : " + EGLVariableDotProposalHandler.getTypeString(field.getType()) + " - " + EGLVariableDotProposalHandler.getNameFromElement((Element)field.getContainer());
            String imgname = field.getContainer() instanceof Record ? recfieldImgKeyStr : fieldImgKeyStr;
            result.add(new EGLCompletionProposal(this.viewer, displayString, proposalString, this.getAdditionalInfo(field), this.getDocumentOffset() - this.getPrefix().length(), this.getPrefix().length(), proposalString.length(), 74, imgname));
        }
        return result;
    }

    private List getFieldProposals(List<Member> fields) {
        return this.getFieldProposals(fields, "");
    }

    private List getFunctionProposals(List<Function> functions, String additionalInformation, int relevance) {
        return this.getFunctionProposals(functions, additionalInformation, relevance, false);
    }

    private List getFunctionProposals(List<Function> functions, String additionalInformation, int relevance, boolean returnPrivateFunctions) {
        ArrayList result = new ArrayList();
        for (Function function : functions) {
            if (!returnPrivateFunctions && function.getAccessKind() == AccessKind.ACC_PRIVATE || !function.getName().toUpperCase().startsWith(this.getPrefix().toUpperCase())) continue;
            result.addAll(this.createFunctionInvocationProposals((FunctionMember)function, additionalInformation, relevance, false));
        }
        return result;
    }
}

