/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.edt.ide.ui.internal.editor;

import java.util.HashMap;
import org.eclipse.edt.compiler.core.ast.IASTVisitor;
import org.eclipse.edt.compiler.core.ast.Node;
import org.eclipse.edt.ide.core.model.document.IEGLDocument;
import org.eclipse.edt.ide.ui.internal.editor.ScriptDoubleClickVisitor;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.ITextDoubleClickStrategy;
import org.eclipse.jface.text.ITextViewer;

public class ScriptDoubleClickSelector
implements ITextDoubleClickStrategy {
    private static final String IF = "if";
    private static final String END = "end";
    private static final String ELSE = "else";
    private static final String WHILE = "while";
    private static final String FOR = "for";
    private static final String FOREACH = "foreach";
    private static final String TRY = "try";
    private static final String ONEXCEPTION = "onexception";
    private static final String CASE = "case";
    private static final String WHEN = "when";
    private static final String OTHERWISE = "otherwise";
    private static final String OPENUI = "openui";
    private static final String ONEVENT = "onevent";
    protected ITextViewer fText;
    protected int fPos;
    protected int fStartPos;
    protected int fEndPos;
    protected static char[] fgBrackets = new char[]{'{', '}', '(', ')', '[', ']', '\"', '\"'};
    protected static HashMap fgConditionalPairs = new HashMap();

    static {
        fgConditionalPairs.put(IF, END);
        fgConditionalPairs.put(IF, ELSE);
        fgConditionalPairs.put(ELSE, END);
        fgConditionalPairs.put(WHILE, END);
        fgConditionalPairs.put(CASE, END);
        fgConditionalPairs.put(FOR, END);
        fgConditionalPairs.put(FOREACH, END);
        fgConditionalPairs.put(TRY, END);
        fgConditionalPairs.put(TRY, ONEXCEPTION);
        fgConditionalPairs.put(ONEXCEPTION, END);
        fgConditionalPairs.put(WHEN, WHEN);
        fgConditionalPairs.put(WHEN, OTHERWISE);
        fgConditionalPairs.put(OTHERWISE, END);
        fgConditionalPairs.put(OPENUI, END);
        fgConditionalPairs.put(ONEVENT, ONEVENT);
        fgConditionalPairs.put(ONEVENT, END);
    }

    public void doubleClicked(ITextViewer text) {
        this.fPos = text.getSelectedRange().x;
        if (this.fPos < 0) {
            return;
        }
        this.fText = text;
        if (this.selectBracketBlock()) {
            return;
        }
        if (this.selectConditionalBlock()) {
            return;
        }
        this.selectWord();
    }

    protected boolean selectConditionalBlock() {
        if (this.matchConditional()) {
            if (this.fStartPos == this.fEndPos) {
                this.fText.setSelectedRange(this.fStartPos, 0);
            } else {
                this.fText.setSelectedRange(this.fStartPos, this.fEndPos - this.fStartPos);
            }
            return true;
        }
        return false;
    }

    protected boolean matchConditional() {
        IEGLDocument egldoc;
        Node node;
        IDocument doc = this.fText.getDocument();
        if (doc instanceof IEGLDocument && (node = (egldoc = (IEGLDocument)doc).getNewModelNodeAtOffset(this.fPos)) != null) {
            ScriptDoubleClickVisitor visitor = new ScriptDoubleClickVisitor(doc, this.fPos);
            node.accept((IASTVisitor)visitor);
            if (visitor.foundDoubleClickOffset()) {
                int doubleClickOffset = visitor.getDoubleClickOffset();
                this.fStartPos = Math.min(this.fPos, doubleClickOffset);
                this.fEndPos = Math.max(this.fPos, doubleClickOffset);
                return true;
            }
        }
        return false;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected boolean matchBracketsAt() {
        int bracketIndex1 = fgBrackets.length;
        int bracketIndex2 = fgBrackets.length;
        this.fStartPos = -1;
        this.fEndPos = -1;
        try {
            IDocument doc = this.fText.getDocument();
            char prevChar = doc.getChar(this.fPos - 1);
            char nextChar = doc.getChar(this.fPos);
            int i = 0;
            while (i < fgBrackets.length) {
                if (prevChar == fgBrackets[i]) {
                    this.fStartPos = this.fPos - 1;
                    bracketIndex1 = i;
                }
                i += 2;
            }
            i = 1;
            while (i < fgBrackets.length) {
                if (nextChar == fgBrackets[i]) {
                    this.fEndPos = this.fPos;
                    bracketIndex2 = i;
                }
                i += 2;
            }
            if (this.fStartPos > -1 && bracketIndex1 < bracketIndex2) {
                this.fEndPos = this.searchForClosingBracket(this.fStartPos, prevChar, fgBrackets[bracketIndex1 + 1], doc);
                if (this.fEndPos > -1) {
                    return true;
                }
                this.fStartPos = -1;
                return false;
            }
            if (this.fEndPos <= -1) return false;
            this.fStartPos = this.searchForOpenBracket(this.fEndPos, fgBrackets[bracketIndex2 - 1], nextChar, doc);
            if (this.fStartPos > -1) {
                return true;
            }
            this.fEndPos = -1;
            return false;
        }
        catch (BadLocationException badLocationException) {}
        return false;
    }

    protected boolean matchWord() {
        IDocument doc = this.fText.getDocument();
        try {
            char c;
            int pos = this.fPos;
            while (pos >= 0) {
                c = doc.getChar(pos);
                if (!Character.isJavaIdentifierPart(c) && c != '-') break;
                --pos;
            }
            this.fStartPos = pos;
            pos = this.fPos;
            int length = doc.getLength();
            while (pos < length) {
                c = doc.getChar(pos);
                if (!Character.isJavaIdentifierPart(c) && c != '-') break;
                ++pos;
            }
            this.fEndPos = pos;
            return true;
        }
        catch (BadLocationException badLocationException) {
            return false;
        }
    }

    protected int searchForClosingBracket(int startPos, char openBracket, char closeBracket, IDocument doc) throws BadLocationException {
        int stack = 1;
        int closePos = startPos + 1;
        int length = doc.getLength();
        while (closePos < length && stack > 0) {
            char nextChar = doc.getChar(closePos);
            if (nextChar == openBracket && nextChar != closeBracket) {
                ++stack;
            } else if (nextChar == closeBracket) {
                --stack;
            }
            ++closePos;
        }
        if (stack == 0) {
            return closePos - 1;
        }
        return -1;
    }

    protected int searchForOpenBracket(int startPos, char openBracket, char closeBracket, IDocument doc) throws BadLocationException {
        int stack = 1;
        int openPos = startPos - 1;
        while (openPos >= 0 && stack > 0) {
            char nextChar = doc.getChar(openPos);
            if (nextChar == closeBracket && nextChar != openBracket) {
                ++stack;
            } else if (nextChar == openBracket) {
                --stack;
            }
            --openPos;
        }
        if (stack == 0) {
            return openPos + 1;
        }
        return -1;
    }

    protected boolean selectBracketBlock() {
        if (this.matchBracketsAt()) {
            if (this.fStartPos == this.fEndPos) {
                this.fText.setSelectedRange(this.fStartPos, 0);
            } else {
                this.fText.setSelectedRange(this.fStartPos + 1, this.fEndPos - this.fStartPos - 1);
            }
            return true;
        }
        return false;
    }

    protected void selectWord() {
        if (this.matchWord()) {
            if (this.fStartPos == this.fEndPos) {
                this.fText.setSelectedRange(this.fStartPos, 0);
            } else {
                this.fText.setSelectedRange(this.fStartPos + 1, this.fEndPos - this.fStartPos - 1);
            }
        }
    }
}

