/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.edt.compiler;

import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.Stack;
import org.eclipse.edt.compiler.binding.IPartBinding;
import org.eclipse.edt.compiler.internal.core.builder.BuildException;
import org.eclipse.edt.compiler.internal.core.builder.CancelledException;
import org.eclipse.edt.compiler.internal.core.builder.CircularBuildRequestException;
import org.eclipse.edt.compiler.internal.core.builder.IBuildNotifier;
import org.eclipse.edt.compiler.internal.core.lookup.ICompilerOptions;
import org.eclipse.edt.compiler.internal.util.PackageAndPartName;
import org.eclipse.edt.mof.utils.NameUtile;

public abstract class AbstractProcessingQueue {
    public static final int LEVEL_THREE = 3;
    public static final int LEVEL_TWO = 2;
    public static final int LEVEL_ONE = 1;
    protected LinkedHashMap<ProcessingUnitKey, ProcessingUnit> pendingUnits = new LinkedHashMap();
    private Stack<ProcessingUnitKey> processingStack = new Stack();
    private HashMap<ProcessingUnitKey, Integer> unitsBeingProcessedToCompileLevel = new HashMap();
    private HashSet<ProcessingUnitKey> processedUnits = new HashSet();
    protected ICompilerOptions compilerOptions;
    protected IBuildNotifier notifier;
    protected int unitsCompiled = 0;
    private int compileThreshold = 0;
    protected int compileLoop = 0;
    private float increment = 0.4f;
    public int totalUnitsCompiled = 0;
    public int numRequestsDenied = 0;
    public int numCompilesAborted = 0;
    public long startTime = 0L;
    public int numTopLevelFunctionsCompiled = 0;
    public int numErrorsReported = 0;
    public static final boolean DEBUG = false;

    public AbstractProcessingQueue(IBuildNotifier notifier, ICompilerOptions compilerOptions) {
        this.notifier = notifier;
        this.compilerOptions = compilerOptions;
    }

    public void addPart(PackageAndPartName ppName) {
        this.pendingUnits.put(new ProcessingUnitKey(ppName.getPackageName(), ppName.getPartName()), new ProcessingUnit(ppName));
    }

    public boolean isPending(String packageName, String caseInsensitivePartName) {
        return this.pendingUnits.containsKey(new ProcessingUnitKey(packageName, caseInsensitivePartName));
    }

    private void initProgress() {
        ++this.compileLoop;
        this.compileThreshold = this.pendingUnits.size();
        this.unitsCompiled = 0;
        if (this.compileThreshold > 0) {
            this.notifier.setProgressPerEGLPart(this.increment / (float)this.compileThreshold);
        }
        this.increment /= 2.0f;
    }

    private void updateProgress() {
        this.notifier.compiled();
        ++this.unitsCompiled;
        if (this.unitsCompiled == this.compileThreshold && !this.pendingUnits.isEmpty()) {
            this.initProgress();
        }
    }

    protected abstract boolean hasExceededMaxLoop();

    public void process() {
        this.initProgress();
        while (!this.pendingUnits.isEmpty()) {
            if (this.hasExceededMaxLoop()) {
                this.notifier.setAborted(true);
                return;
            }
            Iterator<ProcessingUnit> iterator = this.pendingUnits.values().iterator();
            ProcessingUnit processingUnit = iterator.next();
            this.process(processingUnit, 3);
        }
    }

    public IPartBinding process(ProcessingUnit processingUnit, int compileLevel) {
        IPartBinding result = null;
        String name = processingUnit.ppName.getPartName();
        this.processingStack.add(new ProcessingUnitKey(processingUnit.ppName.getPackageName(), name));
        this.unitsBeingProcessedToCompileLevel.put(new ProcessingUnitKey(processingUnit.ppName.getPackageName(), name), new Integer(compileLevel));
        try {
            switch (compileLevel) {
                case 3: {
                    this.pendingUnits.remove(new ProcessingUnitKey(processingUnit.ppName.getPackageName(), name));
                    result = this.level03Compile(processingUnit.ppName);
                    this.updateProgress();
                    this.processedUnits.add(new ProcessingUnitKey(processingUnit.ppName.getPackageName(), name));
                    break;
                }
                case 2: {
                    result = this.level02Compile(processingUnit.ppName);
                    break;
                }
                case 1: {
                    result = this.level01Compile(processingUnit.ppName);
                }
            }
        }
        catch (CircularBuildRequestException e) {
            throw e;
        }
        catch (CancelledException e) {
            throw e;
        }
        catch (BuildException e) {
            throw e;
        }
        catch (RuntimeException e) {
            throw new BuildException(e);
        }
        this.unitsBeingProcessedToCompileLevel.remove(new ProcessingUnitKey(processingUnit.ppName.getPackageName(), name));
        this.processingStack.remove(this.processingStack.size() - 1);
        return result;
    }

    protected abstract IPartBinding level03Compile(PackageAndPartName var1);

    protected abstract IPartBinding level02Compile(PackageAndPartName var1);

    protected abstract IPartBinding level01Compile(PackageAndPartName var1);

    protected abstract IPartBinding getPartBindingFromCache(String var1, String var2);

    public IPartBinding requestCompilationFor(String packageName, String caseInsensitivePartName, boolean force) {
        if (this.isBeingProcessed(packageName, caseInsensitivePartName)) {
            if (this.isBeingCompiled(packageName, caseInsensitivePartName)) {
                return this.getPartBindingFromCache(packageName, caseInsensitivePartName);
            }
            if (this.getCurrentCompileLevel() == 2) {
                return this.getPartBindingFromCache(packageName, caseInsensitivePartName);
            }
            throw new CircularBuildRequestException();
        }
        if (this.isPending(packageName, caseInsensitivePartName)) {
            if (this.processingStack.size() >= 10) {
                ProcessingUnit processingUnit = this.pendingUnits.get(new ProcessingUnitKey(packageName, caseInsensitivePartName));
                if (force) {
                    return this.process(processingUnit, 2);
                }
                return this.process(processingUnit, this.getCurrentCompileLevel() - 1);
            }
            try {
                IPartBinding partBindingFromCache = this.getPartBindingFromCache(packageName, caseInsensitivePartName);
                if (partBindingFromCache != null) {
                    return partBindingFromCache;
                }
                ProcessingUnit processingUnit = this.pendingUnits.get(new ProcessingUnitKey(packageName, caseInsensitivePartName));
                return this.process(processingUnit, 3);
            }
            catch (CircularBuildRequestException circularBuildRequestException) {
                this.reschedulePart(packageName, caseInsensitivePartName);
                ProcessingUnit processingUnit = this.pendingUnits.get(new ProcessingUnitKey(packageName, caseInsensitivePartName));
                return this.process(processingUnit, 2);
            }
        }
        return null;
    }

    private boolean isBeingProcessed(String packageName, String caseInsensitivePartName) {
        return this.processingStack.contains(new ProcessingUnitKey(packageName, caseInsensitivePartName));
    }

    public void reschedulePart(String packageName, String caseInsensitivePartName) {
        this.processingStack.remove(new ProcessingUnitKey(packageName, caseInsensitivePartName));
        this.unitsBeingProcessedToCompileLevel.remove(new ProcessingUnitKey(packageName, caseInsensitivePartName));
        this.doAddPart(packageName, caseInsensitivePartName);
    }

    protected abstract void doAddPart(String var1, String var2);

    private int getCurrentCompileLevel() {
        return this.unitsBeingProcessedToCompileLevel.get(this.processingStack.get(this.processingStack.size() - 1));
    }

    private boolean isBeingCompiled(String packageName, String caseInsensitivePartName) {
        return this.processingStack.indexOf(new ProcessingUnitKey(packageName, caseInsensitivePartName)) == this.processingStack.size() - 1;
    }

    public class ProcessingUnit {
        PackageAndPartName ppName;

        ProcessingUnit(PackageAndPartName ppName) {
            this.ppName = ppName;
        }
    }

    public class ProcessingUnitKey {
        private String packageName;
        private String caseInsensitivePartName;

        public ProcessingUnitKey(String packageName, String caseInsensitivePartName) {
            this.packageName = packageName;
            this.caseInsensitivePartName = caseInsensitivePartName;
        }

        public boolean equals(Object otherObject) {
            if (this == otherObject) {
                return true;
            }
            if (otherObject instanceof ProcessingUnitKey) {
                ProcessingUnitKey otherPUKey = (ProcessingUnitKey)otherObject;
                return NameUtile.equals((String)otherPUKey.packageName, (String)this.packageName) && NameUtile.equals((String)otherPUKey.caseInsensitivePartName, (String)this.caseInsensitivePartName);
            }
            return false;
        }

        public int hashCode() {
            return this.caseInsensitivePartName.hashCode();
        }
    }
}

