/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.edt.compiler.binding;

import java.math.BigDecimal;
import org.eclipse.edt.compiler.binding.SettingsBlockAnnotationBindingsCompletor;
import org.eclipse.edt.compiler.core.Boolean;
import org.eclipse.edt.compiler.core.ast.AbstractASTExpressionVisitor;
import org.eclipse.edt.compiler.core.ast.AnnotationExpression;
import org.eclipse.edt.compiler.core.ast.ArrayAccess;
import org.eclipse.edt.compiler.core.ast.ArrayLiteral;
import org.eclipse.edt.compiler.core.ast.BinaryExpression;
import org.eclipse.edt.compiler.core.ast.BooleanLiteral;
import org.eclipse.edt.compiler.core.ast.BytesLiteral;
import org.eclipse.edt.compiler.core.ast.DecimalLiteral;
import org.eclipse.edt.compiler.core.ast.Expression;
import org.eclipse.edt.compiler.core.ast.FloatLiteral;
import org.eclipse.edt.compiler.core.ast.FunctionInvocation;
import org.eclipse.edt.compiler.core.ast.IntegerLiteral;
import org.eclipse.edt.compiler.core.ast.Node;
import org.eclipse.edt.compiler.core.ast.NullLiteral;
import org.eclipse.edt.compiler.core.ast.QualifiedName;
import org.eclipse.edt.compiler.core.ast.SQLLiteral;
import org.eclipse.edt.compiler.core.ast.SetValuesExpression;
import org.eclipse.edt.compiler.core.ast.SimpleName;
import org.eclipse.edt.compiler.core.ast.StringLiteral;
import org.eclipse.edt.compiler.core.ast.TypeLiteralExpression;
import org.eclipse.edt.compiler.core.ast.UnaryExpression;
import org.eclipse.edt.compiler.internal.core.builder.IProblemRequestor;
import org.eclipse.edt.compiler.internal.core.dependency.IDependencyRequestor;
import org.eclipse.edt.compiler.internal.core.lookup.AnnotationLeftHandScope;
import org.eclipse.edt.compiler.internal.core.lookup.DefaultBinder;
import org.eclipse.edt.compiler.internal.core.lookup.ICompilerOptions;
import org.eclipse.edt.compiler.internal.core.lookup.Scope;
import org.eclipse.edt.mof.egl.Annotation;
import org.eclipse.edt.mof.egl.AnnotationType;
import org.eclipse.edt.mof.egl.Element;
import org.eclipse.edt.mof.egl.IrFactory;
import org.eclipse.edt.mof.egl.Part;
import org.eclipse.edt.mof.egl.Type;
import org.eclipse.edt.mof.utils.EList;

public class AnnotationValueGatherer
extends DefaultBinder {
    Expression expr;
    Object value;
    boolean isNegative;

    public AnnotationValueGatherer(Expression expr, Scope currentScope, Part currentBinding, IDependencyRequestor dependencyRequestor, IProblemRequestor problemRequestor, ICompilerOptions compilerOptions) {
        super(currentScope, currentBinding, dependencyRequestor, problemRequestor, compilerOptions);
        this.expr = expr;
    }

    public Object getValue() {
        this.expr.accept(this);
        return this.value;
    }

    @Override
    public void endVisit(SimpleName simpleName) {
        this.value = simpleName.resolveElement() != null ? simpleName.resolveElement() : simpleName.resolveType();
    }

    @Override
    public void endVisit(QualifiedName qualifiedName) {
        this.value = qualifiedName.resolveElement() != null ? qualifiedName.resolveElement() : qualifiedName.resolveType();
    }

    @Override
    public void endVisit(ArrayAccess arrayAccess) {
        this.value = arrayAccess.resolveMember();
    }

    @Override
    public boolean visit(IntegerLiteral integerLiteral) {
        String str = integerLiteral.getValue();
        if (this.isNegative) {
            str = "-" + str;
        }
        try {
            this.value = new Integer(str);
        }
        catch (NumberFormatException numberFormatException) {
            this.problemRequestor.acceptProblem((Node)integerLiteral, 3250, new String[]{str});
            this.value = null;
        }
        integerLiteral.setBindAttempted(true);
        return false;
    }

    @Override
    public boolean visit(FloatLiteral floatLiteral) {
        String str = floatLiteral.getValue();
        if (this.isNegative) {
            str = "-" + str;
        }
        this.value = new Double(str);
        floatLiteral.setBindAttempted(true);
        return false;
    }

    @Override
    public boolean visit(DecimalLiteral decimalLiteral) {
        String str = decimalLiteral.getValue();
        if (this.isNegative) {
            str = "-" + str;
        }
        this.value = new BigDecimal(str);
        decimalLiteral.setBindAttempted(true);
        return false;
    }

    @Override
    public boolean visit(StringLiteral stringLiteral) {
        this.value = stringLiteral.getValue();
        stringLiteral.setBindAttempted(true);
        return false;
    }

    @Override
    public void endVisit(BinaryExpression binaryExpression) {
        super.endVisit(binaryExpression);
        BinaryExpressionVisitor subVisitor = new BinaryExpressionVisitor(this.problemRequestor);
        binaryExpression.accept(subVisitor);
        if (!subVisitor.exprValid) {
            this.problemRequestor.acceptProblem(binaryExpression, 5188);
        } else {
            this.value = subVisitor.getConcatenatedString();
        }
    }

    @Override
    public boolean visit(NullLiteral nullLiteral) {
        this.value = IrFactory.INSTANCE.createNullLiteral();
        nullLiteral.setBindAttempted(true);
        return false;
    }

    @Override
    public boolean visit(BooleanLiteral booleanLiteral) {
        this.value = new java.lang.Boolean(booleanLiteral.booleanValue() == Boolean.YES);
        booleanLiteral.setBindAttempted(true);
        return false;
    }

    @Override
    public boolean visit(BytesLiteral bytesLiteral) {
        this.value = bytesLiteral.getValue();
        bytesLiteral.setBindAttempted(true);
        return false;
    }

    @Override
    public boolean visit(SQLLiteral sQLLiteral) {
        this.value = sQLLiteral.getValue();
        sQLLiteral.setBindAttempted(true);
        return false;
    }

    @Override
    public boolean visit(TypeLiteralExpression typeLiteralExpression) {
        super.visit(typeLiteralExpression);
        this.value = typeLiteralExpression.getType().resolveType();
        typeLiteralExpression.setBindAttempted(true);
        return false;
    }

    @Override
    public boolean visit(SetValuesExpression setValuesExpression) {
        Expression expr = setValuesExpression.getExpression();
        if (expr instanceof AnnotationExpression) {
            AnnotationExpression annotationExpression = (AnnotationExpression)expr;
            Annotation ann = this.getAnnotation(annotationExpression, this.problemRequestor);
            if (ann != null) {
                AnnotationLeftHandScope scope = new AnnotationLeftHandScope(this.currentScope, (Element)ann, (Type)((AnnotationType)ann.getEClass()), (Element)ann);
                SettingsBlockAnnotationBindingsCompletor completor = new SettingsBlockAnnotationBindingsCompletor(this.currentScope, this.currentBinding, scope, this.dependencyRequestor, this.problemRequestor, this.compilerOptions);
                setValuesExpression.getSettingsBlock().accept(completor);
                this.value = ann;
            }
        } else {
            this.problemRequestor.acceptProblem(setValuesExpression, 5188);
            setValuesExpression.getExpression().setBindAttempted(true);
            AnnotationValueGatherer.setBindAttemptedForNames(setValuesExpression.getSettingsBlock());
        }
        return false;
    }

    @Override
    public boolean visit(ArrayLiteral arrayLiteral) {
        EList entries = new EList();
        for (Expression expr : arrayLiteral.getExpressions()) {
            AnnotationValueGatherer gatherer = this.getGatherer(expr);
            if (gatherer.getValue() == null) continue;
            entries.add(gatherer.getValue());
        }
        this.value = entries;
        arrayLiteral.setBindAttempted(true);
        return false;
    }

    AnnotationValueGatherer getGatherer(Expression expr) {
        return new AnnotationValueGatherer(expr, this.currentScope, this.currentBinding, this.dependencyRequestor, this.problemRequestor, this.compilerOptions);
    }

    @Override
    public boolean visit(UnaryExpression unaryExpression) {
        if (unaryExpression.getOperator() == UnaryExpression.Operator.MINUS) {
            this.isNegative = !this.isNegative;
        }
        return true;
    }

    @Override
    public boolean visit(FunctionInvocation functionInvocation) {
        super.visit(functionInvocation);
        this.value = functionInvocation.getTarget().resolveMember();
        return false;
    }

    private static class BinaryExpressionVisitor
    extends AbstractASTExpressionVisitor {
        private StringBuffer concatenatedString = new StringBuffer();
        private IProblemRequestor problemRequestor;
        private boolean exprValid = true;

        public BinaryExpressionVisitor(IProblemRequestor problemRequestor) {
            this.problemRequestor = problemRequestor;
        }

        public String getConcatenatedString() {
            return this.concatenatedString.toString();
        }

        @Override
        public boolean visit(BinaryExpression binaryExpression) {
            if (binaryExpression.getOperator() == BinaryExpression.Operator.PLUS || binaryExpression.getOperator() == BinaryExpression.Operator.CONCAT) {
                BinaryExpressionVisitor operand1Visitor = new BinaryExpressionVisitor(this.problemRequestor);
                binaryExpression.getFirstExpression().accept(operand1Visitor);
                this.concatenatedString.append(operand1Visitor.getConcatenatedString());
                BinaryExpressionVisitor operand2Visitor = new BinaryExpressionVisitor(this.problemRequestor);
                binaryExpression.getSecondExpression().accept(operand2Visitor);
                this.concatenatedString.append(operand2Visitor.getConcatenatedString());
                if (!operand1Visitor.exprValid || !operand2Visitor.exprValid) {
                    this.problemRequestor.acceptProblem(binaryExpression, 5188);
                }
            } else {
                this.exprValid = false;
            }
            binaryExpression.setBindAttempted(true);
            return false;
        }

        @Override
        public boolean visit(StringLiteral stringLiteral) {
            if (stringLiteral.isHex()) {
                this.concatenatedString.append(this.convertUnicodeHexToString(stringLiteral.getValue()));
            } else {
                this.concatenatedString.append(stringLiteral.getValue());
            }
            stringLiteral.setBindAttempted(true);
            return false;
        }

        private String convertUnicodeHexToString(String str) {
            try {
                int charLen = str.length() / 4;
                if (charLen * 4 != str.length()) {
                    ++charLen;
                }
                char[] chars = new char[charLen];
                int i = 0;
                while (i < str.length()) {
                    char myUnicodeCharacter;
                    String nextCharString = i + 4 < str.length() ? str.substring(i, i + 4) : str.substring(i);
                    chars[i / 4] = myUnicodeCharacter = (char)Integer.parseInt(nextCharString, 16);
                    i += 4;
                }
                return new String(chars);
            }
            catch (NumberFormatException numberFormatException) {
                return str;
            }
        }

        @Override
        public boolean visitExpression(Expression expression) {
            this.exprValid = false;
            expression.setBindAttempted(true);
            return false;
        }
    }
}

