/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.edt.compiler.binding;

import java.util.HashSet;
import java.util.Set;
import org.eclipse.edt.compiler.binding.IRPartBinding;
import org.eclipse.edt.compiler.binding.SettingsBlockAnnotationBindingsCompletor;
import org.eclipse.edt.compiler.core.ast.Delegate;
import org.eclipse.edt.compiler.core.ast.FunctionParameter;
import org.eclipse.edt.compiler.core.ast.Node;
import org.eclipse.edt.compiler.core.ast.SettingsBlock;
import org.eclipse.edt.compiler.internal.core.builder.IProblemRequestor;
import org.eclipse.edt.compiler.internal.core.dependency.IDependencyRequestor;
import org.eclipse.edt.compiler.internal.core.lookup.AbstractBinder;
import org.eclipse.edt.compiler.internal.core.lookup.AnnotationLeftHandScope;
import org.eclipse.edt.compiler.internal.core.lookup.DelegateScope;
import org.eclipse.edt.compiler.internal.core.lookup.ICompilerOptions;
import org.eclipse.edt.compiler.internal.core.lookup.NullScope;
import org.eclipse.edt.compiler.internal.core.lookup.ResolutionException;
import org.eclipse.edt.compiler.internal.core.lookup.Scope;
import org.eclipse.edt.compiler.internal.util.BindingUtil;
import org.eclipse.edt.mof.egl.Container;
import org.eclipse.edt.mof.egl.Element;
import org.eclipse.edt.mof.egl.FunctionParameter;
import org.eclipse.edt.mof.egl.IrFactory;
import org.eclipse.edt.mof.egl.Member;
import org.eclipse.edt.mof.egl.ParameterKind;
import org.eclipse.edt.mof.egl.Part;
import org.eclipse.edt.mof.egl.Type;
import org.eclipse.edt.mof.egl.utils.TypeUtils;

public class DelegateBindingCompletor
extends AbstractBinder {
    private org.eclipse.edt.mof.egl.Delegate delegateBinding;
    private IProblemRequestor problemRequestor;
    private Set<String> definedParameters = new HashSet<String>();

    public DelegateBindingCompletor(Scope currentScope, IRPartBinding irBinding, IDependencyRequestor dependencyRequestor, IProblemRequestor problemRequestor, ICompilerOptions compilerOptions) {
        super(currentScope, irBinding.getIrPart(), dependencyRequestor, compilerOptions);
        this.delegateBinding = (org.eclipse.edt.mof.egl.Delegate)irBinding.getIrPart();
        this.problemRequestor = problemRequestor;
    }

    @Override
    public boolean visit(Delegate delegate) {
        delegate.getName().setType((Type)this.delegateBinding);
        if (delegate.hasReturnType()) {
            Type typeBinding = null;
            try {
                typeBinding = this.bindType(delegate.getReturnType());
                this.delegateBinding.setReturnType(typeBinding);
                this.delegateBinding.setIsNullable(Boolean.valueOf(delegate.getReturnDeclaration().isNullable()));
            }
            catch (ResolutionException e) {
                this.problemRequestor.acceptProblem(e.getStartOffset(), e.getEndOffset(), 2, e.getProblemKind(), e.getInserts());
            }
        }
        return true;
    }

    @Override
    public void endVisit(Delegate delegate) {
        BindingUtil.setValid((Part)this.delegateBinding, true);
    }

    @Override
    public boolean visit(org.eclipse.edt.compiler.core.ast.FunctionParameter functionParameter) {
        Type typeBinding;
        FunctionParameter parm = IrFactory.INSTANCE.createFunctionParameter();
        parm.setContainer((Container)this.delegateBinding);
        parm.setName(functionParameter.getName().getCaseSensitiveIdentifier());
        functionParameter.getName().setMember((Member)parm);
        try {
            typeBinding = this.bindType(functionParameter.getType());
        }
        catch (ResolutionException e) {
            this.problemRequestor.acceptProblem(e.getStartOffset(), e.getEndOffset(), 2, e.getProblemKind(), e.getInserts());
            return false;
        }
        parm.setType(typeBinding);
        parm.setIsNullable(functionParameter.isNullable());
        parm.setIsConst(Boolean.valueOf(functionParameter.isParmConst()));
        FunctionParameter.UseType useType = functionParameter.getUseType();
        if (useType == FunctionParameter.UseType.IN) {
            parm.setParameterKind(ParameterKind.PARM_IN);
        } else if (useType == FunctionParameter.UseType.OUT) {
            parm.setParameterKind(ParameterKind.PARM_OUT);
        } else if (useType == null && typeBinding != null && TypeUtils.isReferenceType((Type)typeBinding)) {
            parm.setParameterKind(ParameterKind.PARM_IN);
        } else {
            parm.setParameterKind(ParameterKind.PARM_INOUT);
        }
        if (this.definedParameters.contains(parm.getName())) {
            this.problemRequestor.acceptProblem((Node)functionParameter, 3012, new String[]{parm.getName(), this.delegateBinding.getCaseSensitiveName()});
        } else {
            this.delegateBinding.getParameters().add(parm);
            this.definedParameters.add(parm.getName());
        }
        return false;
    }

    @Override
    public boolean visit(SettingsBlock settingsBlock) {
        DelegateScope delScope = new DelegateScope(NullScope.INSTANCE, this.delegateBinding);
        AnnotationLeftHandScope scope = new AnnotationLeftHandScope(delScope, (Element)this.delegateBinding, (Type)this.delegateBinding, (Element)this.delegateBinding);
        SettingsBlockAnnotationBindingsCompletor blockCompletor = new SettingsBlockAnnotationBindingsCompletor(this.currentScope, (Part)this.delegateBinding, scope, this.dependencyRequestor, this.problemRequestor, this.compilerOptions);
        settingsBlock.accept(blockCompletor);
        return false;
    }
}

