/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.edt.compiler.binding;

import org.eclipse.edt.compiler.binding.IRPartBinding;
import org.eclipse.edt.compiler.binding.PartSubTypeAndAnnotationCollector;
import org.eclipse.edt.compiler.binding.RecordBindingFieldsCompletor;
import org.eclipse.edt.compiler.binding.SettingsBlockAnnotationBindingsCompletor;
import org.eclipse.edt.compiler.core.ast.SettingsBlock;
import org.eclipse.edt.compiler.core.ast.StructureItem;
import org.eclipse.edt.compiler.internal.core.builder.IProblemRequestor;
import org.eclipse.edt.compiler.internal.core.dependency.IDependencyRequestor;
import org.eclipse.edt.compiler.internal.core.lookup.AnnotationLeftHandScope;
import org.eclipse.edt.compiler.internal.core.lookup.DefaultBinder;
import org.eclipse.edt.compiler.internal.core.lookup.ICompilerOptions;
import org.eclipse.edt.compiler.internal.core.lookup.NullScope;
import org.eclipse.edt.compiler.internal.core.lookup.RecordScope;
import org.eclipse.edt.compiler.internal.core.lookup.Scope;
import org.eclipse.edt.compiler.internal.util.BindingUtil;
import org.eclipse.edt.mof.egl.AccessKind;
import org.eclipse.edt.mof.egl.Element;
import org.eclipse.edt.mof.egl.Part;
import org.eclipse.edt.mof.egl.Record;
import org.eclipse.edt.mof.egl.Stereotype;
import org.eclipse.edt.mof.egl.StereotypeType;
import org.eclipse.edt.mof.egl.StructPart;
import org.eclipse.edt.mof.egl.Type;
import org.eclipse.edt.mof.utils.NameUtile;

public class RecordBindingCompletor
extends DefaultBinder {
    private Record recordBinding;
    private IRPartBinding irBinding;
    private Stereotype partStereotype;
    private RecordBindingFieldsCompletor flexibleRecordBindingFieldsCompletor;

    public RecordBindingCompletor(Scope currentScope, IRPartBinding irBinding, IDependencyRequestor dependencyRequestor, IProblemRequestor problemRequestor, ICompilerOptions compilerOptions) {
        super(currentScope, (Part)((Record)irBinding.getIrPart()), dependencyRequestor, problemRequestor, compilerOptions);
        this.recordBinding = (Record)irBinding.getIrPart();
        this.irBinding = irBinding;
    }

    @Override
    public boolean visit(org.eclipse.edt.compiler.core.ast.Record record) {
        PartSubTypeAndAnnotationCollector collector = new PartSubTypeAndAnnotationCollector((Part)this.recordBinding, this, this.problemRequestor);
        record.accept(collector);
        this.processSubType(collector);
        this.flexibleRecordBindingFieldsCompletor = new RecordBindingFieldsCompletor(this.currentScope, this.recordBinding, record.getName().getCanonicalName(), this.dependencyRequestor, this.problemRequestor, this.compilerOptions);
        record.accept(this.flexibleRecordBindingFieldsCompletor);
        this.processSettingsBlocksFromCollector(collector);
        if (record.isPrivate()) {
            this.recordBinding.setAccessKind(AccessKind.ACC_PRIVATE);
        }
        record.getName().setType((Type)this.recordBinding);
        return false;
    }

    @Override
    public void endVisit(org.eclipse.edt.compiler.core.ast.Record record) {
        this.irBinding.setValid(true);
        super.endVisit(record);
    }

    private void setDefaultSuperType(Stereotype subType) {
        StructPart anyRec = (StructPart)BindingUtil.findPart(NameUtile.getAsName((String)"eglx.lang"), NameUtile.getAsName((String)"AnyRecord"));
        BindingUtil.setDefaultSupertype((StructPart)this.recordBinding, subType, anyRec);
    }

    protected void processSubType(PartSubTypeAndAnnotationCollector collector) {
        this.partStereotype = collector.getStereotype();
        this.setDefaultSuperType(this.partStereotype);
    }

    private void processSettingsBlocksFromCollector(PartSubTypeAndAnnotationCollector collector) {
        if (collector.getSettingsBlocks().size() > 0) {
            AnnotationLeftHandScope scope = new AnnotationLeftHandScope(new RecordScope(NullScope.INSTANCE, this.recordBinding), (Element)this.recordBinding, (Type)this.recordBinding, (Element)this.recordBinding);
            if (!collector.isFoundSubTypeInSettingsBlock() && this.partStereotype != null) {
                scope = new AnnotationLeftHandScope(scope, (Element)this.partStereotype, (Type)((StereotypeType)this.partStereotype.getEClass()), (Element)this.partStereotype);
            }
            SettingsBlockAnnotationBindingsCompletor blockCompletor = new SettingsBlockAnnotationBindingsCompletor(this.currentScope, (Part)this.recordBinding, scope, this.dependencyRequestor, this.problemRequestor, this.compilerOptions);
            for (SettingsBlock block : collector.getSettingsBlocks()) {
                block.accept(blockCompletor);
            }
        }
    }

    @Override
    public boolean visit(StructureItem structureItem) {
        return false;
    }

    @Override
    public boolean visit(SettingsBlock settingsBlock) {
        return false;
    }
}

