/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.edt.compiler.binding;

import org.eclipse.edt.compiler.binding.FunctionContainerBindingCompletor;
import org.eclipse.edt.compiler.binding.IRPartBinding;
import org.eclipse.edt.compiler.core.ast.Name;
import org.eclipse.edt.compiler.internal.core.builder.IProblemRequestor;
import org.eclipse.edt.compiler.internal.core.dependency.IDependencyRequestor;
import org.eclipse.edt.compiler.internal.core.lookup.ICompilerOptions;
import org.eclipse.edt.compiler.internal.core.lookup.ResolutionException;
import org.eclipse.edt.compiler.internal.core.lookup.Scope;
import org.eclipse.edt.mof.egl.AccessKind;
import org.eclipse.edt.mof.egl.Service;
import org.eclipse.edt.mof.egl.StereotypeType;
import org.eclipse.edt.mof.egl.StructPart;
import org.eclipse.edt.mof.egl.Type;

public class ServiceBindingCompletor
extends FunctionContainerBindingCompletor {
    private Service serviceBinding;

    public ServiceBindingCompletor(Scope currentScope, IRPartBinding irBinding, IDependencyRequestor dependencyRequestor, IProblemRequestor problemRequestor, ICompilerOptions compilerOptions) {
        super(irBinding, currentScope, dependencyRequestor, problemRequestor, compilerOptions);
        this.serviceBinding = (Service)irBinding.getIrPart();
    }

    @Override
    public boolean visit(org.eclipse.edt.compiler.core.ast.Service service) {
        service.getName().setType((Type)this.serviceBinding);
        service.accept(this.getPartSubTypeAndAnnotationCollector());
        if (service.isPrivate()) {
            this.serviceBinding.setAccessKind(AccessKind.ACC_PRIVATE);
        }
        for (Name nextName : service.getImplementedInterfaces()) {
            try {
                Type typeBinding = this.bindTypeName(nextName);
                if (!(typeBinding instanceof StructPart)) continue;
                this.serviceBinding.getSuperTypes().add((StructPart)typeBinding);
            }
            catch (ResolutionException e) {
                this.problemRequestor.acceptProblem(e.getStartOffset(), e.getEndOffset(), 2, e.getProblemKind(), e.getInserts());
            }
        }
        this.setDefaultSuperType();
        return true;
    }

    @Override
    public void endVisit(org.eclipse.edt.compiler.core.ast.Service service) {
        this.processSettingsBlocks();
        this.endVisitFunctionContainer(service);
    }

    @Override
    protected StereotypeType getDefaultStereotypeType() {
        return null;
    }
}

