/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.edt.compiler.binding;

import org.eclipse.edt.compiler.binding.AnnotationValueGatherer;
import org.eclipse.edt.compiler.binding.AnnotationValueValidator;
import org.eclipse.edt.compiler.core.ast.AbstractASTExpressionVisitor;
import org.eclipse.edt.compiler.core.ast.AnnotationExpression;
import org.eclipse.edt.compiler.core.ast.Assignment;
import org.eclipse.edt.compiler.core.ast.Expression;
import org.eclipse.edt.compiler.core.ast.Node;
import org.eclipse.edt.compiler.core.ast.SetValuesExpression;
import org.eclipse.edt.compiler.core.ast.SettingsBlock;
import org.eclipse.edt.compiler.core.ast.SimpleName;
import org.eclipse.edt.compiler.core.ast.SuperExpression;
import org.eclipse.edt.compiler.core.ast.ThisExpression;
import org.eclipse.edt.compiler.internal.core.builder.IProblemRequestor;
import org.eclipse.edt.compiler.internal.core.dependency.IDependencyRequestor;
import org.eclipse.edt.compiler.internal.core.lookup.AnnotationLeftHandScope;
import org.eclipse.edt.compiler.internal.core.lookup.AnnotationRightHandScope;
import org.eclipse.edt.compiler.internal.core.lookup.DefaultBinder;
import org.eclipse.edt.compiler.internal.core.lookup.ICompilerOptions;
import org.eclipse.edt.compiler.internal.core.lookup.Scope;
import org.eclipse.edt.compiler.internal.util.BindingUtil;
import org.eclipse.edt.mof.EField;
import org.eclipse.edt.mof.egl.Annotation;
import org.eclipse.edt.mof.egl.AnnotationType;
import org.eclipse.edt.mof.egl.Classifier;
import org.eclipse.edt.mof.egl.Element;
import org.eclipse.edt.mof.egl.Part;
import org.eclipse.edt.mof.egl.SubType;
import org.eclipse.edt.mof.egl.Type;

public class SettingsBlockAnnotationBindingsCompletor
extends DefaultBinder {
    private AnnotationLeftHandScope annotationLeftHandScope;
    private Binder lhsBinder;
    private Binder rhsBinder;
    private Part partBinding;

    public SettingsBlockAnnotationBindingsCompletor(Scope currentScope, Part partBinding, AnnotationLeftHandScope annotationLeftHandScope, IDependencyRequestor dependencyRequestor, IProblemRequestor problemRequestor, ICompilerOptions compilerOptions) {
        super(currentScope, partBinding, dependencyRequestor, problemRequestor, compilerOptions);
        this.partBinding = partBinding;
        this.annotationLeftHandScope = annotationLeftHandScope;
        this.rhsBinder = new Binder(currentScope, partBinding, dependencyRequestor, problemRequestor, compilerOptions);
        this.lhsBinder = new LHSBinder(annotationLeftHandScope.getTopLevelAnnotationLeftHandScope().getScopeToUseWhenResolving(), partBinding, dependencyRequestor, problemRequestor, compilerOptions);
    }

    @Override
    public boolean visit(SettingsBlock settingsBlock) {
        settingsBlock.accept(new AbstractASTExpressionVisitor(){

            private EField getEField(AnnotationType annType, String name) {
                for (EField f : annType.getEFields()) {
                    if (!f.getName().equalsIgnoreCase(name)) continue;
                    return f;
                }
                return null;
            }

            @Override
            public boolean visit(Assignment assignment) {
                String fieldName;
                Annotation ann;
                AnnotationType annType;
                EField field;
                if (SettingsBlockAnnotationBindingsCompletor.this.annotationLeftHandScope.getElementBeingAnnotated() instanceof Annotation && assignment.getLeftHandSide() instanceof SimpleName && (field = this.getEField(annType = (AnnotationType)(ann = (Annotation)SettingsBlockAnnotationBindingsCompletor.this.annotationLeftHandScope.getElementBeingAnnotated()).getEClass(), fieldName = ((SimpleName)assignment.getLeftHandSide()).getIdentifier())) != null) {
                    Object obj = SettingsBlockAnnotationBindingsCompletor.this.getValue(assignment.getRightHandSide(), ann, field);
                    SettingsBlockAnnotationBindingsCompletor.this.setValueIntoAnnotation(obj, assignment.getRightHandSide(), ann, field);
                    assignment.getLeftHandSide().setElement(ann);
                    assignment.getLeftHandSide().setType((Type)annType);
                    assignment.setBinding(ann);
                    return false;
                }
                assignment.getLeftHandSide().accept(SettingsBlockAnnotationBindingsCompletor.this.lhsBinder);
                assignment.getRightHandSide().accept(SettingsBlockAnnotationBindingsCompletor.this.rhsBinder);
                return false;
            }

            @Override
            public boolean visit(AnnotationExpression annotationExpression) {
                Annotation ann = SettingsBlockAnnotationBindingsCompletor.this.getAnnotation(annotationExpression, SettingsBlockAnnotationBindingsCompletor.this.problemRequestor);
                SettingsBlockAnnotationBindingsCompletor.this.setAnnotationOnElement(SettingsBlockAnnotationBindingsCompletor.this.annotationLeftHandScope.getTopLevelAnnotationLeftHandScope().getElementBeingAnnotated(), ann, annotationExpression);
                return false;
            }

            @Override
            public boolean visit(SetValuesExpression setValuesExpression) {
                if (setValuesExpression.getExpression() instanceof AnnotationExpression) {
                    setValuesExpression.getExpression().accept(this);
                    Annotation ann = ((AnnotationExpression)setValuesExpression.getExpression()).resolveAnnotation();
                    if (ann == null) {
                        SettingsBlockAnnotationBindingsCompletor.setBindAttemptedForNames(setValuesExpression.getSettingsBlock());
                    } else {
                        AnnotationLeftHandScope newScope = new AnnotationLeftHandScope(SettingsBlockAnnotationBindingsCompletor.this.annotationLeftHandScope, (Element)ann, null, (Element)ann);
                        SettingsBlockAnnotationBindingsCompletor completor = new SettingsBlockAnnotationBindingsCompletor(SettingsBlockAnnotationBindingsCompletor.this.currentScope, SettingsBlockAnnotationBindingsCompletor.this.partBinding, newScope, SettingsBlockAnnotationBindingsCompletor.this.dependencyRequestor, SettingsBlockAnnotationBindingsCompletor.this.problemRequestor, SettingsBlockAnnotationBindingsCompletor.this.compilerOptions);
                        setValuesExpression.getSettingsBlock().accept(completor);
                    }
                } else {
                    setValuesExpression.getExpression().accept(SettingsBlockAnnotationBindingsCompletor.this.lhsBinder);
                    setValuesExpression.accept(SettingsBlockAnnotationBindingsCompletor.this.rhsBinder);
                }
                return false;
            }

            @Override
            public boolean visitExpression(Expression expression) {
                if (SettingsBlockAnnotationBindingsCompletor.this.annotationLeftHandScope.getElementBeingAnnotated() instanceof Annotation) {
                    Annotation ann = (Annotation)SettingsBlockAnnotationBindingsCompletor.this.annotationLeftHandScope.getElementBeingAnnotated();
                    AnnotationType annType = (AnnotationType)ann.getEClass();
                    if (annType.getEFields().size() == 1) {
                        Object obj = SettingsBlockAnnotationBindingsCompletor.this.getValue(expression, ann, (EField)annType.getEFields().get(0));
                        SettingsBlockAnnotationBindingsCompletor.this.setValueIntoAnnotation(obj, expression, ann, (EField)annType.getEFields().get(0));
                    } else {
                        SettingsBlockAnnotationBindingsCompletor.this.problemRequestor.acceptProblem((Node)expression, 7510, new String[]{annType.getCaseSensitiveName()});
                    }
                }
                return false;
            }
        });
        return false;
    }

    private Object getValue(Expression expr, Annotation ann, EField field) {
        AnnotationRightHandScope rhScope = new AnnotationRightHandScope(this.currentScope, field);
        return new AnnotationValueGatherer(expr, rhScope, this.partBinding, this.dependencyRequestor, this.problemRequestor, this.compilerOptions).getValue();
    }

    private void setValueIntoAnnotation(Object value, Expression expr, Annotation ann, EField field) {
        AnnotationValueValidator validator = new AnnotationValueValidator(this.problemRequestor);
        Object result = validator.validateValue(value, expr, field, field.getEType(), field.isNullable());
        if (result != null) {
            ann.eSet(field, result);
        }
    }

    private void setAnnotationOnElement(Element elem, Annotation ann, AnnotationExpression annotationExpression) {
        if (ann == null || elem == null) {
            return;
        }
        if (this.isApplicableFor(elem, ann)) {
            elem.addAnnotation(ann);
        } else {
            this.problemRequestor.acceptProblem((Node)annotationExpression, 2058, new String[]{annotationExpression.getName().getCanonicalString()});
        }
    }

    private boolean isApplicableFor(Element elem, Annotation ann) {
        AnnotationType annType = (AnnotationType)ann.getEClass();
        return BindingUtil.isApplicableFor(elem, annType.getTargets());
    }

    private static class Binder
    extends DefaultBinder {
        public Binder(Scope currentScope, Part currentBinding, IDependencyRequestor dependencyRequestor, IProblemRequestor problemRequestor, ICompilerOptions compilerOptions) {
            super(currentScope, currentBinding, dependencyRequestor, problemRequestor, compilerOptions);
        }
    }

    private static class LHSBinder
    extends Binder {
        public LHSBinder(Scope currentScope, Part currentBinding, IDependencyRequestor dependencyRequestor, IProblemRequestor problemRequestor, ICompilerOptions compilerOptions) {
            super(currentScope, currentBinding, dependencyRequestor, problemRequestor, compilerOptions);
        }

        @Override
        public boolean visit(ThisExpression thisExpression) {
            if (this.currentScope.getType() != null) {
                thisExpression.setType(this.currentScope.getType());
                return false;
            }
            return super.visit(thisExpression);
        }

        @Override
        public boolean visit(SuperExpression superExpression) {
            SubType sub;
            Classifier classifier;
            if (this.currentScope.getType() != null && (classifier = this.currentScope.getType().getClassifier()) instanceof SubType && (sub = (SubType)classifier).getSuperTypes().size() > 0) {
                superExpression.setType((Type)sub.getSuperTypes().get(0));
                return false;
            }
            return super.visit(superExpression);
        }
    }
}

