/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.edt.compiler.core.ast;

import org.eclipse.edt.compiler.core.ast.IASTVisitor;
import org.eclipse.edt.compiler.core.ast.LiteralExpression;

public class BytesLiteral
extends LiteralExpression {
    private String rawString;
    private String bytes;

    public BytesLiteral(String rawString, String bytes, int startOffset, int endOffset) {
        super(startOffset, endOffset);
        this.rawString = rawString;
        this.bytes = bytes;
    }

    @Override
    public String getValue() {
        return this.bytes;
    }

    @Override
    public void accept(IASTVisitor visitor) {
        visitor.visit(this);
        visitor.endVisit(this);
    }

    @Override
    public int getLiteralKind() {
        return 12;
    }

    @Override
    public String getCanonicalString() {
        return this.rawString;
    }

    @Override
    protected Object clone() throws CloneNotSupportedException {
        return new BytesLiteral(this.rawString, this.bytes, this.getOffset(), this.getOffset() + this.getLength());
    }
}

