/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.edt.compiler.core.ast;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.eclipse.edt.compiler.core.ast.CallSynchronizationValues;
import org.eclipse.edt.compiler.core.ast.Expression;
import org.eclipse.edt.compiler.core.ast.FunctionInvocation;
import org.eclipse.edt.compiler.core.ast.IASTVisitor;
import org.eclipse.edt.compiler.core.ast.Name;
import org.eclipse.edt.compiler.core.ast.Node;
import org.eclipse.edt.compiler.core.ast.SettingsBlock;
import org.eclipse.edt.compiler.core.ast.Statement;

public class CallStatement
extends Statement {
    private Expression expr;
    private List exprs;
    private SettingsBlock settingsBlockOpt;
    private Expression usingOpt;
    private CallSynchronizationValues callSyncOpt;

    public CallStatement(Expression expr, List exprs, Expression usingOpt, CallSynchronizationValues callSyncOpt, SettingsBlock settingsBlockOpt, int startOffset, int endOffset) {
        super(startOffset, endOffset);
        if (exprs == null && expr instanceof FunctionInvocation) {
            FunctionInvocation fInvocation = (FunctionInvocation)expr;
            expr = fInvocation.getTarget();
            exprs = fInvocation.getArguments();
        }
        this.expr = expr;
        expr.setParent(this);
        if (exprs != null) {
            this.exprs = this.setParent(exprs);
        }
        if (settingsBlockOpt != null) {
            this.settingsBlockOpt = settingsBlockOpt;
            settingsBlockOpt.setParent(this);
        }
        if (usingOpt != null) {
            this.usingOpt = usingOpt;
            this.usingOpt.setParent(this);
        }
        if (callSyncOpt != null) {
            this.callSyncOpt = callSyncOpt;
            this.callSyncOpt.setParent(this);
        }
    }

    public Expression getInvocationTarget() {
        return this.expr;
    }

    public Name getName() {
        throw new RuntimeException();
    }

    public boolean hasArguments() {
        return this.exprs != null && !this.exprs.isEmpty();
    }

    public List<Node> getArguments() {
        return this.exprs;
    }

    public List getCallOptions() {
        return Collections.EMPTY_LIST;
    }

    public boolean hasSettingsBlock() {
        return this.settingsBlockOpt != null;
    }

    public SettingsBlock getSettingsBlock() {
        return this.settingsBlockOpt;
    }

    public CallSynchronizationValues getCallSynchronizationValues() {
        return this.callSyncOpt;
    }

    public Expression getUsing() {
        return this.usingOpt;
    }

    @Override
    public void accept(IASTVisitor visitor) {
        boolean visitChildren = visitor.visit(this);
        if (visitChildren) {
            this.expr.accept(visitor);
            if (this.exprs != null) {
                CallStatement.acceptChildren(visitor, this.exprs);
            }
            if (this.usingOpt != null) {
                this.usingOpt.accept(visitor);
            }
            if (this.callSyncOpt != null) {
                this.callSyncOpt.accept(visitor);
            }
            if (this.settingsBlockOpt != null) {
                this.settingsBlockOpt.accept(visitor);
            }
        }
        visitor.endVisit(this);
    }

    @Override
    protected Object clone() throws CloneNotSupportedException {
        ArrayList newArguments = this.exprs != null ? this.cloneList(this.exprs) : null;
        SettingsBlock newSettingsBlockOpt = this.settingsBlockOpt != null ? (SettingsBlock)this.settingsBlockOpt.clone() : null;
        Expression newUsingOpt = this.usingOpt != null ? (Expression)this.usingOpt.clone() : null;
        CallSynchronizationValues newCallSyncOpt = this.callSyncOpt != null ? (CallSynchronizationValues)this.callSyncOpt.clone() : null;
        return new CallStatement((Expression)this.expr.clone(), newArguments, newUsingOpt, newCallSyncOpt, newSettingsBlockOpt, this.getOffset(), this.getOffset() + this.getLength());
    }
}

