/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.edt.compiler.core.ast;

import java.util.Map;
import org.eclipse.edt.compiler.core.ast.Node;
import org.eclipse.edt.mof.egl.Member;
import org.eclipse.edt.mof.egl.Type;

public abstract class Expression
extends Node {
    private Type type;
    private boolean bindAttempted;
    protected Map attributes;

    public Expression(int startOffset, int endOffset) {
        super(startOffset, endOffset);
    }

    public Type resolveType() {
        return this.type;
    }

    public Object resolveElement() {
        return null;
    }

    public Member resolveMember() {
        if (this.resolveElement() instanceof Member) {
            return (Member)this.resolveElement();
        }
        return null;
    }

    public void setElement(Object elem) {
        this.setBindAttempted(true);
    }

    public void setMember(Member member) {
        this.setElement(member);
    }

    public void setType(Type type) {
        this.type = type;
        this.setBindAttempted(true);
    }

    public abstract String getCanonicalString();

    public String getCaseSensitiveID() {
        String can = this.getCanonicalString();
        if (can != null) {
            int index = can.lastIndexOf(".");
            if (index < 0) {
                return can;
            }
            return can.substring(index + 1);
        }
        return null;
    }

    public void setAttributeOnName(int attr, Object value) {
    }

    public Object getAttributeFromName(int attr) {
        return null;
    }

    public boolean isName() {
        return false;
    }

    @Override
    protected Object clone() throws CloneNotSupportedException {
        return new CloneNotSupportedException();
    }

    public boolean isBindAttempted() {
        return this.bindAttempted;
    }

    public void setBindAttempted(boolean bool) {
        this.bindAttempted = bool;
    }
}

