/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.edt.compiler.core.ast;

import java.util.Arrays;
import java.util.List;
import org.eclipse.edt.compiler.core.ast.Expression;
import org.eclipse.edt.compiler.core.ast.FromOrToExpressionClause;
import org.eclipse.edt.compiler.core.ast.IASTVisitor;
import org.eclipse.edt.compiler.core.ast.Node;
import org.eclipse.edt.compiler.core.ast.SimpleName;
import org.eclipse.edt.compiler.core.ast.Statement;
import org.eclipse.edt.compiler.core.ast.Type;

public class ForEachStatement
extends Statement {
    private List targets;
    private SimpleName declarationName;
    private Type declarationType;
    private boolean isNullable;
    private FromOrToExpressionClause resultSet;
    private List stmts;
    private int closingParenOffset;

    public ForEachStatement(List targets, SimpleName declarationName, Type declarationType, Boolean isNullable, FromOrToExpressionClause resultSet, List stmts, int closingParenOffset, int startOffset, int endOffset) {
        super(startOffset, endOffset);
        if (targets != null) {
            this.targets = this.setParent(targets);
        }
        if (declarationName != null) {
            this.declarationName = declarationName;
            declarationName.setParent(this);
        }
        if (declarationType != null) {
            this.declarationType = declarationType;
            declarationType.setParent(this);
        }
        this.resultSet = resultSet;
        resultSet.setParent(this);
        this.stmts = this.setParent(stmts);
        this.closingParenOffset = closingParenOffset;
        this.isNullable = isNullable;
    }

    public List<Node> getTargets() {
        return this.targets;
    }

    public boolean hasResultSet() {
        return true;
    }

    public int getClosingParenOffset() {
        return this.closingParenOffset;
    }

    public FromOrToExpressionClause getResultSet() {
        return this.resultSet;
    }

    public boolean hasSQLRecord() {
        return true;
    }

    public Expression getSQLRecord() {
        if (this.targets != null && this.targets.size() > 0) {
            return (Expression)this.targets.get(0);
        }
        return null;
    }

    public List<Node> getStmts() {
        return this.stmts;
    }

    public boolean hasVariableDeclaration() {
        return this.declarationName != null;
    }

    public SimpleName getVariableDeclarationName() {
        return this.declarationName;
    }

    public Type getVariableDeclarationType() {
        return this.declarationType;
    }

    @Override
    public void accept(IASTVisitor visitor) {
        boolean visitChildren = visitor.visit(this);
        if (visitChildren) {
            if (this.targets != null) {
                ForEachStatement.acceptChildren(visitor, this.targets);
            } else {
                this.declarationName.accept(visitor);
                this.declarationType.accept(visitor);
            }
            this.resultSet.accept(visitor);
            ForEachStatement.acceptChildren(visitor, this.stmts);
        }
        visitor.endVisit(this);
    }

    @Override
    public boolean canIncludeOtherStatements() {
        return true;
    }

    public List getStatementBlocks() {
        return Arrays.asList(this.stmts);
    }

    public String toString() {
        StringBuilder buf = new StringBuilder(50);
        buf.append("foreach(");
        if (this.targets != null) {
            boolean comma = false;
            for (Expression e : this.targets) {
                buf.append(e.getCanonicalString());
                if (comma) {
                    buf.append(", ");
                    continue;
                }
                comma = true;
            }
        } else {
            buf.append(this.declarationName.getCanonicalString());
            buf.append(' ');
            buf.append(this.declarationType.getCanonicalName());
        }
        buf.append(" from ");
        buf.append(this.resultSet.getExpression().getCanonicalString());
        buf.append(')');
        return buf.toString();
    }

    public boolean isNullable() {
        return this.isNullable;
    }

    @Override
    protected Object clone() throws CloneNotSupportedException {
        return new ForEachStatement(this.cloneList(this.targets), this.declarationName == null ? null : (SimpleName)this.declarationName.clone(), this.declarationType == null ? null : (Type)this.declarationType.clone(), this.isNullable, (FromOrToExpressionClause)this.resultSet.clone(), this.cloneList(this.stmts), this.closingParenOffset, this.getOffset(), this.getOffset() + this.getLength());
    }

    public static class ExpressionForEachTarget
    extends ForEachTarget {
        private Expression expression;

        public ExpressionForEachTarget(Expression expression) {
            this.expression = expression;
        }

        @Override
        boolean isExpressionForEachTarget() {
            return true;
        }

        @Override
        Expression getExpression() {
            return this.expression;
        }

        @Override
        void setParent(Node parent) {
            this.expression.setParent(parent);
        }

        @Override
        void accept(IASTVisitor visitor) {
            this.expression.accept(visitor);
        }

        @Override
        protected Object clone() throws CloneNotSupportedException {
            return new ExpressionForEachTarget((Expression)this.expression.clone());
        }
    }

    public static abstract class ForEachTarget
    implements Cloneable {
        boolean isExpressionForEachTarget() {
            return false;
        }

        Expression getExpression() {
            return null;
        }

        boolean isResultSetForEachTarget() {
            return false;
        }

        FromOrToExpressionClause getResultSet() {
            return null;
        }

        void setParent(Node parent) {
        }

        void accept(IASTVisitor visitor) {
        }

        protected abstract Object clone() throws CloneNotSupportedException;
    }

    public static class ResultSetForEachTarget
    extends ForEachTarget {
        private FromOrToExpressionClause resultSet;

        public ResultSetForEachTarget(FromOrToExpressionClause resultSet) {
            this.resultSet = resultSet;
        }

        @Override
        boolean isResultSetForEachTarget() {
            return true;
        }

        @Override
        FromOrToExpressionClause getResultSet() {
            return this.resultSet;
        }

        @Override
        void setParent(Node parent) {
            this.resultSet.setParent(parent);
        }

        @Override
        void accept(IASTVisitor visitor) {
            this.resultSet.accept(visitor);
        }

        @Override
        protected Object clone() throws CloneNotSupportedException {
            return new ResultSetForEachTarget((FromOrToExpressionClause)this.resultSet.clone());
        }
    }
}

