/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.edt.compiler.core.ast;

import java.util.List;
import org.eclipse.edt.compiler.core.ast.Expression;
import org.eclipse.edt.compiler.core.ast.IASTVisitor;
import org.eclipse.edt.compiler.core.ast.Node;
import org.eclipse.edt.compiler.core.ast.Statement;

public class ForwardStatement
extends Statement {
    private List args;
    private ForwardTarget forwardTargetOpt;
    private List forwardOptions;

    public ForwardStatement(List args, ForwardTarget forwardTargetOpt, List forwardOptions, int startOffset, int endOffset) {
        super(startOffset, endOffset);
        this.args = this.setParent(args);
        if (forwardTargetOpt != null) {
            this.forwardTargetOpt = forwardTargetOpt;
            forwardTargetOpt.setParent(this);
        }
        this.forwardOptions = this.setParent(forwardOptions);
    }

    public List<Node> getArguments() {
        return this.args;
    }

    public boolean isForwardToLabel() {
        return this.forwardTargetOpt != null && this.forwardTargetOpt.isToLabel();
    }

    public boolean isForwardToURL() {
        return this.forwardTargetOpt != null && this.forwardTargetOpt.isToURL();
    }

    public boolean hasForwardTarget() {
        return this.forwardTargetOpt != null;
    }

    public Expression getForwardTarget() {
        return this.forwardTargetOpt.getExpression();
    }

    public List<Node> getForwardOptions() {
        return this.forwardOptions;
    }

    @Override
    public void accept(IASTVisitor visitor) {
        boolean visitChildren = visitor.visit(this);
        if (visitChildren) {
            ForwardStatement.acceptChildren(visitor, this.args);
            if (this.forwardTargetOpt != null) {
                this.forwardTargetOpt.accept(visitor);
            }
            ForwardStatement.acceptChildren(visitor, this.forwardOptions);
        }
        visitor.endVisit(this);
    }

    @Override
    protected Object clone() throws CloneNotSupportedException {
        ForwardTarget newForwardTargetOpt = this.forwardTargetOpt != null ? (ForwardTarget)this.forwardTargetOpt.clone() : null;
        return new ForwardStatement(this.cloneList(this.args), newForwardTargetOpt, this.cloneList(this.forwardOptions), this.getOffset(), this.getOffset() + this.getLength());
    }

    public static class DefaultForwardTarget
    extends ForwardTarget {
        public DefaultForwardTarget(Expression expr) {
            super(expr);
        }

        @Override
        protected Object clone() throws CloneNotSupportedException {
            return new ForwardTarget((Expression)this.expr.clone());
        }
    }

    public static class ForwardTarget
    implements Cloneable {
        Expression expr;

        ForwardTarget(Expression expr) {
            this.expr = expr;
        }

        boolean isToURL() {
            return false;
        }

        boolean isToLabel() {
            return false;
        }

        Expression getExpression() {
            return this.expr;
        }

        void setParent(Node parent) {
            this.expr.setParent(parent);
        }

        void accept(IASTVisitor visitor) {
            this.expr.accept(visitor);
        }

        protected Object clone() throws CloneNotSupportedException {
            return new ForwardTarget((Expression)this.expr.clone());
        }
    }

    public static class ToLabelForwardTarget
    extends ForwardTarget {
        public ToLabelForwardTarget(Expression expr) {
            super(expr);
        }

        @Override
        boolean isToLabel() {
            return true;
        }

        @Override
        protected Object clone() throws CloneNotSupportedException {
            return new ToLabelForwardTarget((Expression)this.expr.clone());
        }
    }

    public static class ToURLForwardTarget
    extends ForwardTarget {
        public ToURLForwardTarget(Expression expr) {
            super(expr);
        }

        @Override
        boolean isToURL() {
            return true;
        }

        @Override
        protected Object clone() throws CloneNotSupportedException {
            return new ToURLForwardTarget((Expression)this.expr.clone());
        }
    }
}

