/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.edt.compiler.core.ast;

import java.util.List;
import org.eclipse.edt.compiler.core.ast.Expression;
import org.eclipse.edt.compiler.core.ast.IASTVisitor;

public class FunctionInvocation
extends Expression {
    private Expression target;
    private List funcArgs;
    protected Object element;

    public FunctionInvocation(Expression target, List funcArgs, int startOffset, int endOffset) {
        super(startOffset, endOffset);
        this.target = target;
        target.setParent(this);
        this.funcArgs = this.setParent(funcArgs);
    }

    public Expression getTarget() {
        return this.target;
    }

    public List<Expression> getArguments() {
        return this.funcArgs;
    }

    @Override
    public void setElement(Object elem) {
        super.setElement(elem);
        this.element = elem;
    }

    @Override
    public Object resolveElement() {
        return this.element;
    }

    @Override
    public void accept(IASTVisitor visitor) {
        boolean visitChildren = visitor.visit(this);
        if (visitChildren) {
            this.target.accept(visitor);
            FunctionInvocation.acceptChildren(visitor, this.funcArgs);
        }
        visitor.endVisit(this);
    }

    @Override
    public String getCanonicalString() {
        StringBuilder sb = new StringBuilder();
        sb.append(this.target.getCanonicalString());
        sb.append("()");
        return sb.toString();
    }

    @Override
    protected Object clone() throws CloneNotSupportedException {
        return new FunctionInvocation((Expression)this.target.clone(), this.cloneList(this.funcArgs), this.getOffset(), this.getOffset() + this.getLength());
    }

    public String toString() {
        StringBuilder buf = new StringBuilder(100);
        buf.append(this.target.toString());
        buf.append('(');
        boolean first = true;
        for (Object arg : this.funcArgs) {
            if (first) {
                first = false;
            } else {
                buf.append(", ");
            }
            buf.append(arg.toString());
        }
        buf.append(')');
        return buf.toString();
    }
}

