/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.edt.compiler.core.ast;

import java.util.HashMap;
import java.util.List;
import org.eclipse.edt.compiler.core.ast.Expression;
import org.eclipse.edt.mof.utils.NameUtile;

public abstract class Name
extends Expression {
    protected String identifier;
    protected Object element;
    public static int IMPLICIT_QUALIFIER_DATA_BINDING = 0;
    public static int OVERLOADED_FUNCTION_SET = 1;

    public Name(String identifier, int startOffset, int endOffset) {
        super(startOffset, endOffset);
        this.identifier = identifier;
    }

    public String getIdentifier() {
        return NameUtile.getAsName((String)this.identifier);
    }

    public String getCaseSensitiveIdentifier() {
        return this.identifier;
    }

    @Override
    public void setElement(Object elem) {
        this.element = elem;
        super.setElement(elem);
    }

    @Override
    public Object resolveElement() {
        return this.element;
    }

    public boolean isSimpleName() {
        return false;
    }

    public boolean isQualifiedName() {
        return false;
    }

    public String toString() {
        return this.getCanonicalName();
    }

    @Override
    public String getCanonicalString() {
        return this.getCanonicalName();
    }

    public abstract String getCanonicalName();

    protected abstract StringBuffer getCanonicalNameBuffer();

    public abstract String getNameComponents();

    protected abstract List<String> getNameComponentsList();

    @Override
    public void setAttributeOnName(int attr, Object value) {
        this.setAttribute(attr, value);
    }

    public void setAttribute(int attr, Object value) {
        if (this.attributes == null) {
            this.attributes = new HashMap();
        }
        this.attributes.put(new Integer(attr), value);
    }

    @Override
    public Object getAttributeFromName(int attr) {
        return this.getAttribute(attr);
    }

    public Object getAttribute(int attr) {
        return this.attributes == null ? null : this.attributes.get(new Integer(attr));
    }

    @Override
    public boolean isName() {
        return true;
    }

    @Override
    protected abstract Object clone() throws CloneNotSupportedException;
}

