/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.edt.compiler.core.ast;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.eclipse.edt.compiler.core.ast.DefaultASTVisitor;
import org.eclipse.edt.compiler.core.ast.Expression;
import org.eclipse.edt.compiler.core.ast.ForExpressionClause;
import org.eclipse.edt.compiler.core.ast.IASTVisitor;
import org.eclipse.edt.compiler.core.ast.Statement;

public class OpenStatement
extends Statement {
    private Expression resultSet;
    private boolean isHold;
    private boolean isScroll;
    private List openTargets;
    private List ioObjects;

    public OpenStatement(Expression resultSet, Boolean[] openModifierOpt, List openTargets, int startOffset, int endOffset) {
        super(startOffset, endOffset);
        this.resultSet = resultSet;
        this.isHold = openModifierOpt[0];
        this.isScroll = openModifierOpt[1];
        this.resultSet.setParent(this);
        this.openTargets = this.setParent(openTargets);
    }

    public Expression getResultSet() {
        return this.resultSet;
    }

    public boolean hasHold() {
        return this.isHold;
    }

    public boolean hasScroll() {
        return this.isScroll;
    }

    public List getOpenTargets() {
        return this.openTargets;
    }

    @Override
    public void accept(IASTVisitor visitor) {
        boolean visitChildren = visitor.visit(this);
        if (visitChildren) {
            this.resultSet.accept(visitor);
            OpenStatement.acceptChildren(visitor, this.openTargets);
        }
        visitor.endVisit(this);
    }

    @Override
    public List getIOObjects() {
        if (this.ioObjects == null) {
            this.ioObjects = Collections.EMPTY_LIST;
            OpenStatement.acceptChildren(new DefaultASTVisitor(){

                @Override
                public boolean visit(ForExpressionClause forExpressionClause) {
                    if (OpenStatement.this.ioObjects == Collections.EMPTY_LIST) {
                        OpenStatement.this.ioObjects = new ArrayList();
                    }
                    OpenStatement.this.ioObjects.add(forExpressionClause.getExpression());
                    return false;
                }
            }, this.openTargets);
        }
        return this.ioObjects;
    }

    @Override
    protected Object clone() throws CloneNotSupportedException {
        return new OpenStatement((Expression)this.resultSet.clone(), new Boolean[]{new Boolean(this.isHold), new Boolean(this.isScroll)}, this.cloneList(this.openTargets), this.getOffset(), this.getOffset() + this.getLength());
    }
}

