/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.edt.compiler.core.ast;

import org.eclipse.edt.compiler.core.ast.Expression;
import org.eclipse.edt.compiler.core.ast.IASTVisitor;
import org.eclipse.edt.mof.egl.Member;
import org.eclipse.edt.mof.egl.Type;

public class SubstringAccess
extends Expression {
    private Expression primary;
    private Expression expr;
    private Expression expr2;

    public SubstringAccess(Expression primary, Expression expr, Expression expr2, int startOffset, int endOffset) {
        super(startOffset, endOffset);
        this.primary = primary;
        primary.setParent(this);
        this.expr = expr;
        expr.setParent(this);
        this.expr2 = expr2;
        expr2.setParent(this);
    }

    public Expression getPrimary() {
        return this.primary;
    }

    public Expression getExpr() {
        return this.expr;
    }

    public Expression getExpr2() {
        return this.expr2;
    }

    @Override
    public void accept(IASTVisitor visitor) {
        boolean visitChildren = visitor.visit(this);
        if (visitChildren) {
            this.primary.accept(visitor);
            this.expr.accept(visitor);
            this.expr2.accept(visitor);
        }
        visitor.endVisit(this);
    }

    @Override
    public String getCanonicalString() {
        StringBuffer sb = new StringBuffer();
        sb.append(this.primary.getCanonicalString());
        sb.append("[");
        sb.append(this.expr.getCanonicalString());
        sb.append(":");
        sb.append(this.expr2.getCanonicalString());
        sb.append("]");
        return sb.toString();
    }

    @Override
    protected Object clone() throws CloneNotSupportedException {
        return new SubstringAccess((Expression)this.primary.clone(), (Expression)this.expr.clone(), (Expression)this.expr2.clone(), this.getOffset(), this.getOffset() + this.getLength());
    }

    @Override
    public Member resolveMember() {
        return this.getPrimary().resolveMember();
    }

    @Override
    public Type resolveType() {
        return this.getPrimary().resolveType();
    }

    public String toString() {
        return this.getCanonicalString();
    }
}

