/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.edt.compiler.internal.core.builder;

import java.text.MessageFormat;
import java.util.Locale;
import java.util.ResourceBundle;
import org.eclipse.edt.compiler.core.ast.Node;
import org.eclipse.edt.compiler.internal.core.builder.IProblemRequestor;
import org.eclipse.edt.mof.egl.Annotation;
import org.eclipse.edt.mof.egl.Element;

public abstract class DefaultProblemRequestor
implements IProblemRequestor {
    public static final String EGL_VALIDATION_RESOURCE_BUNDLE_NAME = "org.eclipse.edt.compiler.internal.core.builder.EGLValidationResources";
    public static final ResourceBundle RESOURCE_BUNDLE = ResourceBundle.getBundle("org.eclipse.edt.compiler.internal.core.builder.EGLValidationResources", Locale.getDefault());
    boolean hasError;

    @Override
    public abstract void acceptProblem(int var1, int var2, int var3, int var4, String[] var5, ResourceBundle var6);

    @Override
    public void acceptProblem(int startOffset, int endOffset, int severity, int problemKind, String[] inserts) {
        this.acceptProblem(startOffset, endOffset, severity, problemKind, inserts, RESOURCE_BUNDLE);
    }

    @Override
    public void acceptProblem(Node astNode, int problemKind) {
        this.acceptProblem(astNode.getOffset(), astNode.getOffset() + astNode.getLength(), 2, problemKind, new String[0], RESOURCE_BUNDLE);
    }

    @Override
    public boolean shouldReportProblem(int problemKind) {
        return true;
    }

    @Override
    public void acceptProblem(Node astNode, int problemKind, int severity) {
        this.acceptProblem(astNode.getOffset(), astNode.getOffset() + astNode.getLength(), severity, problemKind, new String[0], RESOURCE_BUNDLE);
    }

    @Override
    public void acceptProblem(Node astNode, int problemKind, String[] inserts) {
        this.acceptProblem(astNode.getOffset(), astNode.getOffset() + astNode.getLength(), 2, problemKind, inserts, RESOURCE_BUNDLE);
    }

    @Override
    public void acceptProblem(Node astNode, int problemKind, int severity, String[] inserts) {
        this.acceptProblem(astNode.getOffset(), astNode.getOffset() + astNode.getLength(), severity, problemKind, inserts, RESOURCE_BUNDLE);
    }

    @Override
    public void acceptProblem(Node astNode, int problemKind, int severity, String[] inserts, ResourceBundle bundle) {
        this.acceptProblem(astNode.getOffset(), astNode.getOffset() + astNode.getLength(), severity, problemKind, inserts, bundle);
    }

    @Override
    public void acceptProblem(int startOffset, int endOffset, int problemKind, boolean isError, String[] inserts) {
        this.acceptProblem(startOffset, endOffset, problemKind, isError, inserts, RESOURCE_BUNDLE);
    }

    @Override
    public void acceptProblem(int startOffset, int endOffset, int problemKind, boolean isError, String[] inserts, ResourceBundle bundle) {
        if (isError) {
            this.acceptProblem(startOffset, endOffset, 2, problemKind, inserts, bundle);
        } else {
            this.acceptProblem(startOffset, endOffset, 1, problemKind, inserts, bundle);
        }
    }

    @Override
    public void acceptProblem(int startOffset, int endOffset, int problemKind, String[] inserts) {
        this.acceptProblem(startOffset, endOffset, problemKind, true, inserts);
    }

    @Override
    public void acceptProblem(int startOffset, int endOffset, int severity, int problemKind) {
        this.acceptProblem(startOffset, endOffset, severity, problemKind, new String[0], RESOURCE_BUNDLE);
    }

    @Override
    public void acceptProblem(Element element, int problemKind) {
        this.acceptProblem(element, problemKind, 2, null, RESOURCE_BUNDLE);
    }

    @Override
    public void acceptProblem(Element element, int problemKind, int severity) {
        this.acceptProblem(element, problemKind, severity, null, RESOURCE_BUNDLE);
    }

    @Override
    public void acceptProblem(Element element, int problemKind, int severity, String[] inserts) {
        this.acceptProblem(element, problemKind, severity, inserts, RESOURCE_BUNDLE);
    }

    @Override
    public void acceptProblem(Element element, int problemKind, int severity, String[] inserts, ResourceBundle bundle) {
        Object val;
        int startOffset = 0;
        int endOffset = 0;
        Annotation annot = element.getAnnotation("EGL_Location");
        if (annot != null && (val = annot.getValue("off")) instanceof Integer) {
            endOffset = startOffset = ((Integer)val).intValue();
            val = annot.getValue("len");
            if (val instanceof Integer) {
                endOffset += ((Integer)val).intValue();
            }
        }
        this.acceptProblem(startOffset, endOffset, severity, problemKind, inserts, bundle);
    }

    public static String getMessageFromBundle(int problemKind, String[] inserts) {
        return DefaultProblemRequestor.getMessageFromBundle(problemKind, inserts, RESOURCE_BUNDLE);
    }

    public static String getMessageFromBundle(int problemKind, String[] inserts, ResourceBundle bundle) {
        String message = bundle.getString(Integer.toString(problemKind));
        if (message == null || inserts == null || inserts.length == 0) {
            return message;
        }
        MessageFormat formatter = new MessageFormat(message);
        formatter.applyPattern(message);
        return formatter.format(DefaultProblemRequestor.insertsWithoutNulls(inserts));
    }

    private static Object[] insertsWithoutNulls(Object[] originalInserts) {
        int numberInserts = originalInserts.length;
        Object[] newInserts = new Object[numberInserts];
        int i = 0;
        while (i < numberInserts) {
            newInserts[i] = originalInserts[i] != null ? originalInserts[i] : "";
            ++i;
        }
        return newInserts;
    }

    public static String[] shiftInsertsIfNeccesary(int problemKind, String[] inserts) {
        return inserts;
    }

    @Override
    public boolean hasError() {
        return this.hasError;
    }

    public void setHasError(boolean err) {
        this.hasError = err;
    }
}

