/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.edt.compiler.internal.core.lookup;

import java.util.List;
import org.eclipse.edt.compiler.binding.IPackageBinding;
import org.eclipse.edt.compiler.internal.core.lookup.Scope;
import org.eclipse.edt.compiler.internal.util.BindingUtil;
import org.eclipse.edt.mof.EField;
import org.eclipse.edt.mof.EGenericType;
import org.eclipse.edt.mof.EType;
import org.eclipse.edt.mof.egl.Enumeration;
import org.eclipse.edt.mof.egl.Member;
import org.eclipse.edt.mof.egl.Type;

public class AnnotationRightHandScope
extends Scope {
    private EField field;

    public AnnotationRightHandScope(Scope parentScope, EField field) {
        super(parentScope);
        this.field = field;
    }

    @Override
    public List<Member> findMember(String simpleName) {
        List<Member> result;
        Enumeration enumeration = this.getEnumerationType();
        if (enumeration != null && (result = BindingUtil.findMembers((Type)enumeration, simpleName)) != null) {
            return result;
        }
        return this.parentScope.findMember(simpleName);
    }

    private Enumeration getEnumerationType() {
        if (this.field != null) {
            EType type = this.field.getEType();
            return this.getEnumerationType(type);
        }
        return null;
    }

    private Enumeration getEnumerationType(EType type) {
        if (type instanceof Enumeration) {
            return (Enumeration)type;
        }
        if (type instanceof EGenericType) {
            return this.getEnumerationType((EType)((EGenericType)type).getETypeArguments().get(0));
        }
        return null;
    }

    @Override
    public IPackageBinding findPackage(String simpleName) {
        return this.parentScope.findPackage(simpleName);
    }

    @Override
    public List<Type> findType(String simpleName) {
        return this.parentScope.findType(simpleName);
    }
}

