/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.edt.compiler.internal.core.lookup;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.edt.compiler.binding.FileBinding;
import org.eclipse.edt.compiler.binding.IPartBinding;
import org.eclipse.edt.compiler.core.ast.File;
import org.eclipse.edt.compiler.core.ast.ImportDeclaration;
import org.eclipse.edt.compiler.core.ast.QualifiedName;
import org.eclipse.edt.compiler.internal.core.dependency.NullDependencyRequestor;
import org.eclipse.edt.compiler.internal.core.lookup.FileScope;
import org.eclipse.edt.compiler.internal.core.lookup.Scope;
import org.eclipse.edt.compiler.internal.util.BindingUtil;
import org.eclipse.edt.mof.egl.Part;
import org.eclipse.edt.mof.egl.Type;
import org.eclipse.edt.mof.utils.NameUtile;

public class FileASTScope
extends FileScope {
    private List importedTypeNames = new ArrayList();

    public FileASTScope(Scope parentScope, FileBinding fileBinding, File fileAST) {
        super(parentScope, fileBinding, NullDependencyRequestor.getInstance());
        List importDeclarations = fileAST.getImportDeclarations();
        for (ImportDeclaration importDeclaration : importDeclarations) {
            if (importDeclaration.isOnDemand()) continue;
            this.importedTypeNames.add(importDeclaration);
        }
    }

    @Override
    public List<Type> findType(String simpleName) {
        Part part;
        if (this.importedTypeNames != null) {
            for (ImportDeclaration importDeclaration : this.importedTypeNames) {
                if (!NameUtile.equals((String)importDeclaration.getName().getIdentifier(), (String)simpleName)) continue;
                IPartBinding temp = null;
                temp = importDeclaration.getName().isQualifiedName() ? this.fileBinding.getEnvironment().getPartBinding(((QualifiedName)importDeclaration.getName()).getQualifier().getNameComponents(), importDeclaration.getName().getIdentifier()) : this.fileBinding.getEnvironment().getPartBinding(NameUtile.getAsName((String)""), importDeclaration.getName().getIdentifier());
                if (temp == null || (this.fileBinding.getDeclaringPackage() == null || !NameUtile.equals((String)this.fileBinding.getDeclaringPackage().getPackageName(), (String)temp.getPackageName())) && temp.isPrivate()) continue;
                ArrayList<Type> list = new ArrayList<Type>();
                list.add((Type)BindingUtil.getPart(temp));
                return list;
            }
        }
        if ((part = this.findTypeInDeclaringPackage(simpleName)) != null) {
            ArrayList<Type> list = new ArrayList<Type>();
            list.add((Type)part);
            return list;
        }
        List<Type> results = this.findTypeInOnDemandImports(simpleName);
        if (results != null) {
            return results;
        }
        return this.findTypeInImplicitSystemPackages(simpleName);
    }
}

