/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.edt.compiler.internal.core.lookup;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.edt.compiler.binding.FileBinding;
import org.eclipse.edt.compiler.binding.IPackageBinding;
import org.eclipse.edt.compiler.internal.core.dependency.IDependencyRequestor;
import org.eclipse.edt.compiler.internal.core.lookup.Scope;
import org.eclipse.edt.compiler.internal.util.BindingUtil;
import org.eclipse.edt.mof.egl.Member;
import org.eclipse.edt.mof.egl.Part;
import org.eclipse.edt.mof.egl.Type;
import org.eclipse.edt.mof.utils.NameUtile;

public class FileScope
extends Scope {
    protected FileBinding fileBinding;
    private List<IPackageBinding> importedPackages;
    private Map<String, Part> importedTypes = Collections.emptyMap();
    private IDependencyRequestor dependencyRequestor;
    private static List<String> implicitSystemPackages = new ArrayList<String>();

    static {
        implicitSystemPackages.add(NameUtile.getAsName((String)"eglx.lang"));
    }

    public FileScope(Scope parentScope, FileBinding fileBinding, IDependencyRequestor dependencyRequestor) {
        super(parentScope);
        this.fileBinding = fileBinding;
        this.dependencyRequestor = dependencyRequestor;
        this.importedPackages = fileBinding.getPackageBindings();
        List<Part> partBindings = fileBinding.getPartBindings();
        if (partBindings.size() > 0) {
            this.importedTypes = new HashMap<String, Part>();
        }
        for (Part partBinding : partBindings) {
            this.importedTypes.put(partBinding.getName(), partBinding);
        }
    }

    @Override
    public IPackageBinding findPackage(String simpleName) {
        return this.parentScope.findPackage(simpleName);
    }

    @Override
    public List<Type> findType(String simpleName) {
        this.dependencyRequestor.recordSimpleName(simpleName);
        Part result = null;
        result = this.findTypeUsingSingleTypeImports(simpleName);
        if (result != null) {
            ArrayList<Type> list = new ArrayList<Type>();
            list.add((Type)result);
            return list;
        }
        result = this.findTypeInDeclaringPackage(simpleName);
        if (result != null) {
            ArrayList<Type> list = new ArrayList<Type>();
            list.add((Type)result);
            return list;
        }
        List<Type> results = this.findTypeInOnDemandImports(simpleName);
        if (results != null) {
            return results;
        }
        return this.findTypeInImplicitSystemPackages(simpleName);
    }

    protected List<Type> findTypeInImplicitSystemPackages(String simpleName) {
        ArrayList<Type> parts = new ArrayList<Type>();
        for (String pkg : implicitSystemPackages) {
            Part temp = BindingUtil.getPart(this.fileBinding.getEnvironment().getPartBinding(pkg, simpleName));
            if (temp == null) continue;
            parts.add((Type)temp);
        }
        if (parts.isEmpty()) {
            return null;
        }
        return parts;
    }

    protected Part findTypeUsingSingleTypeImports(String simpleName) {
        Part result;
        if (this.importedTypes != null && (result = this.importedTypes.get(simpleName)) != null) {
            Part tempResult;
            if (!BindingUtil.isValid(result) && (tempResult = BindingUtil.getPart(this.fileBinding.getEnvironment().getPartBinding(result.getPackageName(), result.getName()))) != result) {
                this.importedTypes.remove(simpleName);
                this.importedTypes.put(simpleName, tempResult);
                result = tempResult;
            }
            return result;
        }
        return null;
    }

    protected Part findTypeInDeclaringPackage(String simpleName) {
        IPackageBinding declaringPackage = this.fileBinding.getDeclaringPackage();
        if (declaringPackage != null) {
            return BindingUtil.getPart(declaringPackage.resolveType(simpleName));
        }
        return null;
    }

    protected List<Type> findTypeInOnDemandImports(String simpleName) {
        IPackageBinding declaringPackage = this.fileBinding.getDeclaringPackage();
        ArrayList<Type> result = new ArrayList<Type>();
        for (IPackageBinding pkgBinding : this.importedPackages) {
            Part temp = BindingUtil.getPart(pkgBinding.resolveType(simpleName));
            if (temp == null || (declaringPackage == null || !NameUtile.equals((String)temp.getPackageName(), (String)declaringPackage.getPackageName())) && BindingUtil.isPrivate(temp)) continue;
            result.add((Type)temp);
        }
        if (result.isEmpty()) {
            return null;
        }
        return result;
    }

    @Override
    public List<Member> findMember(String simpleName) {
        return null;
    }
}

