/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.edt.compiler.internal.core.lookup;

import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import org.eclipse.edt.compiler.core.ast.AbstractASTExpressionVisitor;
import org.eclipse.edt.compiler.core.ast.ArrayAccess;
import org.eclipse.edt.compiler.core.ast.CallStatement;
import org.eclipse.edt.compiler.core.ast.DefaultASTVisitor;
import org.eclipse.edt.compiler.core.ast.Expression;
import org.eclipse.edt.compiler.core.ast.FieldAccess;
import org.eclipse.edt.compiler.core.ast.FunctionInvocation;
import org.eclipse.edt.compiler.core.ast.LiteralExpression;
import org.eclipse.edt.compiler.core.ast.Name;
import org.eclipse.edt.compiler.core.ast.Node;
import org.eclipse.edt.compiler.core.ast.ParenthesizedExpression;
import org.eclipse.edt.compiler.core.ast.QualifiedName;
import org.eclipse.edt.compiler.core.ast.SetValuesExpression;
import org.eclipse.edt.compiler.core.ast.SimpleName;
import org.eclipse.edt.compiler.core.ast.SubstringAccess;
import org.eclipse.edt.compiler.core.ast.SuperExpression;
import org.eclipse.edt.compiler.core.ast.TernaryExpression;
import org.eclipse.edt.compiler.core.ast.ThisExpression;
import org.eclipse.edt.compiler.internal.core.builder.IProblemRequestor;
import org.eclipse.edt.compiler.internal.core.lookup.ICompilerOptions;
import org.eclipse.edt.compiler.internal.core.validation.statement.LValueValidator;
import org.eclipse.edt.compiler.internal.core.validation.statement.RValueValidator;
import org.eclipse.edt.compiler.internal.core.validation.type.TypeValidator;
import org.eclipse.edt.compiler.internal.util.BindingUtil;
import org.eclipse.edt.mof.egl.ArrayType;
import org.eclipse.edt.mof.egl.Classifier;
import org.eclipse.edt.mof.egl.Delegate;
import org.eclipse.edt.mof.egl.FunctionMember;
import org.eclipse.edt.mof.egl.FunctionParameter;
import org.eclipse.edt.mof.egl.Member;
import org.eclipse.edt.mof.egl.NamedElement;
import org.eclipse.edt.mof.egl.ParameterKind;
import org.eclipse.edt.mof.egl.Type;
import org.eclipse.edt.mof.egl.utils.TypeUtils;

public class FunctionArgumentValidator
extends DefaultASTVisitor {
    private IProblemRequestor problemRequestor;
    private NamedElement functionBinding;
    private String canonicalFunctionName;
    private Iterator<FunctionParameter> parameterIter;
    private int numArgs;
    private Expression qualifier;
    private ICompilerOptions compilerOptions;

    public FunctionArgumentValidator(Delegate delegateBinding, IProblemRequestor problemRequestor, ICompilerOptions compilerOptions) {
        this.functionBinding = delegateBinding;
        this.parameterIter = delegateBinding.getParameters().iterator();
        this.problemRequestor = problemRequestor;
        this.compilerOptions = compilerOptions;
    }

    public FunctionArgumentValidator(FunctionMember functionBinding, IProblemRequestor problemRequestor, ICompilerOptions compilerOptions) {
        this.functionBinding = functionBinding;
        this.parameterIter = functionBinding.getParameters().iterator();
        this.problemRequestor = problemRequestor;
        this.compilerOptions = compilerOptions;
    }

    @Override
    public boolean visit(FunctionInvocation functionInvocation) {
        this.qualifier = functionInvocation;
        functionInvocation.getTarget().accept(new DefaultASTVisitor(){

            @Override
            public boolean visit(SimpleName simpleName) {
                FunctionArgumentValidator.this.canonicalFunctionName = simpleName.getCanonicalName();
                return false;
            }

            @Override
            public boolean visit(QualifiedName qualifiedName) {
                String canonicalName = qualifiedName.getCanonicalName();
                FunctionArgumentValidator.this.canonicalFunctionName = canonicalName.substring(canonicalName.lastIndexOf(46) + 1);
                return false;
            }
        });
        if (this.canonicalFunctionName == null) {
            this.canonicalFunctionName = functionInvocation.getTarget().getCanonicalString();
        }
        Iterator<Expression> iter = functionInvocation.getArguments().iterator();
        while (iter.hasNext()) {
            this.checkArg(iter.next());
        }
        return false;
    }

    @Override
    public void endVisit(FunctionInvocation functionInvocation) {
        this.checkCorrectNumberArguments(functionInvocation.getTarget());
    }

    @Override
    public boolean visit(CallStatement callStatement) {
        this.qualifier = callStatement.getInvocationTarget();
        this.canonicalFunctionName = callStatement.getInvocationTarget().getCanonicalString();
        if (!callStatement.hasArguments()) {
            return false;
        }
        for (Node expr : callStatement.getArguments()) {
            this.checkArg((Expression)expr);
        }
        return false;
    }

    @Override
    public void endVisit(CallStatement callStatement) {
        this.checkCorrectNumberArguments(callStatement.getInvocationTarget());
    }

    private void checkCorrectNumberArguments(Expression errorNode) {
        int parmCount = this.getFunctionParameterCount();
        if (parmCount != this.numArgs) {
            this.problemRequestor.acceptProblem((Node)errorNode, 5109, new String[]{this.canonicalFunctionName, Integer.toString(parmCount)});
        }
    }

    private int getFunctionParameterCount() {
        if (this.functionBinding instanceof Delegate) {
            return ((Delegate)this.functionBinding).getParameters().size();
        }
        if (this.functionBinding instanceof FunctionMember) {
            return ((FunctionMember)this.functionBinding).getParameters().size();
        }
        return -1;
    }

    public boolean checkArg(Expression argExpr) {
        ++this.numArgs;
        if (!this.parameterIter.hasNext()) {
            return false;
        }
        FunctionParameter parameterBinding = this.parameterIter.next();
        Type parameterType = parameterBinding.getType();
        if (!this.checkArgumentNotSetValuesExpression(argExpr)) {
            return false;
        }
        if (argExpr.resolveType() == null && argExpr.resolveMember() == null) {
            return false;
        }
        HashMap<Expression, Type> argMap = new HashMap<Expression, Type>();
        TypeValidator.collectExprsForTypeCompatibility(argExpr, argMap);
        if (!this.checkSubstringNotUsedAsArgument(parameterBinding, argMap)) {
            return false;
        }
        if (!this.checkArgumentUsedCorrectlyWithInAndOut(argMap, parameterBinding, parameterType)) {
            return false;
        }
        switch (parameterBinding.getParameterKind()) {
            case PARM_IN: {
                this.checkArgForInParameter(argMap, parameterBinding, parameterType, this.numArgs);
                break;
            }
            case PARM_OUT: {
                this.checkArgForOutParameter(argMap, parameterBinding, parameterType, this.numArgs);
                break;
            }
            case PARM_INOUT: {
                this.checkArgForInOutParameter(argMap, parameterBinding, parameterType, this.numArgs);
            }
        }
        return false;
    }

    private boolean checkArgumentNotSetValuesExpression(Expression argExpr) {
        final boolean[] result = new boolean[]{true};
        argExpr.accept(new DefaultASTVisitor(){

            @Override
            public boolean visit(ParenthesizedExpression parenthesizedExpression) {
                return true;
            }

            @Override
            public boolean visit(TernaryExpression ternaryExpression) {
                ternaryExpression.getSecondExpr().accept(this);
                ternaryExpression.getThirdExpr().accept(this);
                return false;
            }

            @Override
            public boolean visit(SetValuesExpression setValuesExpression) {
                FunctionArgumentValidator.this.problemRequestor.acceptProblem(setValuesExpression, 7511);
                result[0] = false;
                return false;
            }
        });
        return result[0];
    }

    private boolean checkSubstringNotUsedAsArgument(FunctionParameter parm, Map<Expression, Type> argMap) {
        boolean result = true;
        if (parm != null && parm.getParameterKind() != ParameterKind.PARM_IN) {
            for (Expression argExpr : argMap.keySet()) {
                if (!(argExpr instanceof SubstringAccess)) continue;
                this.problemRequestor.acceptProblem((Node)argExpr, 6649, new String[0]);
                result = false;
            }
        }
        return result;
    }

    private boolean checkArgumentUsedCorrectlyWithInAndOut(Map<Expression, Type> argMap, final FunctionParameter parmBinding, Type parmType) {
        boolean result = true;
        for (Map.Entry<Expression, Type> entry : argMap.entrySet()) {
            if (entry.getValue() == null) continue;
            Expression argExpr = entry.getKey();
            final boolean[] expressionIsLiteralOrName = new boolean[]{true};
            final boolean[] foundError = new boolean[1];
            argExpr.accept(new NonLiteralAndNonNameExpressionVisitor(){

                @Override
                void handleExpressionThatIsNotNameOrLiteral(Expression expression) {
                    if (parmBinding.getParameterKind() != ParameterKind.PARM_IN) {
                        FunctionArgumentValidator.this.problemRequestor.acceptProblem((Node)expression, 6674, new String[]{expression.getCanonicalString(), FunctionArgumentValidator.this.functionBinding.getCaseSensitiveName()});
                        foundError[0] = true;
                    }
                    expressionIsLiteralOrName[0] = false;
                }
            });
            if (foundError[0]) {
                result = false;
                continue;
            }
            if (!expressionIsLiteralOrName[0] || parmBinding.getParameterKind() == ParameterKind.PARM_IN || this.checkArgNotConstantOrLiteral(argExpr, parmBinding)) continue;
            result = false;
        }
        return result;
    }

    private boolean checkArgNotConstantOrLiteral(Expression argExpr, FunctionParameter parmBinding) {
        Member constMember;
        final int problemKind = parmBinding.getParameterKind() == ParameterKind.PARM_INOUT ? 6673 : 6675;
        Name constName = LValueValidator.findConstName(argExpr);
        Member member = constMember = constName == null ? null : constName.resolveMember();
        if (constMember != null) {
            boolean canPassConst = false;
            if (parmBinding.getParameterKind() == ParameterKind.PARM_INOUT && parmBinding.isConst().booleanValue()) {
                canPassConst = true;
            } else if (!(constName == argExpr || constMember.getType() != null && TypeUtils.isValueType((Type)constMember.getType()))) {
                canPassConst = true;
            }
            if (!canPassConst) {
                this.problemRequestor.acceptProblem((Node)argExpr, problemKind, new String[]{argExpr.getCanonicalString(), this.functionBinding.getCaseSensitiveName()});
            }
            return false;
        }
        final boolean[] foundError = new boolean[1];
        argExpr.accept(new AbstractASTExpressionVisitor(){

            @Override
            public void endVisitName(Name name) {
            }

            @Override
            public void endVisit(ArrayAccess arrayAccess) {
            }

            @Override
            public void endVisit(FieldAccess fieldAccess) {
            }

            @Override
            public void endVisit(SubstringAccess substringAccess) {
            }

            @Override
            public void endVisit(SuperExpression superExpression) {
            }

            @Override
            public void endVisit(ThisExpression thisExpression) {
            }

            @Override
            public void endVisitExpression(Expression expression) {
                FunctionArgumentValidator.this.problemRequestor.acceptProblem((Node)expression, problemKind, new String[]{expression.getCanonicalString(), FunctionArgumentValidator.this.functionBinding.getCaseSensitiveName()});
                foundError[0] = true;
            }
        });
        return !foundError[0];
    }

    private boolean checkArgForInOrOutParameter(Map<Expression, Type> argMap, FunctionParameter funcParmBinding, Type parmType, int argNum) {
        boolean result = true;
        for (Map.Entry<Expression, Type> entry : argMap.entrySet()) {
            Type qualType;
            Expression argExpr = entry.getKey();
            Type argType = entry.getValue();
            if (BindingUtil.isMoveCompatible(parmType = BindingUtil.resolveGenericType(parmType, this.qualifier), (Member)funcParmBinding, argType, argExpr) || TypeUtils.Type_NULLTYPE.equals(argType).booleanValue() && !funcParmBinding.isNullable() && BindingUtil.isUnresolvedGenericType(funcParmBinding.getType()) && (qualType = BindingUtil.getTypeForGenericQualifier(this.qualifier)) instanceof ArrayType && ((ArrayType)qualType).elementsNullable()) continue;
            this.problemRequestor.acceptProblem((Node)argExpr, 6731, new String[]{argExpr.getCanonicalString(), funcParmBinding.getCaseSensitiveName(), this.canonicalFunctionName, BindingUtil.getShortTypeString(argExpr, argType), BindingUtil.getShortTypeString(parmType)});
            result = false;
        }
        return result;
    }

    private boolean checkArgForInParameter(Map<Expression, Type> argMap, FunctionParameter funcParmBinding, Type parmType, int argNum) {
        boolean result = true;
        for (Map.Entry<Expression, Type> entry : argMap.entrySet()) {
            Expression argExpr = entry.getKey();
            Member argDBinding = argExpr.resolveMember();
            if (argDBinding != null && !new RValueValidator(this.problemRequestor, this.compilerOptions, argDBinding, argExpr).validate()) {
                result = false;
            }
            this.validateNotSuper(argExpr);
        }
        if (!result) {
            return false;
        }
        return this.checkArgForInOrOutParameter(argMap, funcParmBinding, parmType, argNum);
    }

    private boolean checkArgForOutParameter(Map<Expression, Type> argMap, final FunctionParameter funcParmBinding, Type parmType, int argNum) {
        boolean result = true;
        for (Map.Entry<Expression, Type> entry : argMap.entrySet()) {
            Expression argExpr = entry.getKey();
            Member argMember = argExpr.resolveMember();
            if (argMember != null && !new LValueValidator(this.problemRequestor, this.compilerOptions, argMember, argExpr, new LValueValidator.DefaultLValueValidationRules(){

                @Override
                public boolean canAssignToFunctionParmConst() {
                    return funcParmBinding.isConst();
                }

                @Override
                public boolean canAssignToConstantVariables() {
                    return funcParmBinding.isConst();
                }
            }).validate()) {
                result = false;
                continue;
            }
            this.validateNotThis(argExpr);
            this.validateNotSuper(argExpr);
        }
        if (!result) {
            return false;
        }
        return this.checkArgForInOrOutParameter(argMap, funcParmBinding, parmType, argNum);
    }

    private boolean checkArgForInOutParameter(Map<Expression, Type> argMap, final FunctionParameter funcParmBinding, Type parmType, int argNum) {
        boolean result = true;
        for (Map.Entry<Expression, Type> entry : argMap.entrySet()) {
            boolean argCompatible;
            Expression argExpr = entry.getKey();
            Type argType = entry.getValue();
            Member argMember = argExpr.resolveMember();
            if (argMember != null) {
                if (!new RValueValidator(this.problemRequestor, this.compilerOptions, argMember, argExpr).validate()) {
                    result = false;
                    continue;
                }
                if (!new LValueValidator(this.problemRequestor, this.compilerOptions, argMember, argExpr, new LValueValidator.DefaultLValueValidationRules(){

                    @Override
                    public boolean canAssignToFunctionReferences() {
                        return true;
                    }

                    @Override
                    public boolean canAssignToConstantVariables() {
                        return true;
                    }

                    @Override
                    public boolean canAssignToFunctionParmConst() {
                        return funcParmBinding.isConst();
                    }
                }).validate()) {
                    result = false;
                    continue;
                }
            }
            boolean bl = argCompatible = argMember == null || argMember.isNullable() == funcParmBinding.isNullable();
            if (argCompatible) {
                if (argType != null) {
                    argCompatible = BindingUtil.isReferenceCompatible(parmType, argType);
                } else if (argMember != null) {
                    argCompatible = TypeUtils.areCompatible((Classifier)parmType.getClassifier(), (NamedElement)argMember);
                }
            }
            if (!argCompatible) {
                this.problemRequestor.acceptProblem((Node)argExpr, 6716, new String[]{argExpr.getCanonicalString(), funcParmBinding.getCaseSensitiveName(), this.canonicalFunctionName, BindingUtil.getTypeName(argMember, argType), BindingUtil.getTypeName((Member)funcParmBinding)});
                result = false;
                continue;
            }
            this.validateNotThis(argExpr);
            this.validateNotSuper(argExpr);
        }
        return result;
    }

    private void validateNotThis(Expression expr) {
        DefaultASTVisitor visitor = new DefaultASTVisitor(){

            @Override
            public boolean visit(ThisExpression thisExpression) {
                FunctionArgumentValidator.this.problemRequestor.acceptProblem((Node)thisExpression, 6754, new String[0]);
                return false;
            }
        };
        expr.accept(visitor);
    }

    private void validateNotSuper(Expression expr) {
        DefaultASTVisitor visitor = new DefaultASTVisitor(){

            @Override
            public boolean visit(SuperExpression superExpression) {
                FunctionArgumentValidator.this.problemRequestor.acceptProblem((Node)superExpression, 6758, new String[0]);
                return false;
            }
        };
        expr.accept(visitor);
    }

    private static abstract class NonLiteralAndNonNameExpressionVisitor
    extends AbstractASTExpressionVisitor {
        private NonLiteralAndNonNameExpressionVisitor() {
        }

        @Override
        public void endVisit(ParenthesizedExpression parenthesizedExpression) {
            parenthesizedExpression.getExpression().accept(this);
        }

        @Override
        public void endVisitName(Name name) {
        }

        @Override
        public void endVisit(ArrayAccess arrayAccess) {
        }

        @Override
        public void endVisit(SubstringAccess substringAccess) {
        }

        @Override
        public void endVisit(FieldAccess fieldAccess) {
        }

        @Override
        public void endVisit(SuperExpression superExpression) {
        }

        @Override
        public void endVisit(ThisExpression thisExpression) {
        }

        @Override
        public void endVisitLiteral(LiteralExpression literal) {
        }

        @Override
        public void endVisitExpression(Expression expression) {
            this.handleExpressionThatIsNotNameOrLiteral(expression);
        }

        abstract void handleExpressionThatIsNotNameOrLiteral(Expression var1);
    }
}

