/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.edt.compiler.internal.core.lookup;

import org.eclipse.edt.compiler.core.ast.ClassDataDeclaration;
import org.eclipse.edt.compiler.core.ast.DefaultASTVisitor;
import org.eclipse.edt.compiler.core.ast.Name;
import org.eclipse.edt.compiler.core.ast.NestedFunction;
import org.eclipse.edt.compiler.core.ast.Node;
import org.eclipse.edt.compiler.core.ast.UseStatement;
import org.eclipse.edt.compiler.internal.core.builder.IProblemRequestor;
import org.eclipse.edt.compiler.internal.core.dependency.IDependencyRequestor;
import org.eclipse.edt.compiler.internal.core.lookup.DefaultBinder;
import org.eclipse.edt.compiler.internal.core.lookup.FunctionBinder;
import org.eclipse.edt.compiler.internal.core.lookup.FunctionContainerScope;
import org.eclipse.edt.compiler.internal.core.lookup.ICompilerOptions;
import org.eclipse.edt.compiler.internal.core.lookup.Scope;
import org.eclipse.edt.mof.egl.Constructor;
import org.eclipse.edt.mof.egl.Function;
import org.eclipse.edt.mof.egl.FunctionMember;
import org.eclipse.edt.mof.egl.Part;
import org.eclipse.edt.mof.egl.Type;

public abstract class FunctionContainerBinder
extends DefaultBinder {
    private Part functionContainerBinding;

    public FunctionContainerBinder(Part functionContainerBinding, Scope scope, IDependencyRequestor dependencyRequestor, IProblemRequestor problemRequestor, ICompilerOptions compilerOptions) {
        super(scope, functionContainerBinding, dependencyRequestor, problemRequestor, compilerOptions);
        this.functionContainerBinding = functionContainerBinding;
    }

    protected void preprocessPart(org.eclipse.edt.compiler.core.ast.Part part) {
        this.dependencyRequestor.recordFunctionContainerScope((FunctionContainerScope)this.currentScope);
        for (Node node : part.getContents()) {
            node.accept(new DefaultASTVisitor(){

                @Override
                public boolean visit(UseStatement useStatement) {
                    for (Name nextName : useStatement.getNames()) {
                        Type typeBinding = nextName.resolveType();
                        if (typeBinding == null || !(typeBinding instanceof Part)) continue;
                        ((FunctionContainerScope)FunctionContainerBinder.this.currentScope).addUsedPart((Part)typeBinding);
                    }
                    return false;
                }
            });
        }
    }

    protected void doneVisitingPart() {
    }

    @Override
    public boolean visit(ClassDataDeclaration classDataDeclaration) {
        if (classDataDeclaration.getSettingsBlockOpt() != null) {
            classDataDeclaration.getSettingsBlockOpt().accept(this);
        }
        if (classDataDeclaration.hasInitializer()) {
            classDataDeclaration.getInitializer().accept(this);
        }
        return false;
    }

    @Override
    public boolean visit(NestedFunction nestedFunction) {
        Function functionBinding = (Function)nestedFunction.getName().resolveMember();
        if (functionBinding != null) {
            FunctionBinder functionBinder = new FunctionBinder(this.functionContainerBinding, (FunctionMember)functionBinding, this.currentScope, this.dependencyRequestor, this.problemRequestor, this.compilerOptions);
            nestedFunction.accept(functionBinder);
        }
        return false;
    }

    @Override
    public boolean visit(org.eclipse.edt.compiler.core.ast.Constructor constructor) {
        Constructor constructorBinding = constructor.getBinding();
        if (constructorBinding != null) {
            FunctionBinder functionBinder = new FunctionBinder(this.functionContainerBinding, (FunctionMember)constructorBinding, this.currentScope, this.dependencyRequestor, this.problemRequestor, this.compilerOptions);
            constructor.accept(functionBinder);
        }
        return false;
    }
}

