/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.edt.compiler.internal.core.lookup;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.edt.compiler.binding.IPackageBinding;
import org.eclipse.edt.compiler.internal.core.lookup.Scope;
import org.eclipse.edt.compiler.internal.util.BindingUtil;
import org.eclipse.edt.mof.egl.Member;
import org.eclipse.edt.mof.egl.Part;
import org.eclipse.edt.mof.egl.Type;

public class FunctionContainerScope
extends Scope {
    Part functionContainerBinding;
    private List<Part> usedParts = new ArrayList<Part>();

    public FunctionContainerScope(Scope parentScope, Part functionContainerBinding) {
        super(parentScope);
        this.functionContainerBinding = functionContainerBinding;
    }

    public FunctionContainerScope(Scope parentScope, FunctionContainerScope fContainerScope) {
        super(parentScope);
        this.functionContainerBinding = fContainerScope.functionContainerBinding;
        this.usedParts = fContainerScope.usedParts;
    }

    @Override
    public List<Member> findMember(String simpleName) {
        List<Member> result = this.findMemberInPart(simpleName);
        if (result != null) {
            return result;
        }
        result = new ArrayList<Member>();
        for (Part part : this.usedParts) {
            List<Member> temp = BindingUtil.findMembers((Type)part, simpleName);
            if (temp == null) continue;
            result.addAll(temp);
        }
        if (result.isEmpty()) {
            return null;
        }
        return result;
    }

    @Override
    public IPackageBinding findPackage(String simpleName) {
        return this.parentScope.findPackage(simpleName);
    }

    @Override
    public List<Type> findType(String simpleName) {
        return this.parentScope.findType(simpleName);
    }

    public void addUsedPart(Part usedPart) {
        this.usedParts.add(usedPart);
    }

    @Override
    public Scope getScopeForKeywordThis() {
        return this;
    }

    @Override
    public Part getPart() {
        return this.functionContainerBinding;
    }

    protected List<Member> findMemberInPart(String id) {
        return BindingUtil.findMembers((Type)this.functionContainerBinding, id);
    }

    @Override
    public Type getType() {
        return this.functionContainerBinding;
    }
}

