/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.edt.compiler.internal.core.lookup;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.edt.compiler.binding.IPackageBinding;
import org.eclipse.edt.compiler.internal.core.lookup.Scope;
import org.eclipse.edt.compiler.internal.util.BindingUtil;
import org.eclipse.edt.mof.egl.Member;
import org.eclipse.edt.mof.egl.Type;

public class TypeScope
extends Scope {
    private Type type;

    public TypeScope(Scope parentScope, Type type) {
        super(parentScope);
        this.type = type;
    }

    @Override
    public List<Member> findMember(String simpleName) {
        List<Member> result = this.find(simpleName);
        if (result != null) {
            return result;
        }
        return this.parentScope.findMember(simpleName);
    }

    @Override
    public IPackageBinding findPackage(String simpleName) {
        return this.parentScope.findPackage(simpleName);
    }

    @Override
    public List<Type> findType(String simpleName) {
        return this.parentScope.findType(simpleName);
    }

    @Override
    public Type getType() {
        return this.type;
    }

    private List<Member> find(String simpleName) {
        Type myType = this.type;
        if (myType == null) {
            return null;
        }
        Member mbr = BindingUtil.createExplicitDynamicAccessMember(myType, simpleName);
        if (mbr != null) {
            ArrayList<Member> list = new ArrayList<Member>();
            list.add(mbr);
            return list;
        }
        myType = BindingUtil.getBaseType(myType);
        return BindingUtil.findMembers(myType, simpleName);
    }
}

