/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.edt.compiler.internal.core.validation.annotation;

import java.util.Map;
import org.eclipse.edt.compiler.core.ast.ClassDataDeclaration;
import org.eclipse.edt.compiler.core.ast.Name;
import org.eclipse.edt.compiler.core.ast.Node;
import org.eclipse.edt.compiler.internal.core.builder.IProblemRequestor;
import org.eclipse.edt.compiler.internal.core.lookup.ICompilerOptions;
import org.eclipse.edt.compiler.internal.core.validation.annotation.GetMethodAnnotationValueValidator;
import org.eclipse.edt.compiler.internal.core.validation.annotation.IAnnotationValidationRule;
import org.eclipse.edt.compiler.internal.core.validation.annotation.SetMethodAnnotationValueValidator;
import org.eclipse.edt.compiler.internal.util.BindingUtil;
import org.eclipse.edt.mof.egl.Annotation;
import org.eclipse.edt.mof.egl.Element;
import org.eclipse.edt.mof.egl.Function;
import org.eclipse.edt.mof.egl.Part;
import org.eclipse.edt.mof.egl.StructPart;
import org.eclipse.edt.mof.utils.NameUtile;

public class EGLPropertyValidator
implements IAnnotationValidationRule {
    @Override
    public void validate(Node errorNode, Node target, Element element, Map<String, Object> allAnnotationsAndFields, IProblemRequestor problemRequestor, ICompilerOptions compilerOptions) {
        Annotation ann = (Annotation)allAnnotationsAndFields.get(NameUtile.getAsName((String)"eglProperty"));
        if (allAnnotationsAndFields.get(NameUtile.getAsName((String)"getMethod")) == null && allAnnotationsAndFields.get(NameUtile.getAsName((String)"setMethod")) == null) {
            Part declaringPart = BindingUtil.getDeclaringPart(target);
            if (ann == null || !(declaringPart instanceof StructPart) || !(target instanceof ClassDataDeclaration)) {
                return;
            }
            ClassDataDeclaration decl = (ClassDataDeclaration)target;
            for (Name name : decl.getNames()) {
                String getterName = "get" + name.getCanonicalName();
                String setterName = "set" + name.getCanonicalName();
                Function getter = ((StructPart)declaringPart).getFunction(NameUtile.getAsName((String)getterName));
                Function setter = ((StructPart)declaringPart).getFunction(NameUtile.getAsName((String)setterName));
                if (getter != null) {
                    new GetMethodAnnotationValueValidator().validateGetMethod(errorNode, target, getter, declaringPart, problemRequestor, compilerOptions);
                } else {
                    problemRequestor.acceptProblem(errorNode, 6746, 2, new String[]{getterName});
                }
                if (setter != null) {
                    new SetMethodAnnotationValueValidator().validateSetMethod(errorNode, target, setter, declaringPart, problemRequestor, compilerOptions);
                    continue;
                }
                problemRequestor.acceptProblem(errorNode, 6746, 2, new String[]{setterName});
            }
        }
    }
}

