/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.edt.compiler.internal.core.validation.annotation;

import org.eclipse.edt.compiler.core.ast.Expression;
import org.eclipse.edt.compiler.core.ast.Node;
import org.eclipse.edt.compiler.internal.core.builder.IProblemRequestor;
import org.eclipse.edt.compiler.internal.core.lookup.ICompilerOptions;
import org.eclipse.edt.compiler.internal.core.validation.annotation.IFieldAccessAnnotationValidationRule;
import org.eclipse.edt.mof.egl.Annotation;
import org.eclipse.edt.mof.egl.Member;

public class PropertyFieldAccessValidator
implements IFieldAccessAnnotationValidationRule {
    @Override
    public boolean validateLValue(Expression lValue, Member fieldBinding, IProblemRequestor problemRequestor, ICompilerOptions compilerOptions) {
        if (this.hasGetterButNotSetter(fieldBinding)) {
            problemRequestor.acceptProblem((Node)lValue, 3423, new String[]{fieldBinding.getCaseSensitiveName()});
            return false;
        }
        return true;
    }

    @Override
    public boolean validateRValue(Expression rValue, Member fieldBinding, IProblemRequestor problemRequestor, ICompilerOptions compilerOptions) {
        if (this.hasSetterButNotGetter(fieldBinding)) {
            problemRequestor.acceptProblem((Node)rValue, 3424, new String[]{fieldBinding.getCaseSensitiveName()});
            return false;
        }
        return true;
    }

    protected Annotation getAnnotation(Member binding) {
        return binding.getAnnotation("eglx.lang.Property");
    }

    private boolean hasGetterButNotSetter(Member binding) {
        Annotation aBinding = this.getAnnotation(binding);
        if (aBinding != null) {
            return this.hasGet(aBinding) && !this.hasSet(aBinding);
        }
        return false;
    }

    private boolean hasGet(Annotation aBinding) {
        return this.hasValue(aBinding, "getMethod");
    }

    private boolean hasSet(Annotation aBinding) {
        return this.hasValue(aBinding, "setMethod");
    }

    private boolean hasValue(Annotation aBinding, String fieldName) {
        return this.hasValue(aBinding.getValue(fieldName));
    }

    protected boolean hasValue(Object obj) {
        return obj != null && obj.toString().length() > 0;
    }

    private boolean hasSetterButNotGetter(Member binding) {
        Annotation aBinding = this.getAnnotation(binding);
        if (aBinding != null) {
            return this.hasSet(aBinding) && !this.hasGet(aBinding);
        }
        return false;
    }
}

